/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rfb.FullFramePixelBuffer;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.PixelFormat;

public class ManagedPixelBuffer
extends FullFramePixelBuffer {
    protected int datasize = 0;
    static LogWriter vlog = new LogWriter("ManagedPixelBuffer");

    public ManagedPixelBuffer() {
        this.checkDataSize();
    }

    public ManagedPixelBuffer(PixelFormat pixelFormat, int n, int n2) {
        super(pixelFormat, n, n2, null);
        this.checkDataSize();
    }

    public void setPF(PixelFormat pixelFormat) {
        this.format = pixelFormat;
        this.checkDataSize();
    }

    public void setSize(int n, int n2) {
        this.width_ = n;
        this.height_ = n2;
        this.checkDataSize();
    }

    final void checkDataSize() {
        int n = this.width_ * this.height_;
        if (this.datasize < n) {
            vlog.debug("reallocating managed buffer (" + this.width_ + "x" + this.height_ + ")");
            if (this.format != null) {
                this.data = PixelFormat.getColorModel(this.format).createCompatibleWritableRaster(this.width_, this.height_);
            }
        }
    }
}

