/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.network.HttpMessage;

public abstract class VariantAbstractRPCQuery
implements Variant {
    private final Logger logger = Logger.getLogger(this.getClass());
    private final List<RPCParameter> listParam = new ArrayList<RPCParameter>();
    private final List<NameValuePair> params = new ArrayList<NameValuePair>();
    private String requestContent;

    @Override
    public void setMessage(HttpMessage httpMessage) {
        String string = httpMessage.getRequestHeader().getHeader("Content-Type");
        if (string != null && this.isValidContentType(string)) {
            try {
                this.setRequestContent(httpMessage.getRequestBody().toString());
            }
            catch (Exception exception) {
                this.logger.warn((Object)("Failed to parse the request body: " + exception.getMessage()), (Throwable)exception);
            }
        }
    }

    public void addParameter(String string, int n, int n2, boolean bl, boolean bl2) {
        RPCParameter rPCParameter = new RPCParameter();
        String string2 = this.requestContent.substring(n, n2);
        rPCParameter.setName(string);
        rPCParameter.setValue(bl2 ? this.getUnescapedValue(string2) : string2);
        rPCParameter.setBeginOffset(n);
        rPCParameter.setEndOffset(n2);
        rPCParameter.setToQuote(bl);
        this.listParam.add(rPCParameter);
    }

    public void addParameter(String string, int n, int n2, boolean bl, String string2) {
        RPCParameter rPCParameter = new RPCParameter();
        rPCParameter.setName(string);
        rPCParameter.setValue(string2);
        rPCParameter.setBeginOffset(n);
        rPCParameter.setEndOffset(n2);
        rPCParameter.setToQuote(bl);
        this.listParam.add(rPCParameter);
    }

    public String getToken(int n, int n2) {
        return this.requestContent.substring(n, n2);
    }

    @Override
    public List<NameValuePair> getParamList() {
        return this.params;
    }

    @Override
    public String setParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2) {
        return this.setParameter(httpMessage, nameValuePair, string, string2, false);
    }

    @Override
    public String setEscapedParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2) {
        return this.setParameter(httpMessage, nameValuePair, string, string2, true);
    }

    private String setParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2, boolean bl) {
        RPCParameter rPCParameter = this.listParam.get(nameValuePair.getPosition());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.requestContent.substring(0, rPCParameter.getBeginOffset()));
        stringBuilder.append(bl ? string2 : this.getEscapedValue(string2, rPCParameter.isToQuote()));
        stringBuilder.append(this.requestContent.substring(rPCParameter.getEndOffset()));
        String string3 = stringBuilder.toString();
        httpMessage.getRequestBody().setBody(string3);
        return string3;
    }

    protected void setRequestContent(String string) {
        this.requestContent = string;
        this.parseContent(string);
        Collections.sort(this.listParam);
        for (int i = 0; i < this.listParam.size(); ++i) {
            RPCParameter rPCParameter = this.listParam.get(i);
            this.params.add(new NameValuePair(2, rPCParameter.getName(), rPCParameter.getValue(), i));
        }
    }

    public String getReadableParametrizedQuery() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (RPCParameter rPCParameter : this.listParam) {
            int n2 = rPCParameter.getBeginOffset();
            stringBuilder.append(this.requestContent.substring(n, n2));
            stringBuilder.append("__INJECTABLE_PARAM__");
            n = rPCParameter.getEndOffset();
        }
        stringBuilder.append(this.requestContent.substring(n));
        return stringBuilder.toString();
    }

    public abstract boolean isValidContentType(String var1);

    public abstract void parseContent(String var1);

    public abstract String getEscapedValue(String var1, boolean var2);

    public abstract String getUnescapedValue(String var1);

    protected class RPCParameter
    implements Comparable<RPCParameter> {
        private String name;
        private String value;
        private int beginOffset;
        private int endOffset;
        private boolean toQuote;

        protected RPCParameter() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public int getBeginOffset() {
            return this.beginOffset;
        }

        public void setBeginOffset(int n) {
            this.beginOffset = n;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public void setEndOffset(int n) {
            this.endOffset = n;
        }

        public boolean isToQuote() {
            return this.toQuote;
        }

        public void setToQuote(boolean bl) {
            this.toQuote = bl;
        }

        @Override
        public int compareTo(RPCParameter rPCParameter) {
            return this.beginOffset - rPCParameter.beginOffset;
        }
    }
}

