/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMessage;

public class PopupMenuExportResponse
extends JMenuItem {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(PopupMenuExportResponse.class);
    private ExtensionHistory extension = null;

    public PopupMenuExportResponse() {
        super(Constant.messages.getString("history.export.response.popup"));
        this.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                List<HistoryReference> list = PopupMenuExportResponse.this.extension.getSelectedHistoryReferences();
                if (list.size() == 0) {
                    PopupMenuExportResponse.this.extension.getView().showWarningDialog(Constant.messages.getString("history.export.response.select.warning"));
                    return;
                }
                if (list.size() > 1) {
                    PopupMenuExportResponse.this.extension.getView().showWarningDialog(Constant.messages.getString("history.export.response.single.warning"));
                    return;
                }
                HttpMessage httpMessage = null;
                try {
                    httpMessage = list.get(0).getHttpMessage();
                }
                catch (Exception exception) {
                    PopupMenuExportResponse.this.extension.getView().showWarningDialog(Constant.messages.getString("history.export.response.read.warning"));
                    return;
                }
                if (httpMessage.getResponseHeader().isEmpty() || httpMessage.getResponseBody().length() == 0) {
                    PopupMenuExportResponse.this.extension.getView().showWarningDialog(Constant.messages.getString("history.export.response.body.warning"));
                    return;
                }
                File file = PopupMenuExportResponse.this.getOutputFile(httpMessage);
                if (file == null) {
                    return;
                }
                boolean bl = true;
                if (file.exists()) {
                    int n = PopupMenuExportResponse.this.extension.getView().showYesNoCancelDialog(Constant.messages.getString("file.overwrite.warning"));
                    if (n == 2) {
                        return;
                    }
                    if (n == 0) {
                        bl = false;
                    }
                }
                FilterOutputStream filterOutputStream = null;
                try {
                    filterOutputStream = new BufferedOutputStream(new FileOutputStream(file, bl));
                    PopupMenuExportResponse.this.exportHistory(httpMessage, (BufferedOutputStream)filterOutputStream);
                }
                catch (Exception exception) {
                    PopupMenuExportResponse.this.extension.getView().showWarningDialog(Constant.messages.getString("file.save.error") + file.getAbsolutePath() + ".");
                    log.warn((Object)exception.getMessage(), (Throwable)exception);
                }
                finally {
                    try {
                        filterOutputStream.close();
                    }
                    catch (Exception exception) {
                        log.warn((Object)exception.getMessage(), (Throwable)exception);
                    }
                }
            }
        });
    }

    void setExtension(ExtensionHistory extensionHistory) {
        this.extension = extensionHistory;
    }

    private void exportHistory(HttpMessage httpMessage, BufferedOutputStream bufferedOutputStream) {
        try {
            if (!httpMessage.getResponseHeader().isEmpty()) {
                bufferedOutputStream.write(httpMessage.getResponseBody().getBytes());
            }
        }
        catch (Exception exception) {
            log.warn((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    private File getOutputFile(HttpMessage httpMessage) {
        String string = "";
        try {
            string = httpMessage.getRequestHeader().getURI().getPath();
            int n = string.lastIndexOf("/");
            string = string.substring(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JFileChooser jFileChooser = new JFileChooser(this.extension.getModel().getOptionsParam().getUserDirectory());
        if (string.length() > 0) {
            jFileChooser.setSelectedFile(new File(string));
        }
        File file = null;
        int n = jFileChooser.showSaveDialog(this.extension.getView().getMainFrame());
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
            if (file == null) {
                return file;
            }
            this.extension.getModel().getOptionsParam().setUserDirectory(jFileChooser.getCurrentDirectory());
            return file;
        }
        return file;
    }
}

