/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.TimeStampUtils;
import org.zaproxy.zap.utils.ZapTextArea;

public class OutputPanel
extends AbstractPanel {
    private static final long serialVersionUID = -947074835463140074L;
    private static final Logger logger = Logger.getLogger(OutputPanel.class);
    private static final String CLEAR_BUTTON_LABEL = Constant.messages.getString("output.panel.clear.button.label");
    private static final String CLEAR_BUTTON_TOOL_TIP = Constant.messages.getString("output.panel.clear.button.toolTip");
    private JPanel mainPanel;
    private JToolBar mainToolBar;
    private JScrollPane jScrollPane = null;
    private ZapTextArea txtOutput = null;

    public OutputPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setName(Constant.messages.getString("output.panel.title"));
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(243, 119);
        }
        this.setIcon(new ImageIcon(OutputPanel.class.getResource("/resource/icon/16/172.png")));
        this.setDefaultAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1, false));
        this.setMnemonic(Constant.messages.getChar("output.panel.mnemonic"));
        this.add((Component)this.getMainPanel(), "Center");
        this.setShowByDefault(true);
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel(new BorderLayout());
            this.mainPanel.add((Component)this.getToolBar(), "First");
            this.mainPanel.add((Component)this.getJScrollPane(), "Center");
        }
        return this.mainPanel;
    }

    private JToolBar getToolBar() {
        if (this.mainToolBar == null) {
            this.mainToolBar = new JToolBar();
            this.mainToolBar.setEnabled(true);
            this.mainToolBar.setFloatable(false);
            this.mainToolBar.setRollover(true);
            JButton jButton = new JButton(CLEAR_BUTTON_LABEL);
            jButton.setToolTipText(CLEAR_BUTTON_TOOL_TIP);
            jButton.setIcon(DisplayUtils.getScaledIcon(new ImageIcon(OutputPanel.class.getResource("/resource/icon/fugue/broom.png"))));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OutputPanel.this.getTxtOutput().setText("");
                }
            });
            this.mainToolBar.add(jButton);
        }
        return this.mainToolBar;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTxtOutput());
            this.jScrollPane.setName("jScrollPane");
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
        }
        return this.jScrollPane;
    }

    private ZapTextArea getTxtOutput() {
        if (this.txtOutput == null) {
            this.txtOutput = new ZapTextArea();
            this.txtOutput.setEditable(false);
            this.txtOutput.setLineWrap(true);
            this.txtOutput.setName("");
            this.txtOutput.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    this.showPopupMenuIfTriggered(mouseEvent);
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    this.showPopupMenuIfTriggered(mouseEvent);
                }

                private void showPopupMenuIfTriggered(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        View.getSingleton().getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }
        return this.txtOutput;
    }

    @Deprecated
    public void appendDirty(String string) {
        this.doAppend(string);
    }

    public void append(final String string) {
        if (EventQueue.isDispatchThread()) {
            this.doAppend(string);
            return;
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    OutputPanel.this.doAppend(string);
                }
            });
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public void append(Exception exception) {
        this.append(ExceptionUtils.getStackTrace((Throwable)exception));
    }

    public void clear() {
        this.getTxtOutput().setText("");
    }

    private void doAppend(String string) {
        if (Model.getSingleton().getOptionsParam().getViewParam().isOutputTabTimeStampingEnabled()) {
            this.getTxtOutput().append(TimeStampUtils.getTimeStampedMessage(string, Model.getSingleton().getOptionsParam().getViewParam().getOutputTabTimeStampsFormat()));
        } else {
            this.getTxtOutput().append(string);
        }
    }

    public void appendAsync(final String string) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                OutputPanel.this.doAppend(string);
            }
        });
    }
}

