/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.AbstractAPIGenerator;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiImplementor;

public class NodeJSAPIGenerator
extends AbstractAPIGenerator {
    private final String HEADER = "/* Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright 2016 the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n";
    private static final Map<String, String> nameMap;

    public NodeJSAPIGenerator() {
        super("nodejs/api/zapv2");
    }

    public NodeJSAPIGenerator(String string, boolean bl) {
        super(string, bl);
    }

    @Deprecated
    public void generateNodeJSFiles(List<ApiImplementor> list) throws IOException {
        this.generateAPIFiles((List)list);
    }

    private void generateNodeJSElement(ApiElement apiElement, String string, String string2, Writer writer) throws IOException {
        Object object;
        boolean bl;
        String string3;
        block27: {
            string3 = NodeJSAPIGenerator.createClassName(string);
            bl = false;
            String string4 = apiElement.getDescriptionTag();
            if (string4 == null) {
                string4 = string + ".api." + string2 + "." + apiElement.getName();
            }
            try {
                object = this.getMessages().getString(string4);
                writer.write("/**\n");
                writer.write(" * " + (String)object + "\n");
                if (this.isOptional()) {
                    writer.write(" * This component is optional and therefore the API will only work if it is installed\n");
                }
                writer.write(" **/\n");
            }
            catch (Exception exception) {
                System.out.println("No i18n for: " + string4);
                if (!this.isOptional()) break block27;
                writer.write("/**\n");
                writer.write(" * This component is optional and therefore the API will only work if it is installed\n");
                writer.write(" **/\n");
            }
        }
        writer.write(string3 + ".prototype." + NodeJSAPIGenerator.createMethodName(apiElement.getName()) + " = function (");
        if (apiElement.getMandatoryParamNames() != null) {
            for (String string5 : apiElement.getMandatoryParamNames()) {
                if (!bl) {
                    bl = true;
                } else {
                    writer.write(", ");
                }
                writer.write(NodeJSAPIGenerator.safeName(string5.toLowerCase()));
            }
        }
        if (apiElement.getOptionalParamNames() != null) {
            for (String string5 : apiElement.getOptionalParamNames()) {
                if (!bl) {
                    bl = true;
                } else {
                    writer.write(", ");
                }
                writer.write(NodeJSAPIGenerator.safeName(string5.toLowerCase()));
            }
        }
        if (string2.equals("action") || string2.equals("other")) {
            if (bl) {
                writer.write(", ");
            }
            bl = true;
            writer.write(API.API_KEY_PARAM);
        }
        if (bl) {
            writer.write(", ");
        }
        writer.write("callback) {\n");
        if (string2.equals("action") || string2.equals("other")) {
            writer.write("  if (!callback && typeof(" + API.API_KEY_PARAM + ") === 'function') {\n");
            writer.write("    callback = " + API.API_KEY_PARAM + ";\n");
            writer.write("    " + API.API_KEY_PARAM + " = null;\n");
            writer.write("  }\n");
        }
        object = new StringBuilder();
        if (bl) {
            ((StringBuilder)object).append("{");
            boolean bl2 = true;
            if (apiElement.getMandatoryParamNames() != null) {
                for (String string6 : apiElement.getMandatoryParamNames()) {
                    if (bl2) {
                        bl2 = false;
                    } else {
                        ((StringBuilder)object).append(", ");
                    }
                    ((StringBuilder)object).append("'" + string6 + "' : " + NodeJSAPIGenerator.safeName(string6.toLowerCase()));
                }
            }
            if (string2.equals("action") || string2.equals("other")) {
                if (!bl2) {
                    ((StringBuilder)object).append(", ");
                }
                ((StringBuilder)object).append("'" + API.API_KEY_PARAM + "' : " + API.API_KEY_PARAM);
            }
            ((StringBuilder)object).append("}");
            if (apiElement.getOptionalParamNames() != null && !apiElement.getOptionalParamNames().isEmpty()) {
                writer.write("  var params = ");
                writer.write(((StringBuilder)object).toString());
                writer.write(";\n");
                ((StringBuilder)object).replace(0, ((StringBuilder)object).length(), "params");
                for (String string6 : apiElement.getOptionalParamNames()) {
                    writer.write("  if (" + NodeJSAPIGenerator.safeName(string6.toLowerCase()) + " && " + NodeJSAPIGenerator.safeName(string6.toLowerCase()) + " !== null) {\n");
                    writer.write("    params['" + string6 + "'] = " + NodeJSAPIGenerator.safeName(string6.toLowerCase()) + ";\n");
                    writer.write("  }\n");
                }
            }
        }
        String string7 = "request";
        if (string2.equals("other")) {
            string7 = "requestOther";
        }
        writer.write("  this.api." + string7 + "('/" + string + "/" + string2 + "/" + apiElement.getName() + "/'");
        if (bl) {
            writer.write(", ");
            writer.write(((StringBuilder)object).toString());
        }
        writer.write(", callback);\n");
        writer.write("};\n\n");
    }

    private static String safeName(String string) {
        if (nameMap.containsKey(string)) {
            return nameMap.get(string);
        }
        return string;
    }

    private static String createFileName(String string) {
        return NodeJSAPIGenerator.safeName(string) + ".js";
    }

    private static String createMethodName(String string) {
        return NodeJSAPIGenerator.removeAllFullStopCharacters(NodeJSAPIGenerator.safeName(string));
    }

    private static String createClassName(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    private static String removeAllFullStopCharacters(String string) {
        return string.replaceAll("\\.", "");
    }

    @Override
    protected void generateAPIFiles(ApiImplementor apiImplementor) throws IOException {
        String string = NodeJSAPIGenerator.createClassName(apiImplementor.getPrefix());
        Path path = this.getDirectory().resolve(NodeJSAPIGenerator.createFileName(apiImplementor.getPrefix()));
        System.out.println("Generating " + path.toAbsolutePath());
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            bufferedWriter.write("/* Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright 2016 the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n");
            bufferedWriter.write("'use strict';\n\n");
            bufferedWriter.write("/**\n");
            bufferedWriter.write(" * This file was automatically generated.\n");
            bufferedWriter.write(" */\n");
            bufferedWriter.write("function " + string + "(clientApi) {\n");
            bufferedWriter.write("  this.api = clientApi;\n");
            bufferedWriter.write("}\n\n");
            for (ApiElement apiElement : apiImplementor.getApiViews()) {
                this.generateNodeJSElement(apiElement, apiImplementor.getPrefix(), "view", bufferedWriter);
            }
            for (ApiElement apiElement : apiImplementor.getApiActions()) {
                this.generateNodeJSElement(apiElement, apiImplementor.getPrefix(), "action", bufferedWriter);
            }
            for (ApiElement apiElement : apiImplementor.getApiOthers()) {
                this.generateNodeJSElement(apiElement, apiImplementor.getPrefix(), "other", bufferedWriter);
            }
            bufferedWriter.write("module.exports = " + string + ";\n");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        NodeJSAPIGenerator nodeJSAPIGenerator = new NodeJSAPIGenerator();
        nodeJSAPIGenerator.generateCoreAPIFiles();
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("break", "brk");
        hashMap.put("boolean", "bool");
        hashMap.put("continue", "cont");
        nameMap = Collections.unmodifiableMap(hashMap);
    }
}

