/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.network.DomainMatcher;
import org.zaproxy.zap.view.AbstractMultipleOptionsTableModel;

public class PermittedAddressesTableModel
extends AbstractMultipleOptionsTableModel<DomainMatcher> {
    private static final long serialVersionUID = -5411351965957264957L;
    private static final String[] COLUMN_NAMES = new String[]{Constant.messages.getString("api.options.addr.table.header.enabled"), Constant.messages.getString("api.options.addr.table.header.regex"), Constant.messages.getString("api.options.addr.table.header.value")};
    private static final int COLUMN_COUNT = COLUMN_NAMES.length;
    private List<DomainMatcher> addresses = new ArrayList<DomainMatcher>(5);

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    @Override
    public int getRowCount() {
        return this.addresses.size();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return ((DomainMatcher)this.getElement(n)).isEnabled();
            }
            case 1: {
                return ((DomainMatcher)this.getElement(n)).isRegex();
            }
            case 2: {
                return ((DomainMatcher)this.getElement(n)).getValue();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0 && object instanceof Boolean) {
            this.addresses.get(n).setEnabled((Boolean)object);
            this.fireTableCellUpdated(n, n2);
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 0 || n == 1) {
            return Boolean.class;
        }
        return String.class;
    }

    public List<DomainMatcher> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<DomainMatcher> list) {
        this.addresses = new ArrayList<DomainMatcher>(list.size());
        for (DomainMatcher domainMatcher : list) {
            this.addresses.add(new DomainMatcher(domainMatcher));
        }
        this.fireTableDataChanged();
    }

    @Override
    public List<DomainMatcher> getElements() {
        return this.addresses;
    }
}

