/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.api.AbstractAPIGenerator;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiGeneratorUtils;
import org.zaproxy.zap.extension.api.ApiImplementor;

public class WikiAPIGenerator
extends AbstractAPIGenerator {
    private static final String WIKI_FILE_EXTENSION = ".md";
    private String base = "ApiGen_";
    private String title = "# ZAP " + Constant.PROGRAM_VERSION + " API\n";
    private int methods = 0;

    public WikiAPIGenerator() {
        super("../zaproxy-wiki");
    }

    public WikiAPIGenerator(String string, boolean bl) {
        super(string, bl);
    }

    private void generateWikiIndex() throws IOException {
        Path path = this.getDirectory().resolve(this.base + "Index" + WIKI_FILE_EXTENSION);
        System.out.println("Generating " + path.toAbsolutePath());
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            bufferedWriter.write(this.title);
            bufferedWriter.write("## Components\n");
            for (ApiImplementor apiImplementor : ApiGeneratorUtils.getAllImplementors()) {
                bufferedWriter.write("  * [" + this.base + apiImplementor.getPrefix() + " " + apiImplementor.getPrefix() + "]\n");
            }
            bufferedWriter.write("\n\n[" + this.base + "Full" + " Full list.]\n\n");
        }
    }

    private void generateWikiFull() throws IOException {
        Path path = this.getDirectory().resolve(this.base + "Full" + WIKI_FILE_EXTENSION);
        System.out.println("Generating " + path.toAbsolutePath());
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            bufferedWriter.write(this.title);
            bufferedWriter.write("## Full List\n");
            bufferedWriter.write("| _Component_ | _Name_ | _Type_ | _Parameters_ | _Description_ |\n");
            bufferedWriter.write("|:------------|:-------|:-------|:-------------|:--------------|\n");
            for (ApiImplementor apiImplementor : ApiGeneratorUtils.getAllImplementors()) {
                for (ApiElement apiElement : apiImplementor.getApiViews()) {
                    this.generateWikiElement(apiElement, apiImplementor.getPrefix(), "view", bufferedWriter, true);
                }
                for (ApiElement apiElement : apiImplementor.getApiActions()) {
                    this.generateWikiElement(apiElement, apiImplementor.getPrefix(), "action", bufferedWriter, true);
                }
                for (ApiElement apiElement : apiImplementor.getApiOthers()) {
                    this.generateWikiElement(apiElement, apiImplementor.getPrefix(), "other", bufferedWriter, true);
                }
            }
            bufferedWriter.write("\n");
            bufferedWriter.write("Starred parameters are mandatory.\n\n");
            if (this.isOptional()) {
                bufferedWriter.write("This component is optional and therefore the API will only work if it is installed\n\n");
            }
            bufferedWriter.write("Back to [index](" + this.base + "Index)\n\n");
        }
    }

    @Deprecated
    public void generateWikiFiles(List<ApiImplementor> list) throws IOException {
        this.generateAPIFiles(list);
    }

    @Override
    public void generateAPIFiles(List<ApiImplementor> list) throws IOException {
        this.generateWikiIndex();
        for (ApiImplementor apiImplementor : list) {
            this.generateAPIFiles(apiImplementor);
        }
        this.methods = 0;
        this.generateWikiFull();
        System.out.println("Generated a total of " + this.methods + " methods");
    }

    private void generateWikiElement(ApiElement apiElement, String string, String string2, Writer writer) throws IOException {
        this.generateWikiElement(apiElement, string, string2, writer, false);
    }

    private void generateWikiElement(ApiElement apiElement, String string, String string2, Writer writer, boolean bl) throws IOException {
        if (bl) {
            writer.write("| " + string);
        }
        writer.write("| " + apiElement.getName() + "| " + string2 + " | ");
        if (apiElement.getMandatoryParamNames() != null) {
            for (String string3 : apiElement.getMandatoryParamNames()) {
                writer.write(string3 + "* ");
            }
        }
        if (apiElement.getOptionalParamNames() != null) {
            for (String string3 : apiElement.getOptionalParamNames()) {
                writer.write(string3 + " ");
            }
        }
        writer.write(" | ");
        Object object = apiElement.getDescriptionTag();
        if (object == null) {
            object = string + ".api." + string2 + "." + apiElement.getName();
        }
        try {
            writer.write(this.getMessages().getString((String)object));
        }
        catch (Exception exception) {
            System.out.println("No i18n for: " + (String)object);
        }
        writer.write(" |\n");
        ++this.methods;
    }

    @Override
    protected void generateAPIFiles(ApiImplementor apiImplementor) throws IOException {
        Path path = this.getDirectory().resolve(this.base + apiImplementor.getPrefix() + WIKI_FILE_EXTENSION);
        System.out.println("Generating " + path.toAbsolutePath());
        try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            bufferedWriter.write(this.title);
            bufferedWriter.write("## Component: " + apiImplementor.getPrefix() + "\n");
            bufferedWriter.write("| _Name_ | _Type_ | _Parameters_ | _Description_ |\n");
            bufferedWriter.write("|:-------|:-------|:-------------|:--------------|\n");
            for (ApiElement apiElement : apiImplementor.getApiViews()) {
                this.generateWikiElement(apiElement, apiImplementor.getPrefix(), "view", bufferedWriter);
            }
            for (ApiElement apiElement : apiImplementor.getApiActions()) {
                this.generateWikiElement(apiElement, apiImplementor.getPrefix(), "action", bufferedWriter);
            }
            for (ApiElement apiElement : apiImplementor.getApiOthers()) {
                this.generateWikiElement(apiElement, apiImplementor.getPrefix(), "other", bufferedWriter);
            }
            bufferedWriter.write("\n");
            bufferedWriter.write("Starred parameters are mandatory\n\n");
            bufferedWriter.write("Back to [index](" + this.base + "Index)\n\n");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        WikiAPIGenerator wikiAPIGenerator = new WikiAPIGenerator();
        wikiAPIGenerator.generateCoreAPIFiles();
    }
}

