/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.util.ArrayList;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.apache.commons.lang.ObjectUtils;
import org.apache.log4j.Logger;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.autoupdate.ExtensionAutoUpdate;

public class AutoUpdateAPI
extends ApiImplementor {
    private static Logger log = Logger.getLogger(AutoUpdateAPI.class);
    private static final String PREFIX = "autoupdate";
    private static final String ACTION_DOWNLOAD_LATEST_RELEASE = "downloadLatestRelease";
    private static final String ACTION_INSTALL_ADDON = "installAddon";
    private static final String ACTION_UNINSTALL_ADDON = "uninstallAddon";
    private static final String VIEW_LATEST_VERSION_NUMBER = "latestVersionNumber";
    private static final String VIEW_IS_LATEST_VERSION = "isLatestVersion";
    private static final String VIEW_INSTALLED_ADDONS = "installedAddons";
    private static final String VIEW_NEW_ADDONS = "newAddons";
    private static final String VIEW_UPDATED_ADDONS = "updatedAddons";
    private static final String VIEW_MARKETPLACE_ADDONS = "marketplaceAddons";
    private static final String PARAM_ID = "id";
    private ExtensionAutoUpdate extension;

    public AutoUpdateAPI(ExtensionAutoUpdate extensionAutoUpdate) {
        this.extension = extensionAutoUpdate;
        this.addApiAction(new ApiAction(ACTION_DOWNLOAD_LATEST_RELEASE));
        this.addApiAction(new ApiAction(ACTION_INSTALL_ADDON, new String[]{PARAM_ID}));
        this.addApiAction(new ApiAction(ACTION_UNINSTALL_ADDON, new String[]{PARAM_ID}));
        this.addApiView(new ApiView(VIEW_LATEST_VERSION_NUMBER));
        this.addApiView(new ApiView(VIEW_IS_LATEST_VERSION));
        this.addApiView(new ApiView(VIEW_INSTALLED_ADDONS));
        this.addApiView(new ApiView(VIEW_NEW_ADDONS));
        this.addApiView(new ApiView(VIEW_UPDATED_ADDONS));
        this.addApiView(new ApiView(VIEW_MARKETPLACE_ADDONS));
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiAction(String string, JSONObject jSONObject) throws ApiException {
        log.debug((Object)("handleApiAction " + string + " " + jSONObject.toString()));
        if (ACTION_DOWNLOAD_LATEST_RELEASE.equals(string)) {
            if (this.downloadLatestRelease()) {
                return ApiResponseElement.OK;
            }
            return ApiResponseElement.FAIL;
        }
        if (ACTION_INSTALL_ADDON.equals(string)) {
            String string2 = jSONObject.getString(PARAM_ID);
            AddOn addOn = this.extension.getAddOn(string2);
            if (addOn == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            String string3 = this.extension.installAddOns(arrayList);
            if (string3.length() == 0) {
                return ApiResponseElement.OK;
            }
            throw new ApiException(ApiException.Type.INTERNAL_ERROR, string3);
        }
        if (ACTION_UNINSTALL_ADDON.equals(string)) {
            String string4 = jSONObject.getString(PARAM_ID);
            AddOn addOn = this.extension.getLocalVersionInfo().getAddOn(string4);
            if (addOn == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string4);
            String string5 = this.extension.uninstallAddOns(arrayList);
            if (string5.length() == 0) {
                return ApiResponseElement.OK;
            }
            throw new ApiException(ApiException.Type.INTERNAL_ERROR, string5);
        }
        throw new ApiException(ApiException.Type.BAD_ACTION);
    }

    @Override
    public ApiResponse handleApiView(String string, JSONObject jSONObject) throws ApiException {
        ApiResponse apiResponse;
        if (VIEW_LATEST_VERSION_NUMBER.equals(string)) {
            apiResponse = new ApiResponseElement(string, this.getLatestVersionNumber());
        } else if (VIEW_IS_LATEST_VERSION.equals(string)) {
            apiResponse = new ApiResponseElement(string, Boolean.toString(this.isLatestVersion()));
        } else if (VIEW_INSTALLED_ADDONS.equals(string)) {
            ApiResponseList apiResponseList = new ApiResponseList(string);
            for (AddOn addOn : this.extension.getInstalledAddOns()) {
                apiResponseList.addItem(this.addonToSet(addOn));
            }
            apiResponse = apiResponseList;
        } else if (VIEW_NEW_ADDONS.equals(string)) {
            ApiResponseList apiResponseList = new ApiResponseList(string);
            for (AddOn addOn : this.extension.getNewAddOns()) {
                apiResponseList.addItem(this.addonToSet(addOn));
            }
            apiResponse = apiResponseList;
        } else if (VIEW_UPDATED_ADDONS.equals(string)) {
            ApiResponseList apiResponseList = new ApiResponseList(string);
            for (AddOn addOn : this.extension.getUpdatedAddOns()) {
                apiResponseList.addItem(this.addonToSet(addOn));
            }
            apiResponse = apiResponseList;
        } else if (VIEW_MARKETPLACE_ADDONS.equals(string)) {
            ApiResponseList apiResponseList = new ApiResponseList(string);
            for (AddOn addOn : this.extension.getMarketplaceAddOns()) {
                apiResponseList.addItem(this.addonToSet(addOn));
            }
            apiResponse = apiResponseList;
        } else {
            throw new ApiException(ApiException.Type.BAD_VIEW);
        }
        return apiResponse;
    }

    private ApiResponseSet<String> addonToSet(AddOn addOn) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PARAM_ID, addOn.getId());
        hashMap.put("name", addOn.getName());
        hashMap.put("author", addOn.getAuthor());
        hashMap.put("changes", addOn.getChanges());
        hashMap.put("description", addOn.getDescription());
        hashMap.put("hash", ObjectUtils.toString((Object)addOn.getHash()));
        hashMap.put("infoUrl", ObjectUtils.toString((Object)addOn.getInfo()));
        hashMap.put("sizeInBytes", String.valueOf(addOn.getSize()));
        hashMap.put("status", addOn.getStatus().toString());
        hashMap.put("url", ObjectUtils.toString((Object)addOn.getUrl()));
        hashMap.put("fileVersion", String.valueOf(addOn.getFileVersion()));
        hashMap.put("version", ObjectUtils.toString((Object)addOn.getVersion()));
        return new ApiResponseSet<String>("addon", hashMap);
    }

    public String getLatestVersionNumber() {
        return this.extension.getLatestVersionNumber();
    }

    public boolean isLatestVersion() {
        return this.extension.isLatestVersion();
    }

    public boolean downloadLatestRelease() {
        return this.extension.downloadLatestRelease();
    }
}

