/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.brk;

import net.sf.json.JSONObject;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.brk.ExtensionBreak;
import org.zaproxy.zap.extension.httppanel.Message;

public class BreakAPI
extends ApiImplementor {
    private static final String PREFIX = "break";
    private static final String ACTION_BREAK = "break";
    private static final String ACTION_BREAK_ON_ID = "breakOnId";
    private static final String ACTION_ADD_HTTP_BREAK_POINT = "addHttpBreakpoint";
    private static final String ACTION_REM_HTTP_BREAK_POINT = "removeHttpBreakpoint";
    private static final String ACTION_CONTINUE = "continue";
    private static final String ACTION_STEP = "step";
    private static final String ACTION_DROP = "drop";
    private static final String ACTION_SET_HTTP_MESSAGE = "setHttpMessage";
    private static final String VIEW_IS_BREAK_ALL = "isBreakAll";
    private static final String VIEW_IS_BREAK_REQUEST = "isBreakRequest";
    private static final String VIEW_IS_BREAK_RESPONSE = "isBreakResponse";
    private static final String VIEW_HTTP_MESSAGE = "httpMessage";
    private static final String PARAM_STRING = "string";
    private static final String PARAM_LOCATION = "location";
    private static final String PARAM_MATCH = "match";
    private static final String PARAM_INVERSE = "inverse";
    private static final String PARAM_IGNORECASE = "ignorecase";
    private static final String PARAM_KEY = "key";
    private static final String PARAM_SCOPE = "scope";
    private static final String PARAM_STATE = "state";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_HTTP_HEADER = "httpHeader";
    private static final String PARAM_HTTP_BODY = "httpBody";
    private static final String VALUE_TYPE_HTTP_ALL = "http-all";
    private static final String VALUE_TYPE_HTTP_REQUESTS = "http-requests";
    private static final String VALUE_TYPE_HTTP_RESPONSES = "http-responses";
    private ExtensionBreak extension = null;

    public BreakAPI(ExtensionBreak extensionBreak) {
        this.extension = extensionBreak;
        this.addApiView(new ApiView(VIEW_IS_BREAK_ALL));
        this.addApiView(new ApiView(VIEW_IS_BREAK_REQUEST));
        this.addApiView(new ApiView(VIEW_IS_BREAK_RESPONSE));
        this.addApiView(new ApiView(VIEW_HTTP_MESSAGE));
        this.addApiAction(new ApiAction("break", new String[]{PARAM_TYPE, PARAM_STATE}, new String[]{PARAM_SCOPE}));
        this.addApiAction(new ApiAction(ACTION_SET_HTTP_MESSAGE, new String[]{PARAM_HTTP_HEADER}, new String[]{PARAM_HTTP_BODY}));
        this.addApiAction(new ApiAction(ACTION_CONTINUE));
        this.addApiAction(new ApiAction(ACTION_STEP));
        this.addApiAction(new ApiAction(ACTION_DROP));
        this.addApiAction(new ApiAction(ACTION_ADD_HTTP_BREAK_POINT, new String[]{PARAM_STRING, PARAM_LOCATION, PARAM_MATCH, PARAM_INVERSE, PARAM_IGNORECASE}));
        this.addApiAction(new ApiAction(ACTION_REM_HTTP_BREAK_POINT, new String[]{PARAM_STRING, PARAM_LOCATION, PARAM_MATCH, PARAM_INVERSE, PARAM_IGNORECASE}));
    }

    @Override
    public String getPrefix() {
        return "break";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ApiResponse handleApiAction(String string, JSONObject jSONObject) throws ApiException {
        if ("break".equals(string)) {
            String string2 = jSONObject.getString(PARAM_TYPE).toLowerCase();
            if (string2.equals(VALUE_TYPE_HTTP_ALL)) {
                this.extension.setBreakAllRequests(jSONObject.getBoolean(PARAM_STATE));
                this.extension.setBreakAllResponses(jSONObject.getBoolean(PARAM_STATE));
                return ApiResponseElement.OK;
            } else if (string2.equals(VALUE_TYPE_HTTP_REQUESTS)) {
                this.extension.setBreakAllRequests(jSONObject.getBoolean(PARAM_STATE));
                return ApiResponseElement.OK;
            } else {
                if (!string2.equals(VALUE_TYPE_HTTP_RESPONSES)) throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "type not in [http-all,http-requests,http-responses]");
                this.extension.setBreakAllResponses(jSONObject.getBoolean(PARAM_STATE));
            }
            return ApiResponseElement.OK;
        }
        if (ACTION_BREAK_ON_ID.equals(string)) {
            this.extension.setBreakOnId(jSONObject.getString(PARAM_KEY), jSONObject.getString(PARAM_STATE).toLowerCase().equals("on"));
            return ApiResponseElement.OK;
        }
        if (ACTION_CONTINUE.equals(string)) {
            this.extension.getBreakpointManagementInterface().cont();
            return ApiResponseElement.OK;
        }
        if (ACTION_STEP.equals(string)) {
            this.extension.getBreakpointManagementInterface().step();
            return ApiResponseElement.OK;
        }
        if (ACTION_DROP.equals(string)) {
            this.extension.getBreakpointManagementInterface().drop();
            return ApiResponseElement.OK;
        }
        if (ACTION_SET_HTTP_MESSAGE.equals(string)) {
            Message message;
            if (this.extension.getBreakpointManagementInterface().getMessage() == null) {
                throw new ApiException(ApiException.Type.DOES_NOT_EXIST);
            }
            String string3 = jSONObject.getString(PARAM_HTTP_HEADER);
            String string4 = this.getParam(jSONObject, PARAM_HTTP_BODY, "");
            if (string3.indexOf("\r\n") < 0 && string3.indexOf("\\n") >= 0) {
                string3 = string3.replace("\\r", "\r").replace("\\n", "\n");
            }
            if (!((message = this.extension.getBreakpointManagementInterface().getMessage()) instanceof HttpMessage)) return ApiResponseElement.OK;
            HttpMessage httpMessage = (HttpMessage)message;
            if (this.extension.getBreakpointManagementInterface().isRequest()) {
                try {
                    httpMessage.setRequestHeader(string3);
                    httpMessage.setRequestBody(string4);
                    this.extension.getBreakpointManagementInterface().setMessage(httpMessage, true);
                    return ApiResponseElement.OK;
                }
                catch (HttpMalformedHeaderException httpMalformedHeaderException) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, httpMalformedHeaderException.getMessage());
                }
            } else {
                try {
                    httpMessage.setResponseHeader(string3);
                    httpMessage.setResponseBody(string4);
                    this.extension.getBreakpointManagementInterface().setMessage(httpMessage, false);
                    return ApiResponseElement.OK;
                }
                catch (HttpMalformedHeaderException httpMalformedHeaderException) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, httpMalformedHeaderException.getMessage());
                }
            }
        }
        if (ACTION_ADD_HTTP_BREAK_POINT.equals(string)) {
            try {
                this.extension.addHttpBreakpoint(jSONObject.getString(PARAM_STRING), jSONObject.getString(PARAM_LOCATION), jSONObject.getString(PARAM_MATCH), jSONObject.getBoolean(PARAM_INVERSE), jSONObject.getBoolean(PARAM_IGNORECASE));
                return ApiResponseElement.OK;
            }
            catch (Exception exception) {
                throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, exception.getMessage());
            }
        }
        if (!ACTION_REM_HTTP_BREAK_POINT.equals(string)) throw new ApiException(ApiException.Type.BAD_ACTION);
        try {
            this.extension.removeHttpBreakpoint(jSONObject.getString(PARAM_STRING), jSONObject.getString(PARAM_LOCATION), jSONObject.getString(PARAM_MATCH), jSONObject.getBoolean(PARAM_INVERSE), jSONObject.getBoolean(PARAM_IGNORECASE));
            return ApiResponseElement.OK;
        }
        catch (Exception exception) {
            throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, exception.getMessage());
        }
    }

    @Override
    public ApiResponse handleApiView(String string, JSONObject jSONObject) throws ApiException {
        if (VIEW_IS_BREAK_ALL.equals(string)) {
            return new ApiResponseElement(string, Boolean.toString(this.extension.getBreakpointManagementInterface().isBreakAll()));
        }
        if (VIEW_IS_BREAK_REQUEST.equals(string)) {
            return new ApiResponseElement(string, Boolean.toString(this.extension.getBreakpointManagementInterface().isBreakRequest()));
        }
        if (VIEW_IS_BREAK_RESPONSE.equals(string)) {
            return new ApiResponseElement(string, Boolean.toString(this.extension.getBreakpointManagementInterface().isBreakResponse()));
        }
        if (VIEW_HTTP_MESSAGE.equals(string)) {
            Message message = this.extension.getBreakpointManagementInterface().getMessage();
            if (message == null) {
                return new ApiResponseElement(string, "");
            }
            if (message instanceof HttpMessage) {
                HttpMessage httpMessage = (HttpMessage)message;
                StringBuilder stringBuilder = new StringBuilder();
                if (this.extension.getBreakpointManagementInterface().isRequest()) {
                    stringBuilder.append(httpMessage.getRequestHeader().toString());
                    stringBuilder.append(httpMessage.getRequestBody().toString());
                } else {
                    stringBuilder.append(httpMessage.getResponseHeader().toString());
                    stringBuilder.append(httpMessage.getResponseBody().toString());
                }
                return new ApiResponseElement(string, stringBuilder.toString());
            }
            throw new ApiException(ApiException.Type.BAD_TYPE);
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }
}

