/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.parosproxy.paros.core.scanner.Plugin;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.extension.pscan.PassiveScanner;
import org.zaproxy.zap.utils.Enableable;

public abstract class PluginPassiveScanner
extends Enableable
implements PassiveScanner {
    private static final String PSCANS_KEY = "pscans.pscanner";
    private static final String ID_KEY = "id";
    private static final String CLASSNAME_KEY = "classname";
    private static final String LEVEL_KEY = "level";
    private static final String ENABLED_KEY = "enabled";
    private static final Integer[] DEFAULT_HISTORY_TYPES = new Integer[]{1, 15, 2, 10};
    private static final Set<Integer> DEFAULT_HISTORY_TYPES_SET = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(DEFAULT_HISTORY_TYPES)));
    private Plugin.AlertThreshold level = Plugin.AlertThreshold.DEFAULT;
    private Plugin.AlertThreshold defaultLevel = Plugin.AlertThreshold.MEDIUM;
    private Configuration config = null;
    private AddOn.Status status = AddOn.Status.unknown;

    public PluginPassiveScanner() {
        super(true);
    }

    public void setConfig(Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Parameter config must not be null.");
        }
        this.config = configuration;
        this.loadFrom(configuration);
    }

    public void loadFrom(Configuration configuration) {
        List list = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(PSCANS_KEY);
        for (HierarchicalConfiguration hierarchicalConfiguration : list) {
            if (!this.isPluginConfiguration((Configuration)hierarchicalConfiguration)) continue;
            this.setLevel(Plugin.AlertThreshold.valueOf(hierarchicalConfiguration.getString(LEVEL_KEY, Plugin.AlertThreshold.DEFAULT.name())));
            this.setEnabled(hierarchicalConfiguration.getBoolean(ENABLED_KEY, true));
            break;
        }
    }

    private boolean isPluginConfiguration(Configuration configuration) {
        return configuration.containsKey(ID_KEY) && this.getPluginId() == configuration.getInt(ID_KEY) || this.getClass().getCanonicalName().equals(configuration.getString(CLASSNAME_KEY, ""));
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void save() {
        Configuration configuration = this.getConfig();
        if (configuration == null) {
            throw new IllegalStateException("No configuration has been set.");
        }
        this.saveTo(configuration);
    }

    public void saveTo(Configuration configuration) {
        Object object2;
        boolean bl = false;
        List list = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(PSCANS_KEY);
        for (Object object2 : list) {
            if (!this.isPluginConfiguration((Configuration)object2)) continue;
            object2.getRootNode().getParentNode().removeChild(object2.getRootNode());
            bl = true;
            break;
        }
        boolean bl2 = false;
        object2 = "pscans.pscanner(" + (bl ? list.size() - 1 : list.size()) + ").";
        if (this.getLevel() != Plugin.AlertThreshold.MEDIUM) {
            configuration.setProperty((String)object2 + LEVEL_KEY, (Object)this.getLevel().name());
            bl2 = true;
        }
        if (!this.isEnabled()) {
            configuration.setProperty((String)object2 + ENABLED_KEY, (Object)Boolean.FALSE);
            bl2 = true;
        }
        if (bl2) {
            configuration.setProperty((String)object2 + ID_KEY, (Object)this.getPluginId());
        }
    }

    @Override
    public Plugin.AlertThreshold getLevel() {
        if (Plugin.AlertThreshold.DEFAULT.equals((Object)this.level)) {
            return this.defaultLevel;
        }
        return this.level;
    }

    public Plugin.AlertThreshold getLevel(boolean bl) {
        return this.level;
    }

    @Override
    public void setLevel(Plugin.AlertThreshold alertThreshold) {
        if (alertThreshold == null) {
            throw new IllegalArgumentException("Parameter level must not be null.");
        }
        this.level = alertThreshold;
    }

    public void setDefaultLevel(Plugin.AlertThreshold alertThreshold) {
        if (alertThreshold == null || alertThreshold == Plugin.AlertThreshold.DEFAULT) {
            throw new IllegalArgumentException("Parameter level must not be null or DEFAULT.");
        }
        this.defaultLevel = alertThreshold;
    }

    public int getPluginId() {
        return -1;
    }

    public AddOn.Status getStatus() {
        return this.status;
    }

    public void setStatus(AddOn.Status status) {
        if (status == null) {
            throw new IllegalArgumentException("Parameter status must not be null.");
        }
        this.status = status;
    }

    public static Set<Integer> getDefaultHistoryTypes() {
        return DEFAULT_HISTORY_TYPES_SET;
    }

    @Override
    public boolean appliesToHistoryType(int n) {
        return PluginPassiveScanner.getDefaultHistoryTypes().contains(n);
    }
}

