/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ruleconfig;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.ruleconfig.DialogEditRuleConfig;
import org.zaproxy.zap.extension.ruleconfig.ExtensionRuleConfig;
import org.zaproxy.zap.extension.ruleconfig.RuleConfig;
import org.zaproxy.zap.extension.ruleconfig.RuleConfigTableModel;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.MultipleOptionsTablePanel;

public class OptionsRuleConfigPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(OptionsRuleConfigPanel.class);
    private ExtensionRuleConfig extension;
    private RuleConfigOptionsPanel ruleConfigOptionsPanel;
    private JButton resetButton;
    private RuleConfigTableModel ruleConfigModel;

    public OptionsRuleConfigPanel(ExtensionRuleConfig extensionRuleConfig) {
        this.extension = extensionRuleConfig;
        this.initialize();
    }

    private void initialize() {
        this.setName(Constant.messages.getString("ruleconfig.options.title"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        this.ruleConfigOptionsPanel = new RuleConfigOptionsPanel(this.getRuleConfigModel());
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.ruleConfigOptionsPanel, LayoutHelper.getGBC(0, 0, 5, 1.0, 1.0, 1, 21, null));
        this.add((Component)new JLabel(), LayoutHelper.getGBC(0, 1, 1, 0.5, 0.0));
        this.add((Component)this.getResetButton(), LayoutHelper.getGBC(3, 1, 1, 0.0, 0.0));
        this.add((Component)new JLabel(), LayoutHelper.getGBC(4, 1, 1, 0.5, 0.0));
    }

    @Override
    public void initParam(Object object) {
        this.getRuleConfigModel().setRuleConfigs(this.extension.getAllRuleConfigs());
        this.ruleConfigOptionsPanel.packAll();
    }

    private JButton getResetButton() {
        if (this.resetButton == null) {
            this.resetButton = new JButton(Constant.messages.getString("ruleconfig.options.button.reset"));
            this.resetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (RuleConfig ruleConfig : OptionsRuleConfigPanel.this.getRuleConfigModel().getElements()) {
                        ruleConfig.reset();
                    }
                    OptionsRuleConfigPanel.this.getRuleConfigModel().fireTableDataChanged();
                }
            });
        }
        return this.resetButton;
    }

    @Override
    public void saveParam(Object object) throws Exception {
        for (RuleConfig ruleConfig : this.getRuleConfigModel().getElements()) {
            if (!ruleConfig.isChanged()) continue;
            logger.debug((Object)("Setting rule config " + ruleConfig.getKey() + " to " + ruleConfig.getValue()));
            this.extension.setRuleConfigValue(ruleConfig.getKey(), ruleConfig.getValue());
        }
    }

    private RuleConfigTableModel getRuleConfigModel() {
        if (this.ruleConfigModel == null) {
            this.ruleConfigModel = new RuleConfigTableModel();
        }
        return this.ruleConfigModel;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.ruleconfig";
    }

    private static class RuleConfigOptionsPanel
    extends MultipleOptionsTablePanel {
        private static final long serialVersionUID = -115340627058929308L;
        private DialogEditRuleConfig modifyDialog = null;
        private RuleConfigTableModel model;

        public RuleConfigOptionsPanel(final RuleConfigTableModel ruleConfigTableModel) {
            super(ruleConfigTableModel);
            this.model = ruleConfigTableModel;
            this.getTable().setSortOrder(0, SortOrder.ASCENDING);
            this.getTable().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    int n;
                    if (SwingUtilities.isLeftMouseButton(mouseEvent) && (n = RuleConfigOptionsPanel.this.getTable().getSelectedRow()) >= 0) {
                        RuleConfigOptionsPanel.this.showModifyDialogue(ruleConfigTableModel.getElements().get(RuleConfigOptionsPanel.this.getTable().convertRowIndexToModel(n)));
                    }
                }
            });
        }

        protected void packAll() {
            this.getTable().packAll();
        }

        public void showModifyDialogue(RuleConfig ruleConfig) {
            if (this.modifyDialog == null) {
                this.modifyDialog = new DialogEditRuleConfig((Window)View.getSingleton().getOptionsDialog(null));
                this.modifyDialog.pack();
            }
            this.modifyDialog.init(ruleConfig, this.model);
            this.modifyDialog.setVisible(true);
        }
    }
}

