/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SortOrder;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.script.ExtensionScript;
import org.zaproxy.zap.extension.script.OptionsScriptTableModel;
import org.zaproxy.zap.extension.script.ScriptParam;
import org.zaproxy.zap.view.AbstractMultipleOptionsBaseTablePanel;

public class OptionsScriptPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private ExtensionScript extension;
    private AntiCsrfMultipleOptionsPanel tokensOptionsPanel;
    private OptionsScriptTableModel scriptDirModel = null;

    public OptionsScriptPanel(ExtensionScript extensionScript) {
        this.extension = extensionScript;
        this.initialize();
    }

    private void initialize() {
        this.setName(Constant.messages.getString("options.script.title"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        this.add((Component)new JLabel(Constant.messages.getString("options.script.label.dirs")), gridBagConstraints);
        this.tokensOptionsPanel = new AntiCsrfMultipleOptionsPanel(this.extension, this.getScriptDirModel());
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tokensOptionsPanel, gridBagConstraints);
    }

    @Override
    public void initParam(Object object) {
        OptionsParam optionsParam = (OptionsParam)object;
        ScriptParam scriptParam = optionsParam.getParamSet(ScriptParam.class);
        this.getScriptDirModel().setTokens(scriptParam.getScriptDirs());
        this.tokensOptionsPanel.setRemoveWithoutConfirmation(!scriptParam.isConfirmRemoveDir());
    }

    @Override
    public void saveParam(Object object) throws Exception {
        OptionsParam optionsParam = (OptionsParam)object;
        ScriptParam scriptParam = optionsParam.getParamSet(ScriptParam.class);
        List<File> list = this.getScriptDirModel().getElements();
        for (File file : scriptParam.getScriptDirs()) {
            if (list.contains(file)) continue;
            this.extension.removeScriptsFromDir(file);
        }
        for (File file : list) {
            if (scriptParam.getScriptDirs().contains(file)) continue;
            this.extension.addScriptsFromDir(file);
        }
        scriptParam.setScriptDirs(list);
        scriptParam.setConfirmRemoveDir(!this.tokensOptionsPanel.isRemoveWithoutConfirmation());
    }

    private OptionsScriptTableModel getScriptDirModel() {
        if (this.scriptDirModel == null) {
            this.scriptDirModel = new OptionsScriptTableModel();
        }
        return this.scriptDirModel;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.script";
    }

    private static class AntiCsrfMultipleOptionsPanel
    extends AbstractMultipleOptionsBaseTablePanel<File> {
        private static final long serialVersionUID = -115340627058929308L;
        private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("options.script.dialog.dirs.remove.title");
        private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("options.script.dialog.dirs.remove.text");
        private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("options.script.dialog.dirs.remove.button.confirm");
        private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("options.script.dialog.dirs.remove.button.cancel");
        private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("options.script.dialog.dirs.remove.checkbox.label");
        private static ExtensionScript extension;

        public AntiCsrfMultipleOptionsPanel(ExtensionScript extensionScript, OptionsScriptTableModel optionsScriptTableModel) {
            super(optionsScriptTableModel);
            extension = extensionScript;
            this.getTable().setSortOrder(0, SortOrder.ASCENDING);
        }

        @Override
        public File showAddDialogue() {
            return this.showDirSelectDialog(null);
        }

        @Override
        public File showModifyDialogue(File file) {
            return this.showDirSelectDialog(file);
        }

        private File showDirSelectDialog(File file) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            if (jFileChooser.showOpenDialog(this) == 0) {
                File file2 = jFileChooser.getSelectedFile();
                if (extension.getScriptCount(file2) == 0) {
                    if (View.getSingleton().showConfirmDialog(this, Constant.messages.getString("options.script.dialog.dirs.noscripts.warning")) == 0) {
                        return file2;
                    }
                } else {
                    return file2;
                }
            }
            return null;
        }

        @Override
        public boolean showRemoveDialogue(File file) {
            JCheckBox jCheckBox = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
            Object[] objectArray = new Object[]{REMOVE_DIALOG_TEXT, " ", jCheckBox};
            int n = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), objectArray, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
            if (n == 0) {
                this.setRemoveWithoutConfirmation(jCheckBox.isSelected());
                return true;
            }
            return false;
        }
    }
}

