/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.search;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.httppanel.HttpPanel;
import org.zaproxy.zap.extension.search.ExtensionSearch;
import org.zaproxy.zap.extension.search.SearchMatch;

public class SearchResult {
    private ExtensionSearch.Type type;
    private String customSearcherName;
    private HttpMessage message;
    private String regEx;
    private String stringFound;
    private List<SearchMatch> matches = null;
    private SearchMatch lastMatch = null;

    public SearchResult(ExtensionSearch.Type type, String string, String string2, SearchMatch searchMatch) {
        this(type, null, string, string2, searchMatch);
    }

    public SearchResult(ExtensionSearch.Type type, String string, String string2, String string3, SearchMatch searchMatch) {
        this.message = searchMatch.getMessage();
        this.type = type;
        this.customSearcherName = string;
        this.regEx = string2;
        this.stringFound = string3;
        this.matches = new ArrayList<SearchMatch>(1);
        this.matches.add(searchMatch);
    }

    public SearchResult(HttpMessage httpMessage, ExtensionSearch.Type type, String string, String string2) {
        this.message = httpMessage;
        this.type = type;
        this.regEx = string;
        this.stringFound = string2;
    }

    public String getRegEx() {
        return this.regEx;
    }

    public String getStringFound() {
        return this.stringFound;
    }

    public void setStringFound(String string) {
        this.stringFound = string;
    }

    public HttpMessage getMessage() {
        return this.message;
    }

    public void setMessage(HttpMessage httpMessage) {
        this.message = httpMessage;
    }

    public ExtensionSearch.Type getType() {
        return this.type;
    }

    public String getCustomSearcherName() {
        return this.customSearcherName;
    }

    public void setType(ExtensionSearch.Type type) {
        this.type = type;
    }

    public SearchMatch getFirstMatch(HttpPanel httpPanel, HttpPanel httpPanel2) {
        if (this.matches == null) {
            this.enumerateMatches(httpPanel, httpPanel2);
        }
        if (this.matches.size() > 0) {
            this.lastMatch = this.matches.get(0);
            return this.lastMatch;
        }
        return null;
    }

    public SearchMatch getLastMatch(HttpPanel httpPanel, HttpPanel httpPanel2) {
        if (this.matches == null) {
            this.enumerateMatches(httpPanel, httpPanel2);
        }
        if (this.matches.size() > 0) {
            this.lastMatch = this.matches.get(this.matches.size() - 1);
            return this.lastMatch;
        }
        return null;
    }

    public SearchMatch getNextMatch() {
        int n;
        if (this.lastMatch != null && (n = this.matches.indexOf(this.lastMatch)) >= 0 && n < this.matches.size() - 1) {
            this.lastMatch = this.matches.get(n + 1);
            return this.lastMatch;
        }
        return null;
    }

    public SearchMatch getPrevMatch() {
        int n;
        if (this.lastMatch != null && (n = this.matches.indexOf(this.lastMatch)) >= 1) {
            this.lastMatch = this.matches.get(n - 1);
            return this.lastMatch;
        }
        return null;
    }

    private void enumerateMatches(HttpPanel httpPanel, HttpPanel httpPanel2) {
        this.matches = new ArrayList<SearchMatch>();
        Pattern pattern = Pattern.compile(this.regEx, 10);
        if (ExtensionSearch.Type.URL.equals((Object)this.type)) {
            httpPanel.headerSearch(pattern, this.matches);
            return;
        }
        if (ExtensionSearch.Type.Header.equals((Object)this.type)) {
            httpPanel.headerSearch(pattern, this.matches);
            return;
        }
        if (ExtensionSearch.Type.All.equals((Object)this.type) || ExtensionSearch.Type.Request.equals((Object)this.type)) {
            httpPanel.headerSearch(pattern, this.matches);
            httpPanel.bodySearch(pattern, this.matches);
        }
        if (ExtensionSearch.Type.All.equals((Object)this.type) || ExtensionSearch.Type.Response.equals((Object)this.type)) {
            httpPanel2.headerSearch(pattern, this.matches);
            httpPanel2.bodySearch(pattern, this.matches);
        }
    }
}

