/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;

public final class HttpUserAgent {
    private static final Logger logger = Logger.getLogger(HttpUserAgent.class);
    public static final String FireFox = "firefox";
    public static final String InternetExplorer = "internet explorer";
    private static final String MSIE = "msie";
    public static final String Chrome = "chrome";
    public static final String Safari = "safari";

    private static String searchForInternetExplorerVersion(String string) {
        return HttpUserAgent.searchVersionInFile(string, "internet-explorer-user-agents.txt");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String searchVersionInFile(String string, String string2) {
        try (BufferedReader bufferedReader = Files.newBufferedReader(Paths.get(Constant.getZapInstall(), "xml", string2), StandardCharsets.UTF_8);){
            String string3;
            block19: {
                String string4;
                string3 = "";
                while ((string4 = bufferedReader.readLine()) != null) {
                    if (string4.startsWith("#")) {
                        string3 = string4.substring(2, string4.length() - 1);
                        continue;
                    }
                    if (!string4.toLowerCase().equals(string)) {
                        continue;
                    }
                    break block19;
                }
                return "-1";
            }
            String string5 = string3;
            return string5;
        }
        catch (IOException iOException) {
            logger.debug((Object)("Error on opening/reading the file: " + string2), (Throwable)iOException);
        }
        return "-1";
    }

    private static String searchForFirefoxVersion(String string) {
        return HttpUserAgent.searchVersionInFile(string, "firefox-user-agents.txt");
    }

    private static String searchForChromeVersion(String string) {
        return HttpUserAgent.searchVersionInFile(string, "chrome-user-agents.txt");
    }

    private static String searchForSafariVersion(String string) {
        return HttpUserAgent.searchVersionInFile(string, "safari-user-agents.txt");
    }

    public static String getBrowser(String string) {
        if (string.toLowerCase().contains(FireFox)) {
            return FireFox;
        }
        if (string.toLowerCase().contains(MSIE)) {
            return InternetExplorer;
        }
        if (string.toLowerCase().contains(Chrome) || string.toLowerCase().contains(Chrome) && string.toLowerCase().contains(Safari)) {
            return Chrome;
        }
        if (string.toLowerCase().contains(Safari)) {
            return Safari;
        }
        return "-1";
    }

    public static String getBrowserVersion(String string) {
        if (string.toLowerCase().contains(FireFox)) {
            return HttpUserAgent.searchForFirefoxVersion(string);
        }
        if (string.toLowerCase().contains(MSIE)) {
            return HttpUserAgent.searchForInternetExplorerVersion(string);
        }
        if (string.toLowerCase().contains(Chrome) || string.toLowerCase().contains(Chrome) && string.toLowerCase().contains(Safari)) {
            return HttpUserAgent.searchForChromeVersion(string);
        }
        if (string.toLowerCase().contains(Safari)) {
            return HttpUserAgent.searchForSafariVersion(string);
        }
        return "-1";
    }
}

