/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractDialog;
import org.zaproxy.zap.extension.help.ExtensionHelp;
import org.zaproxy.zap.view.LayoutHelper;

public class PersistSessionDialog
extends AbstractDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel jPanel = null;
    private JButton startSessionButton = null;
    private JRadioButton persistRadioButton = null;
    private JRadioButton timestampRadioButton = null;
    private JRadioButton temporaryRadioButton = null;
    private JCheckBox dontAskAgainCheckbox = null;

    public PersistSessionDialog(Frame frame) {
        super(frame, true);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.initialize();
    }

    private void initialize() {
        this.setContentPane(this.getJPanel());
        this.pack();
        this.getRootPane().getActionMap().put("ESCAPE", null);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            JLabel jLabel = new JLabel(Constant.messages.getString("database.newsession.question"));
            this.jPanel.add((Component)jLabel, LayoutHelper.getGBC(0, 0, 2, 1.0, new Insets(4, 4, 4, 4)));
            this.jPanel.add((Component)this.getTimestampRadioButton(), LayoutHelper.getGBC(0, 1, 2, 1.0, new Insets(4, 4, 4, 4)));
            this.jPanel.add((Component)this.getPersistRadioButton(), LayoutHelper.getGBC(0, 3, 2, 1.0, new Insets(4, 4, 4, 4)));
            this.jPanel.add((Component)this.getTemporaryRadioButton(), LayoutHelper.getGBC(0, 5, 2, 1.0, new Insets(4, 4, 4, 4)));
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.getTimestampRadioButton());
            buttonGroup.add(this.getPersistRadioButton());
            buttonGroup.add(this.getTemporaryRadioButton());
            this.jPanel.add((Component)new JLabel(), LayoutHelper.getGBC(0, 6, 2, 1.0, 1.0));
            this.jPanel.add((Component)this.getDontAskAgainCheckbox(), LayoutHelper.getGBC(0, 7, 2, 1.0, new Insets(4, 4, 4, 4)));
            this.jPanel.add((Component)new JLabel(Constant.messages.getString("database.newsession.prompt.note")), LayoutHelper.getGBC(0, 8, 2, 1.0, new Insets(4, 4, 4, 4)));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            JButton jButton = new JButton(Constant.messages.getString("menu.help"));
            jButton.setToolTipText(Constant.messages.getString("help.dialog.button.tooltip"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExtensionHelp.showHelp("ui.dialogs.persistsession");
                }
            });
            jPanel.add((Component)jButton, LayoutHelper.getGBC(0, 0, 1, 0.0, new Insets(4, 4, 4, 4)));
            jPanel.add((Component)new JLabel(), LayoutHelper.getGBC(1, 0, 1, 1.0, new Insets(4, 4, 4, 4)));
            jPanel.add((Component)this.getStartSessionButton(), LayoutHelper.getGBC(2, 0, 1, 0.0, new Insets(4, 4, 4, 4)));
            this.jPanel.add((Component)jPanel, LayoutHelper.getGBC(0, 20, 2, 1.0, new Insets(4, 4, 4, 4)));
        }
        return this.jPanel;
    }

    private JRadioButton getPersistRadioButton() {
        if (this.persistRadioButton == null) {
            this.persistRadioButton = new JRadioButton(Constant.messages.getString("database.newsession.userspec"));
            this.persistRadioButton.addActionListener(this);
        }
        return this.persistRadioButton;
    }

    private JRadioButton getTimestampRadioButton() {
        if (this.timestampRadioButton == null) {
            this.timestampRadioButton = new JRadioButton(Constant.messages.getString("database.newsession.timestamped"));
            this.timestampRadioButton.addActionListener(this);
        }
        return this.timestampRadioButton;
    }

    private JRadioButton getTemporaryRadioButton() {
        if (this.temporaryRadioButton == null) {
            this.temporaryRadioButton = new JRadioButton(Constant.messages.getString("database.newsession.temporary"));
            this.temporaryRadioButton.addActionListener(this);
        }
        return this.temporaryRadioButton;
    }

    private JCheckBox getDontAskAgainCheckbox() {
        if (this.dontAskAgainCheckbox == null) {
            this.dontAskAgainCheckbox = new JCheckBox(Constant.messages.getString("database.newsession.prompt.label"));
        }
        return this.dontAskAgainCheckbox;
    }

    public boolean isPersistChosen() {
        return this.getPersistRadioButton().isSelected();
    }

    public void setPersistChosen() {
        this.getPersistRadioButton().setSelected(true);
        this.getStartSessionButton().setEnabled(true);
    }

    public boolean isTimestampChosen() {
        return this.getTimestampRadioButton().isSelected();
    }

    public void setTimestampChosen() {
        this.getTimestampRadioButton().setSelected(true);
        this.getStartSessionButton().setEnabled(true);
    }

    public boolean isTemporaryChosen() {
        return this.getTemporaryRadioButton().isSelected();
    }

    public void setTemporaryChosen() {
        this.getTemporaryRadioButton().setSelected(true);
        this.getStartSessionButton().setEnabled(true);
    }

    public boolean isDontAskAgain() {
        return this.getDontAskAgainCheckbox().isSelected();
    }

    private JButton getStartSessionButton() {
        if (this.startSessionButton == null) {
            this.startSessionButton = new JButton();
            this.startSessionButton.setText(Constant.messages.getString("database.newsession.button.start"));
            this.startSessionButton.setEnabled(false);
            this.startSessionButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PersistSessionDialog.this.dispose();
                }
            });
        }
        return this.startSessionButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.getStartSessionButton().setEnabled(this.getTimestampRadioButton().isSelected() || this.getPersistRadioButton().isSelected() || this.getTemporaryRadioButton().isSelected());
    }
}

