/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceStorm;

import com.zeroc.Ice.Current;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.IdentitySeqHelper;
import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.Object;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OperationMode;
import com.zeroc.Ice.OperationNotExistException;
import com.zeroc.Ice.OutputStream;
import com.zeroc.Ice.UserException;
import com.zeroc.IceInternal.Incoming;
import com.zeroc.IceStorm.AlreadySubscribed;
import com.zeroc.IceStorm.BadQoS;
import com.zeroc.IceStorm.InvalidSubscriber;
import com.zeroc.IceStorm.LinkExists;
import com.zeroc.IceStorm.LinkInfo;
import com.zeroc.IceStorm.LinkInfoSeqHelper;
import com.zeroc.IceStorm.NoSuchLink;
import com.zeroc.IceStorm.QoSHelper;
import com.zeroc.IceStorm.TopicPrx;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletionStage;

public interface Topic
extends Object {
    public static final String[] _iceIds;
    public static final String[] _iceOps;

    public String getName(Current var1);

    public ObjectPrx getPublisher(Current var1);

    public ObjectPrx getNonReplicatedPublisher(Current var1);

    public ObjectPrx subscribeAndGetPublisher(Map<String, String> var1, ObjectPrx var2, Current var3) throws AlreadySubscribed, BadQoS, InvalidSubscriber;

    public void unsubscribe(ObjectPrx var1, Current var2);

    public void link(TopicPrx var1, int var2, Current var3) throws LinkExists;

    public void unlink(TopicPrx var1, Current var2) throws NoSuchLink;

    public LinkInfo[] getLinkInfoSeq(Current var1);

    public Identity[] getSubscribers(Current var1);

    public void destroy(Current var1);

    @Override
    default public String[] ice_ids(Current current) {
        return _iceIds;
    }

    @Override
    default public String ice_id(Current current) {
        return Topic.ice_staticId();
    }

    public static String ice_staticId() {
        return "::IceStorm::Topic";
    }

    public static CompletionStage<OutputStream> _iceD_getName(Topic obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        String ret = obj.getName(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeString(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getPublisher(Topic obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        ObjectPrx ret = obj.getPublisher(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getNonReplicatedPublisher(Topic obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        ObjectPrx ret = obj.getNonReplicatedPublisher(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_subscribeAndGetPublisher(Topic obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        Map<String, String> iceP_theQoS = QoSHelper.read(istr);
        ObjectPrx iceP_subscriber = istr.readProxy();
        inS.endReadParams();
        ObjectPrx ret = obj.subscribeAndGetPublisher(iceP_theQoS, iceP_subscriber, current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_unsubscribe(Topic obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        InputStream istr = inS.startReadParams();
        ObjectPrx iceP_subscriber = istr.readProxy();
        inS.endReadParams();
        obj.unsubscribe(iceP_subscriber, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_link(Topic obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        TopicPrx iceP_linkTo = TopicPrx.uncheckedCast(istr.readProxy());
        int iceP_cost = istr.readInt();
        inS.endReadParams();
        obj.link(iceP_linkTo, iceP_cost, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_unlink(Topic obj, Incoming inS, Current current) throws UserException {
        Object._iceCheckMode(null, current.mode);
        InputStream istr = inS.startReadParams();
        TopicPrx iceP_linkTo = TopicPrx.uncheckedCast(istr.readProxy());
        inS.endReadParams();
        obj.unlink(iceP_linkTo, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    public static CompletionStage<OutputStream> _iceD_getLinkInfoSeq(Topic obj, Incoming inS, Current current) {
        Object._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        LinkInfo[] ret = obj.getLinkInfoSeq(current);
        OutputStream ostr = inS.startWriteParams();
        LinkInfoSeqHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_getSubscribers(Topic obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, current.mode);
        inS.readEmptyParams();
        Identity[] ret = obj.getSubscribers(current);
        OutputStream ostr = inS.startWriteParams();
        IdentitySeqHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    public static CompletionStage<OutputStream> _iceD_destroy(Topic obj, Incoming inS, Current current) {
        Object._iceCheckMode(null, current.mode);
        inS.readEmptyParams();
        obj.destroy(current);
        return inS.setResult(inS.writeEmptyParams());
    }

    @Override
    default public CompletionStage<OutputStream> _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_iceOps, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return Topic._iceD_destroy(this, in, current);
            }
            case 1: {
                return Topic._iceD_getLinkInfoSeq(this, in, current);
            }
            case 2: {
                return Topic._iceD_getName(this, in, current);
            }
            case 3: {
                return Topic._iceD_getNonReplicatedPublisher(this, in, current);
            }
            case 4: {
                return Topic._iceD_getPublisher(this, in, current);
            }
            case 5: {
                return Topic._iceD_getSubscribers(this, in, current);
            }
            case 6: {
                return Object._iceD_ice_id(this, in, current);
            }
            case 7: {
                return Object._iceD_ice_ids(this, in, current);
            }
            case 8: {
                return Object._iceD_ice_isA(this, in, current);
            }
            case 9: {
                return Object._iceD_ice_ping(this, in, current);
            }
            case 10: {
                return Topic._iceD_link(this, in, current);
            }
            case 11: {
                return Topic._iceD_subscribeAndGetPublisher(this, in, current);
            }
            case 12: {
                return Topic._iceD_unlink(this, in, current);
            }
            case 13: {
                return Topic._iceD_unsubscribe(this, in, current);
            }
        }
        if (!1.$assertionsDisabled) {
            throw new AssertionError();
        }
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        _iceIds = new String[]{"::Ice::Object", "::IceStorm::Topic"};
        _iceOps = new String[]{"destroy", "getLinkInfoSeq", "getName", "getNonReplicatedPublisher", "getPublisher", "getSubscribers", "ice_id", "ice_ids", "ice_isA", "ice_ping", "link", "subscribeAndGetPublisher", "unlink", "unsubscribe"};
    }
}

