/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceDiscovery;

import com.zeroc.Ice.Current;
import com.zeroc.Ice.Endpoint;
import com.zeroc.Ice.EndpointInfo;
import com.zeroc.Ice.IPEndpointInfo;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.Properties;
import com.zeroc.Ice.UDPEndpointInfo;
import com.zeroc.IceDiscovery.LocatorRegistryI;
import com.zeroc.IceDiscovery.Lookup;
import com.zeroc.IceDiscovery.LookupPrx;
import com.zeroc.IceDiscovery.LookupReplyPrx;
import com.zeroc.IceInternal.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

class LookupI
implements Lookup {
    private LocatorRegistryI _registry;
    private LookupPrx _lookup;
    private Map<LookupPrx, LookupReplyPrx> _lookups = new HashMap<LookupPrx, LookupReplyPrx>();
    private final int _timeout;
    private final int _retryCount;
    private final int _latencyMultiplier;
    private final String _domainId;
    private final ScheduledExecutorService _timer;
    private boolean _warnOnce = true;
    private Map<Identity, ObjectRequest> _objectRequests = new HashMap<Identity, ObjectRequest>();
    private Map<String, AdapterRequest> _adapterRequests = new HashMap<String, AdapterRequest>();

    public LookupI(LocatorRegistryI registry, LookupPrx lookup, Properties properties) {
        this._registry = registry;
        this._lookup = lookup;
        this._timeout = properties.getPropertyAsIntWithDefault("IceDiscovery.Timeout", 300);
        this._retryCount = properties.getPropertyAsIntWithDefault("IceDiscovery.RetryCount", 3);
        this._latencyMultiplier = properties.getPropertyAsIntWithDefault("IceDiscovery.LatencyMultiplier", 1);
        this._domainId = properties.getProperty("IceDiscovery.DomainId");
        this._timer = Util.getInstance(lookup.ice_getCommunicator()).timer();
        Endpoint[] single = new Endpoint[1];
        Endpoint[] endpointArray = lookup.ice_getEndpoints();
        int n = endpointArray.length;
        for (int i = 0; i < n; ++i) {
            Endpoint endpt;
            single[0] = endpt = endpointArray[i];
            this._lookups.put(lookup.ice_endpoints(single), null);
        }
        assert (!this._lookups.isEmpty());
    }

    void setLookupReply(LookupReplyPrx lookupReply) {
        Endpoint[] single = new Endpoint[1];
        for (Map.Entry<LookupPrx, LookupReplyPrx> entry : this._lookups.entrySet()) {
            UDPEndpointInfo info = (UDPEndpointInfo)entry.getKey().ice_getEndpoints()[0].getInfo();
            if (!info.mcastInterface.isEmpty()) {
                for (Endpoint q : lookupReply.ice_getEndpoints()) {
                    EndpointInfo r = q.getInfo();
                    if (!(r instanceof IPEndpointInfo) || !((IPEndpointInfo)r).host.equals(info.mcastInterface)) continue;
                    single[0] = q;
                    entry.setValue(lookupReply.ice_endpoints(single));
                }
            }
            if (entry.getValue() != null) continue;
            entry.setValue(lookupReply);
        }
    }

    @Override
    public void findObjectById(String domainId, Identity id, LookupReplyPrx reply, Current c) {
        if (!domainId.equals(this._domainId)) {
            return;
        }
        ObjectPrx proxy = this._registry.findObject(id);
        if (proxy != null) {
            try {
                reply.foundObjectByIdAsync(id, proxy);
            }
            catch (LocalException localException) {
                // empty catch block
            }
        }
    }

    @Override
    public void findAdapterById(String domainId, String adapterId, LookupReplyPrx reply, Current c) {
        if (!domainId.equals(this._domainId)) {
            return;
        }
        LocatorRegistryI.FindAdapterResult r = this._registry.findAdapter(adapterId);
        if (r.returnValue != null) {
            try {
                reply.foundAdapterByIdAsync(adapterId, r.returnValue, r.isReplicaGroup);
            }
            catch (LocalException localException) {
                // empty catch block
            }
        }
    }

    synchronized void findObject(CompletableFuture<ObjectPrx> f, Identity id) {
        ObjectRequest request = this._objectRequests.get(id);
        if (request == null) {
            request = new ObjectRequest(id, this._retryCount);
            this._objectRequests.put(id, request);
        }
        if (request.addFuture(f)) {
            try {
                request.invoke(this._domainId, this._lookups);
                request.scheduleTimer(this._timeout);
            }
            catch (LocalException ex) {
                request.finished(null);
                this._objectRequests.remove(id);
            }
        }
    }

    synchronized void findAdapter(CompletableFuture<ObjectPrx> f, String adapterId) {
        AdapterRequest request = this._adapterRequests.get(adapterId);
        if (request == null) {
            request = new AdapterRequest(adapterId, this._retryCount);
            this._adapterRequests.put(adapterId, request);
        }
        if (request.addFuture(f)) {
            try {
                request.invoke(this._domainId, this._lookups);
                request.scheduleTimer(this._timeout);
            }
            catch (LocalException ex) {
                request.finished(null);
                this._adapterRequests.remove(adapterId);
            }
        }
    }

    synchronized void foundObject(Identity id, String requestId, ObjectPrx proxy) {
        ObjectRequest request = this._objectRequests.get(id);
        if (request != null && request.getRequestId().equals(requestId)) {
            request.response(proxy);
            request.cancelTimer();
            this._objectRequests.remove(id);
        }
    }

    synchronized void foundAdapter(String adapterId, String requestId, ObjectPrx proxy, boolean isReplicaGroup) {
        AdapterRequest request = this._adapterRequests.get(adapterId);
        if (request != null && request.getRequestId().equals(requestId) && request.response(proxy, isReplicaGroup)) {
            request.cancelTimer();
            this._adapterRequests.remove(adapterId);
        }
    }

    synchronized void objectRequestTimedOut(ObjectRequest request) {
        ObjectRequest r = this._objectRequests.get(request.getId());
        if (r == null || request != r) {
            return;
        }
        if (request.retry()) {
            try {
                request.invoke(this._domainId, this._lookups);
                request.scheduleTimer(this._timeout);
                return;
            }
            catch (LocalException localException) {
                // empty catch block
            }
        }
        request.finished(null);
        this._objectRequests.remove(request.getId());
    }

    synchronized void objectRequestException(ObjectRequest request, Throwable ex) {
        ObjectRequest r = this._objectRequests.get(request.getId());
        if (r == null || r != request) {
            return;
        }
        if (request.exception()) {
            if (this._warnOnce) {
                StringBuilder s = new StringBuilder();
                s.append("failed to lookup object `");
                s.append(this._lookup.ice_getCommunicator().identityToString((Identity)request.getId()));
                s.append("' with lookup proxy `");
                s.append(this._lookup);
                s.append("':\n");
                s.append(ex.toString());
                this._lookup.ice_getCommunicator().getLogger().warning(s.toString());
                this._warnOnce = false;
            }
            request.cancelTimer();
            this._objectRequests.remove(request.getId());
        }
    }

    synchronized void adapterRequestTimedOut(AdapterRequest request) {
        AdapterRequest r = this._adapterRequests.get(request.getId());
        if (r == null || r != request) {
            return;
        }
        if (request.retry()) {
            try {
                request.invoke(this._domainId, this._lookups);
                request.scheduleTimer(this._timeout);
                return;
            }
            catch (LocalException localException) {
                // empty catch block
            }
        }
        request.finished(null);
        this._adapterRequests.remove(request.getId());
    }

    synchronized void adapterRequestException(AdapterRequest request, Throwable ex) {
        AdapterRequest r = this._adapterRequests.get(request.getId());
        if (r == null || r != request) {
            return;
        }
        if (request.exception()) {
            if (this._warnOnce) {
                StringBuilder s = new StringBuilder();
                s.append("failed to lookup adapter `");
                s.append((String)request.getId());
                s.append("' with lookup proxy `");
                s.append(this._lookup);
                s.append("':\n");
                s.append(ex.toString());
                this._lookup.ice_getCommunicator().getLogger().warning(s.toString());
                this._warnOnce = false;
            }
            request.cancelTimer();
            this._adapterRequests.remove(request.getId());
        }
    }

    private class ObjectRequest
    extends Request<Identity, ObjectPrx> {
        ObjectRequest(Identity id, int retryCount) {
            super(id, retryCount);
        }

        void response(ObjectPrx proxy) {
            this.finished(proxy);
        }

        @Override
        void finished(ObjectPrx proxy) {
            for (CompletableFuture f : this._futures) {
                f.complete(proxy);
            }
            this._futures.clear();
        }

        @Override
        public void run() {
            LookupI.this.objectRequestTimedOut(this);
        }

        @Override
        protected void invokeWithLookup(String domainId, LookupPrx lookup, LookupReplyPrx lookupReply) {
            lookup.findObjectByIdAsync(domainId, (Identity)this._id, lookupReply).whenComplete((v, ex) -> {
                if (ex != null) {
                    LookupI.this.objectRequestException(this, (Throwable)ex);
                }
            });
        }
    }

    private class AdapterRequest
    extends Request<String, ObjectPrx> {
        private Set<ObjectPrx> _proxies;
        private long _start;
        private long _latency;

        AdapterRequest(String id, int retryCount) {
            super(id, retryCount);
            this._proxies = new HashSet<ObjectPrx>();
            this._start = System.nanoTime();
            this._latency = 0L;
        }

        @Override
        boolean retry() {
            return this._proxies.size() == 0 && --this._retryCount >= 0;
        }

        boolean response(ObjectPrx proxy, boolean isReplicaGroup) {
            if (isReplicaGroup) {
                this._proxies.add(proxy);
                if (this._latency == 0L) {
                    this._latency = (long)((double)((System.nanoTime() - this._start) * (long)LookupI.this._latencyMultiplier) / 100000.0);
                    if (this._latency == 0L) {
                        this._latency = 1L;
                    }
                    this.cancelTimer();
                    this.scheduleTimer(this._latency);
                }
                return false;
            }
            this.finished(proxy);
            return true;
        }

        @Override
        void finished(ObjectPrx proxy) {
            if (proxy != null || this._proxies.isEmpty()) {
                this.sendResponse(proxy);
            } else if (this._proxies.size() == 1) {
                this.sendResponse(this._proxies.toArray(new ObjectPrx[1])[0]);
            } else {
                ArrayList<Endpoint> endpoints = new ArrayList<Endpoint>();
                ObjectPrx result = null;
                for (ObjectPrx prx : this._proxies) {
                    if (result == null) {
                        result = prx;
                    }
                    endpoints.addAll(Arrays.asList(prx.ice_getEndpoints()));
                }
                this.sendResponse(result.ice_endpoints(endpoints.toArray(new Endpoint[endpoints.size()])));
            }
        }

        @Override
        public void run() {
            LookupI.this.adapterRequestTimedOut(this);
        }

        @Override
        protected void invokeWithLookup(String domainId, LookupPrx lookup, LookupReplyPrx lookupReply) {
            lookup.findAdapterByIdAsync(domainId, (String)this._id, lookupReply).whenComplete((v, ex) -> {
                if (ex != null) {
                    LookupI.this.adapterRequestException(this, (Throwable)ex);
                }
            });
        }

        private void sendResponse(ObjectPrx proxy) {
            for (CompletableFuture f : this._futures) {
                f.complete(proxy);
            }
            this._futures.clear();
        }
    }

    private abstract class Request<T, Ret>
    implements Runnable {
        private final String _requestId;
        protected int _retryCount;
        protected int _lookupCount;
        protected int _failureCount;
        protected List<CompletableFuture<Ret>> _futures = new ArrayList<CompletableFuture<Ret>>();
        protected T _id;
        protected Future<?> _future;

        Request(T id, int retryCount) {
            this._id = id;
            this._requestId = UUID.randomUUID().toString();
            this._retryCount = retryCount;
        }

        T getId() {
            return this._id;
        }

        boolean addFuture(CompletableFuture<Ret> f) {
            this._futures.add(f);
            return this._futures.size() == 1;
        }

        boolean retry() {
            return --this._retryCount >= 0;
        }

        void invoke(String domainId, Map<LookupPrx, LookupReplyPrx> lookups) {
            this._lookupCount = lookups.size();
            this._failureCount = 0;
            Identity id = new Identity(this._requestId, "");
            for (Map.Entry<LookupPrx, LookupReplyPrx> entry : lookups.entrySet()) {
                this.invokeWithLookup(domainId, entry.getKey(), LookupReplyPrx.uncheckedCast(entry.getValue().ice_identity(id)));
            }
        }

        boolean exception() {
            if (++this._failureCount == this._lookupCount) {
                this.finished(null);
                return true;
            }
            return false;
        }

        String getRequestId() {
            return this._requestId;
        }

        void scheduleTimer(long timeout) {
            this._future = LookupI.this._timer.schedule(this, timeout, TimeUnit.MILLISECONDS);
        }

        void cancelTimer() {
            assert (this._future != null);
            this._future.cancel(false);
            this._future = null;
        }

        abstract void finished(ObjectPrx var1);

        protected abstract void invokeWithLookup(String var1, LookupPrx var2, LookupReplyPrx var3);
    }
}

