// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * This interface provides access to IceGrid log file contents.
 *
 **/
public interface _FileIteratorOperations
{
    /**
     * Read lines from the log file.
     *
     * @param size Specifies the maximum number of bytes to be
     * received. The server will ensure that the returned message
     * doesn't exceed the given size.
     *
     * @param lines The lines read from the file. If there was nothing to
     * read from the file since the last call to read, an empty
     * sequence is returned. The last line of the sequence is always
     * incomplete (and therefore no '\n' should be added when writing
     * the last line to the to the output device).
     *
     * @param current The Current object for the invocation.
     * @return True if EOF is encountered.
     *
     * @throws FileNotAvailableException Raised if there was a problem
     * to read lines from the file.
     *
     **/
    boolean read(int size, Ice.StringSeqHolder lines, Ice.Current current)
        throws FileNotAvailableException;

    /**
     * Destroy the iterator.
     *
     * @param current The Current object for the invocation.
     **/
    void destroy(Ice.Current current);
}
