// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceGrid;

/**
 * The database observer interface. Observers should implement this
 * interface to receive information about the state of the IceGrid
 * registry database.
 **/
public interface ApplicationObserver extends com.zeroc.Ice.Object
{
    /**
     * <tt>applicationInit</tt> is called after the registration
     * of an observer to indicate the state of the registry.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * @param applications The applications currently registered with
     * the registry.
     * @param current The Current object for the invocation.
     **/
    void applicationInit(int serial, java.util.List<ApplicationInfo> applications, com.zeroc.Ice.Current current);

    /**
     * The <tt>applicationAdded</tt> operation is called to notify an observer
     * that an application was added.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the new application.
     * @param current The Current object for the invocation.
     **/
    void applicationAdded(int serial, ApplicationInfo desc, com.zeroc.Ice.Current current);

    /**
     * The <tt>applicationRemoved</tt> operation is called to notify an observer
     * that an application was removed.
     * @param serial The new serial number of the registry database.
     * @param name The name of the application that was removed.
     * @param current The Current object for the invocation.
     **/
    void applicationRemoved(int serial, String name, com.zeroc.Ice.Current current);

    /**
     * The <tt>applicationUpdated</tt> operation is called to notify an observer
     * that an application was updated.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the update.
     * @param current The Current object for the invocation.
     **/
    void applicationUpdated(int serial, ApplicationUpdateInfo desc, com.zeroc.Ice.Current current);

    static final String[] _iceIds =
    {
        "::Ice::Object",
        "::IceGrid::ApplicationObserver"
    };

    @Override
    default String[] ice_ids(com.zeroc.Ice.Current current)
    {
        return _iceIds;
    }

    @Override
    default String ice_id(com.zeroc.Ice.Current current)
    {
        return ice_staticId();
    }

    static String ice_staticId()
    {
        return "::IceGrid::ApplicationObserver";
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_applicationInit(ApplicationObserver obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        int iceP_serial;
        java.util.List<ApplicationInfo> iceP_applications;
        iceP_serial = istr.readInt();
        iceP_applications = ApplicationInfoSeqHelper.read(istr);
        istr.readPendingValues();
        inS.endReadParams();
        obj.applicationInit(iceP_serial, iceP_applications, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_applicationAdded(ApplicationObserver obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        int iceP_serial;
        ApplicationInfo iceP_desc;
        iceP_serial = istr.readInt();
        iceP_desc = ApplicationInfo.ice_read(istr);
        istr.readPendingValues();
        inS.endReadParams();
        obj.applicationAdded(iceP_serial, iceP_desc, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_applicationRemoved(ApplicationObserver obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        int iceP_serial;
        String iceP_name;
        iceP_serial = istr.readInt();
        iceP_name = istr.readString();
        inS.endReadParams();
        obj.applicationRemoved(iceP_serial, iceP_name, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_applicationUpdated(ApplicationObserver obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(null, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        int iceP_serial;
        ApplicationUpdateInfo iceP_desc;
        iceP_serial = istr.readInt();
        iceP_desc = ApplicationUpdateInfo.ice_read(istr);
        istr.readPendingValues();
        inS.endReadParams();
        obj.applicationUpdated(iceP_serial, iceP_desc, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    final static String[] _iceOps =
    {
        "applicationAdded",
        "applicationInit",
        "applicationRemoved",
        "applicationUpdated",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping"
    };

    @Override
    default java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceDispatch(com.zeroc.IceInternal.Incoming in, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        int pos = java.util.Arrays.binarySearch(_iceOps, current.operation);
        if(pos < 0)
        {
            throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return _iceD_applicationAdded(this, in, current);
            }
            case 1:
            {
                return _iceD_applicationInit(this, in, current);
            }
            case 2:
            {
                return _iceD_applicationRemoved(this, in, current);
            }
            case 3:
            {
                return _iceD_applicationUpdated(this, in, current);
            }
            case 4:
            {
                return com.zeroc.Ice.Object._iceD_ice_id(this, in, current);
            }
            case 5:
            {
                return com.zeroc.Ice.Object._iceD_ice_ids(this, in, current);
            }
            case 6:
            {
                return com.zeroc.Ice.Object._iceD_ice_isA(this, in, current);
            }
            case 7:
            {
                return com.zeroc.Ice.Object._iceD_ice_ping(this, in, current);
            }
        }

        assert(false);
        throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
    }
}
