// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceGrid;

/**
 * The database observer interface. Observers should implement this
 * interface to receive information about the state of the IceGrid
 * registry database.
 **/
public interface ApplicationObserverPrx extends com.zeroc.Ice.ObjectPrx
{
    /**
     * <tt>applicationInit</tt> is called after the registration
     * of an observer to indicate the state of the registry.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * @param applications The applications currently registered with
     * the registry.
     **/
    default void applicationInit(int serial, java.util.List<ApplicationInfo> applications)
    {
        applicationInit(serial, applications, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * <tt>applicationInit</tt> is called after the registration
     * of an observer to indicate the state of the registry.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * @param applications The applications currently registered with
     * the registry.
     * @param context The Context map to send with the invocation.
     **/
    default void applicationInit(int serial, java.util.List<ApplicationInfo> applications, java.util.Map<String, String> context)
    {
        _iceI_applicationInitAsync(serial, applications, context, true).waitForResponse();
    }

    /**
     * <tt>applicationInit</tt> is called after the registration
     * of an observer to indicate the state of the registry.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * @param applications The applications currently registered with
     * the registry.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> applicationInitAsync(int serial, java.util.List<ApplicationInfo> applications)
    {
        return _iceI_applicationInitAsync(serial, applications, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * <tt>applicationInit</tt> is called after the registration
     * of an observer to indicate the state of the registry.
     * @param serial The current serial number of the registry
     * database. This serial number allows observers to make sure that
     * their internal state is synchronized with the registry.
     * @param applications The applications currently registered with
     * the registry.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> applicationInitAsync(int serial, java.util.List<ApplicationInfo> applications, java.util.Map<String, String> context)
    {
        return _iceI_applicationInitAsync(serial, applications, context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_applicationInitAsync(int iceP_serial, java.util.List<ApplicationInfo> iceP_applications, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "applicationInit", null, sync, null);
        f.invoke(false, context, null, ostr -> {
                     ostr.writeInt(iceP_serial);
                     ApplicationInfoSeqHelper.write(ostr, iceP_applications);
                     ostr.writePendingValues();
                 }, null);
        return f;
    }

    /**
     * The <tt>applicationAdded</tt> operation is called to notify an observer
     * that an application was added.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the new application.
     **/
    default void applicationAdded(int serial, ApplicationInfo desc)
    {
        applicationAdded(serial, desc, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * The <tt>applicationAdded</tt> operation is called to notify an observer
     * that an application was added.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the new application.
     * @param context The Context map to send with the invocation.
     **/
    default void applicationAdded(int serial, ApplicationInfo desc, java.util.Map<String, String> context)
    {
        _iceI_applicationAddedAsync(serial, desc, context, true).waitForResponse();
    }

    /**
     * The <tt>applicationAdded</tt> operation is called to notify an observer
     * that an application was added.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the new application.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> applicationAddedAsync(int serial, ApplicationInfo desc)
    {
        return _iceI_applicationAddedAsync(serial, desc, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * The <tt>applicationAdded</tt> operation is called to notify an observer
     * that an application was added.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the new application.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> applicationAddedAsync(int serial, ApplicationInfo desc, java.util.Map<String, String> context)
    {
        return _iceI_applicationAddedAsync(serial, desc, context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_applicationAddedAsync(int iceP_serial, ApplicationInfo iceP_desc, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "applicationAdded", null, sync, null);
        f.invoke(false, context, null, ostr -> {
                     ostr.writeInt(iceP_serial);
                     ApplicationInfo.ice_write(ostr, iceP_desc);
                     ostr.writePendingValues();
                 }, null);
        return f;
    }

    /**
     * The <tt>applicationRemoved</tt> operation is called to notify an observer
     * that an application was removed.
     * @param serial The new serial number of the registry database.
     * @param name The name of the application that was removed.
     **/
    default void applicationRemoved(int serial, String name)
    {
        applicationRemoved(serial, name, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * The <tt>applicationRemoved</tt> operation is called to notify an observer
     * that an application was removed.
     * @param serial The new serial number of the registry database.
     * @param name The name of the application that was removed.
     * @param context The Context map to send with the invocation.
     **/
    default void applicationRemoved(int serial, String name, java.util.Map<String, String> context)
    {
        _iceI_applicationRemovedAsync(serial, name, context, true).waitForResponse();
    }

    /**
     * The <tt>applicationRemoved</tt> operation is called to notify an observer
     * that an application was removed.
     * @param serial The new serial number of the registry database.
     * @param name The name of the application that was removed.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> applicationRemovedAsync(int serial, String name)
    {
        return _iceI_applicationRemovedAsync(serial, name, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * The <tt>applicationRemoved</tt> operation is called to notify an observer
     * that an application was removed.
     * @param serial The new serial number of the registry database.
     * @param name The name of the application that was removed.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> applicationRemovedAsync(int serial, String name, java.util.Map<String, String> context)
    {
        return _iceI_applicationRemovedAsync(serial, name, context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_applicationRemovedAsync(int iceP_serial, String iceP_name, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "applicationRemoved", null, sync, null);
        f.invoke(false, context, null, ostr -> {
                     ostr.writeInt(iceP_serial);
                     ostr.writeString(iceP_name);
                 }, null);
        return f;
    }

    /**
     * The <tt>applicationUpdated</tt> operation is called to notify an observer
     * that an application was updated.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the update.
     **/
    default void applicationUpdated(int serial, ApplicationUpdateInfo desc)
    {
        applicationUpdated(serial, desc, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * The <tt>applicationUpdated</tt> operation is called to notify an observer
     * that an application was updated.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the update.
     * @param context The Context map to send with the invocation.
     **/
    default void applicationUpdated(int serial, ApplicationUpdateInfo desc, java.util.Map<String, String> context)
    {
        _iceI_applicationUpdatedAsync(serial, desc, context, true).waitForResponse();
    }

    /**
     * The <tt>applicationUpdated</tt> operation is called to notify an observer
     * that an application was updated.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the update.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> applicationUpdatedAsync(int serial, ApplicationUpdateInfo desc)
    {
        return _iceI_applicationUpdatedAsync(serial, desc, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * The <tt>applicationUpdated</tt> operation is called to notify an observer
     * that an application was updated.
     * @param serial The new serial number of the registry database.
     * @param desc The descriptor of the update.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> applicationUpdatedAsync(int serial, ApplicationUpdateInfo desc, java.util.Map<String, String> context)
    {
        return _iceI_applicationUpdatedAsync(serial, desc, context, false);
    }

    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_applicationUpdatedAsync(int iceP_serial, ApplicationUpdateInfo iceP_desc, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "applicationUpdated", null, sync, null);
        f.invoke(false, context, null, ostr -> {
                     ostr.writeInt(iceP_serial);
                     ApplicationUpdateInfo.ice_write(ostr, iceP_desc);
                     ostr.writePendingValues();
                 }, null);
        return f;
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static ApplicationObserverPrx checkedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, ice_staticId(), ApplicationObserverPrx.class, _ApplicationObserverPrxI.class);
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static ApplicationObserverPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, context, ice_staticId(), ApplicationObserverPrx.class, _ApplicationObserverPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static ApplicationObserverPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, ice_staticId(), ApplicationObserverPrx.class, _ApplicationObserverPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static ApplicationObserverPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, context, ice_staticId(), ApplicationObserverPrx.class, _ApplicationObserverPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @return A proxy for this type.
     **/
    static ApplicationObserverPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, ApplicationObserverPrx.class, _ApplicationObserverPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type.
     **/
    static ApplicationObserverPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, facet, ApplicationObserverPrx.class, _ApplicationObserverPrxI.class);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the per-proxy context.
     * @param newContext The context for the new proxy.
     * @return A proxy with the specified per-proxy context.
     **/
    @Override
    default ApplicationObserverPrx ice_context(java.util.Map<String, String> newContext)
    {
        return (ApplicationObserverPrx)_ice_context(newContext);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the adapter ID.
     * @param newAdapterId The adapter ID for the new proxy.
     * @return A proxy with the specified adapter ID.
     **/
    @Override
    default ApplicationObserverPrx ice_adapterId(String newAdapterId)
    {
        return (ApplicationObserverPrx)_ice_adapterId(newAdapterId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoints.
     * @param newEndpoints The endpoints for the new proxy.
     * @return A proxy with the specified endpoints.
     **/
    @Override
    default ApplicationObserverPrx ice_endpoints(com.zeroc.Ice.Endpoint[] newEndpoints)
    {
        return (ApplicationObserverPrx)_ice_endpoints(newEndpoints);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator cache timeout.
     * @param newTimeout The new locator cache timeout (in seconds).
     * @return A proxy with the specified locator cache timeout.
     **/
    @Override
    default ApplicationObserverPrx ice_locatorCacheTimeout(int newTimeout)
    {
        return (ApplicationObserverPrx)_ice_locatorCacheTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the invocation timeout.
     * @param newTimeout The new invocation timeout (in seconds).
     * @return A proxy with the specified invocation timeout.
     **/
    @Override
    default ApplicationObserverPrx ice_invocationTimeout(int newTimeout)
    {
        return (ApplicationObserverPrx)_ice_invocationTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for connection caching.
     * @param newCache <code>true</code> if the new proxy should cache connections; <code>false</code> otherwise.
     * @return A proxy with the specified caching policy.
     **/
    @Override
    default ApplicationObserverPrx ice_connectionCached(boolean newCache)
    {
        return (ApplicationObserverPrx)_ice_connectionCached(newCache);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoint selection policy.
     * @param newType The new endpoint selection policy.
     * @return A proxy with the specified endpoint selection policy.
     **/
    @Override
    default ApplicationObserverPrx ice_endpointSelection(com.zeroc.Ice.EndpointSelectionType newType)
    {
        return (ApplicationObserverPrx)_ice_endpointSelection(newType);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for how it selects endpoints.
     * @param b If <code>b</code> is <code>true</code>, only endpoints that use a secure transport are
     * used by the new proxy. If <code>b</code> is false, the returned proxy uses both secure and
     * insecure endpoints.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default ApplicationObserverPrx ice_secure(boolean b)
    {
        return (ApplicationObserverPrx)_ice_secure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the encoding used to marshal parameters.
     * @param e The encoding version to use to marshal request parameters.
     * @return A proxy with the specified encoding version.
     **/
    @Override
    default ApplicationObserverPrx ice_encodingVersion(com.zeroc.Ice.EncodingVersion e)
    {
        return (ApplicationObserverPrx)_ice_encodingVersion(e);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its endpoint selection policy.
     * @param b If <code>b</code> is <code>true</code>, the new proxy will use secure endpoints for invocations
     * and only use insecure endpoints if an invocation cannot be made via secure endpoints. If <code>b</code> is
     * <code>false</code>, the proxy prefers insecure endpoints to secure ones.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default ApplicationObserverPrx ice_preferSecure(boolean b)
    {
        return (ApplicationObserverPrx)_ice_preferSecure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the router.
     * @param router The router for the new proxy.
     * @return A proxy with the specified router.
     **/
    @Override
    default ApplicationObserverPrx ice_router(com.zeroc.Ice.RouterPrx router)
    {
        return (ApplicationObserverPrx)_ice_router(router);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator.
     * @param locator The locator for the new proxy.
     * @return A proxy with the specified locator.
     **/
    @Override
    default ApplicationObserverPrx ice_locator(com.zeroc.Ice.LocatorPrx locator)
    {
        return (ApplicationObserverPrx)_ice_locator(locator);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for collocation optimization.
     * @param b <code>true</code> if the new proxy enables collocation optimization; <code>false</code> otherwise.
     * @return A proxy with the specified collocation optimization.
     **/
    @Override
    default ApplicationObserverPrx ice_collocationOptimized(boolean b)
    {
        return (ApplicationObserverPrx)_ice_collocationOptimized(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses twoway invocations.
     * @return A proxy that uses twoway invocations.
     **/
    @Override
    default ApplicationObserverPrx ice_twoway()
    {
        return (ApplicationObserverPrx)_ice_twoway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses oneway invocations.
     * @return A proxy that uses oneway invocations.
     **/
    @Override
    default ApplicationObserverPrx ice_oneway()
    {
        return (ApplicationObserverPrx)_ice_oneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch oneway invocations.
     * @return A proxy that uses batch oneway invocations.
     **/
    @Override
    default ApplicationObserverPrx ice_batchOneway()
    {
        return (ApplicationObserverPrx)_ice_batchOneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses datagram invocations.
     * @return A proxy that uses datagram invocations.
     **/
    @Override
    default ApplicationObserverPrx ice_datagram()
    {
        return (ApplicationObserverPrx)_ice_datagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch datagram invocations.
     * @return A proxy that uses batch datagram invocations.
     **/
    @Override
    default ApplicationObserverPrx ice_batchDatagram()
    {
        return (ApplicationObserverPrx)_ice_batchDatagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, except for compression.
     * @param co <code>true</code> enables compression for the new proxy; <code>false</code> disables compression.
     * @return A proxy with the specified compression setting.
     **/
    @Override
    default ApplicationObserverPrx ice_compress(boolean co)
    {
        return (ApplicationObserverPrx)_ice_compress(co);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection timeout setting.
     * @param t The connection timeout for the proxy in milliseconds.
     * @return A proxy with the specified timeout.
     **/
    @Override
    default ApplicationObserverPrx ice_timeout(int t)
    {
        return (ApplicationObserverPrx)_ice_timeout(t);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection ID.
     * @param connectionId The connection ID for the new proxy. An empty string removes the connection ID.
     * @return A proxy with the specified connection ID.
     **/
    @Override
    default ApplicationObserverPrx ice_connectionId(String connectionId)
    {
        return (ApplicationObserverPrx)_ice_connectionId(connectionId);
    }

    static String ice_staticId()
    {
        return "::IceGrid::ApplicationObserver";
    }
}
