// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `PermissionsVerifier.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package Glacier2;

/**
 * The SSL Glacier2 permissions verifier. This is called through the
 * process of establishing a session.
 *
 * @see Router
 *
 **/
public interface SSLPermissionsVerifierPrx extends Ice.ObjectPrx
{
    /**
     * Check whether a user has permission to access the router.
     *
     * @param info The SSL information.
     *
     * @param reason The reason why access was denied.
     *
     * @return True if access is granted, or false otherwise.
     *
     * @throws PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     *
     * @see SSLInfo
     *
     **/
    public boolean authorize(SSLInfo info, Ice.StringHolder reason)
        throws PermissionDeniedException;

    /**
     * Check whether a user has permission to access the router.
     *
     * @param info The SSL information.
     *
     * @param reason The reason why access was denied.
     *
     * @param context The Context map to send with the invocation.
     * @return True if access is granted, or false otherwise.
     *
     * @throws PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     *
     * @see SSLInfo
     *
     **/
    public boolean authorize(SSLInfo info, Ice.StringHolder reason, java.util.Map<String, String> context)
        throws PermissionDeniedException;

    /**
     * Check whether a user has permission to access the router.
     *
     * @param info The SSL information.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info);

    /**
     * Check whether a user has permission to access the router.
     *
     * @param info The SSL information.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, java.util.Map<String, String> context);

    /**
     * Check whether a user has permission to access the router.
     *
     * @param info The SSL information.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, Ice.Callback cb);

    /**
     * Check whether a user has permission to access the router.
     *
     * @param info The SSL information.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Check whether a user has permission to access the router.
     *
     * @param info The SSL information.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, Callback_SSLPermissionsVerifier_authorize cb);

    /**
     * Check whether a user has permission to access the router.
     *
     * @param info The SSL information.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info, java.util.Map<String, String> context, Callback_SSLPermissionsVerifier_authorize cb);

    public interface FunctionalCallback_SSLPermissionsVerifier_authorize_Response
    {
        void apply(boolean ret, String reason);
    }

    /**
     * Check whether a user has permission to access the router.
     *
     * @param info The SSL information.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info,
                                           FunctionalCallback_SSLPermissionsVerifier_authorize_Response responseCb,
                                           IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                           IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Check whether a user has permission to access the router.
     *
     * @param info The SSL information.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info,
                                           FunctionalCallback_SSLPermissionsVerifier_authorize_Response responseCb,
                                           IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                           IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                           IceInternal.Functional_BoolCallback sentCb);

    /**
     * Check whether a user has permission to access the router.
     *
     * @param info The SSL information.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info,
                                           java.util.Map<String, String> context,
                                           FunctionalCallback_SSLPermissionsVerifier_authorize_Response responseCb,
                                           IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                           IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Check whether a user has permission to access the router.
     *
     * @param info The SSL information.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_authorize(SSLInfo info,
                                           java.util.Map<String, String> context,
                                           FunctionalCallback_SSLPermissionsVerifier_authorize_Response responseCb,
                                           IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                           IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                           IceInternal.Functional_BoolCallback sentCb);

    /**
     * Check whether a user has permission to access the router.
     *
     * @param reason The reason why access was denied.
     *
     * @param result The asynchronous result object.
     * @return True if access is granted, or false otherwise.
     *
     * @throws PermissionDeniedException Raised if the user access is
     * denied. This can be raised in place of returning false with a
     * reason set in the reason out parameter.
     *
     * @see SSLInfo
     *
     **/
    public boolean end_authorize(Ice.StringHolder reason, Ice.AsyncResult result)
        throws PermissionDeniedException;
}
