/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.cmm.lcms;

import java.util.Arrays;
import java.util.HashMap;
import sun.java2d.cmm.Profile;
import sun.java2d.cmm.lcms.LCMS;

final class LCMSProfile
extends Profile {
    private final TagCache tagCache;
    private final Object disposerReferent;

    LCMSProfile(long ptr, Object ref) {
        super(ptr);
        this.disposerReferent = ref;
        this.tagCache = new TagCache(this);
    }

    final long getLcmsPtr() {
        return this.getNativePtr();
    }

    TagData getTag(int sig) {
        return this.tagCache.getTag(sig);
    }

    void clearTagCache() {
        this.tagCache.clear();
    }

    static class TagData {
        private int signature;
        private byte[] data;

        TagData(int sig, byte[] data) {
            this.signature = sig;
            this.data = data;
        }

        int getSize() {
            return this.data.length;
        }

        byte[] getData() {
            return Arrays.copyOf(this.data, this.data.length);
        }

        void copyDataTo(byte[] dst) {
            System.arraycopy(this.data, 0, dst, 0, this.data.length);
        }

        int getSignature() {
            return this.signature;
        }
    }

    static class TagCache {
        final LCMSProfile profile;
        private HashMap<Integer, TagData> tags;

        TagCache(LCMSProfile p) {
            this.profile = p;
            this.tags = new HashMap();
        }

        TagData getTag(int sig) {
            byte[] tagData;
            TagData t = this.tags.get(sig);
            if (t == null && (tagData = LCMS.getTagNative(this.profile.getNativePtr(), sig)) != null) {
                t = new TagData(sig, tagData);
                this.tags.put(sig, t);
            }
            return t;
        }

        void clear() {
            this.tags.clear();
        }
    }
}

