/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.backend;

import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.ha.backend.CollectedInfo;
import org.apache.catalina.ha.backend.MultiCastSender;
import org.apache.catalina.ha.backend.Sender;
import org.apache.catalina.ha.backend.TcpSender;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class HeartbeatListener
implements LifecycleListener,
ContainerListener {
    private static final Log log = LogFactory.getLog(HeartbeatListener.class);
    int port = 0;
    String host = null;
    String ip = "224.0.1.105";
    int multiport = 23364;
    int ttl = 16;
    protected String proxyList = null;
    protected String proxyURL = "/HeartbeatListener";
    private CollectedInfo coll = null;
    private Sender sender = null;

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setGroup(String ip) {
        this.ip = ip;
    }

    public String getGroup() {
        return this.ip;
    }

    public void setMultiport(int multiport) {
        this.multiport = multiport;
    }

    public int getMultiport() {
        return this.multiport;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public int getTtl() {
        return this.ttl;
    }

    public String getProxyList() {
        return this.proxyList;
    }

    public void setProxyList(String proxyList) {
        this.proxyList = proxyList;
    }

    public String getProxyURL() {
        return this.proxyURL;
    }

    public void setProxyURL(String proxyURL) {
        this.proxyURL = proxyURL;
    }

    public void containerEvent(ContainerEvent event) {
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if ("periodic".equals(event.getType())) {
            if (this.sender == null) {
                this.sender = this.proxyList == null ? new MultiCastSender() : new TcpSender();
            }
            if (this.coll == null) {
                try {
                    this.coll = new CollectedInfo(this.host, this.port);
                    this.port = this.coll.port;
                    this.host = this.coll.host;
                }
                catch (Exception ex) {
                    log.error((Object)("Unable to initialize info collection: " + ex));
                    this.coll = null;
                    return;
                }
            }
            try {
                this.sender.init(this);
            }
            catch (Exception ex) {
                log.error((Object)("Unable to initialize Sender: " + ex));
                this.sender = null;
                return;
            }
            try {
                this.coll.refresh();
            }
            catch (Exception ex) {
                log.error((Object)("Unable to collect load information: " + ex));
                this.coll = null;
                return;
            }
            String output = "v=1&ready=" + this.coll.ready + "&busy=" + this.coll.busy + "&port=" + this.port;
            try {
                this.sender.send(output);
            }
            catch (Exception ex) {
                log.error((Object)("Unable to send collected load information: " + ex));
            }
        }
    }
}

