/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public class MultipleWhitespaceRule
extends Rule {
    public MultipleWhitespaceRule(ResourceBundle messages, Language language) {
        super(messages);
        super.setCategory(Categories.TYPOGRAPHY.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Whitespace);
    }

    @Override
    public String getId() {
        return "WHITESPACE_RULE";
    }

    @Override
    public String getDescription() {
        return this.messages.getString("desc_whitespacerepetition");
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokens();
        boolean prevWhite = false;
        boolean isLineBreakContinuation = false;
        int prevLen = 0;
        int prevPos = 0;
        int i = 1;
        while (i < tokens.length) {
            boolean tokenIsTab = tokens[i].getToken().equals("\t");
            boolean prevTokenIsLinebreak = tokens[i - 1].isLinebreak();
            boolean bl = isLineBreakContinuation = (prevTokenIsLinebreak || isLineBreakContinuation) && tokens[i].isWhitespace() && !tokenIsTab;
            if ((tokens[i].isWhitespace() || StringTools.isNonBreakingWhitespace(tokens[i].getToken())) && prevWhite && !tokenIsTab && !prevTokenIsLinebreak && !isLineBreakContinuation) {
                int pos = tokens[i - 1].getStartPos();
                while (i < tokens.length && (tokens[i].isWhitespace() || StringTools.isNonBreakingWhitespace(tokens[i].getToken()))) {
                    prevLen += tokens[i].getToken().length();
                    ++i;
                }
                String message = this.messages.getString("whitespace_repetition");
                if (prevLen > 0) {
                    RuleMatch ruleMatch = new RuleMatch(this, prevPos, pos + prevLen, message);
                    ruleMatch.setSuggestedReplacement(" ");
                    ruleMatches.add(ruleMatch);
                }
            }
            if (i >= tokens.length) continue;
            prevWhite = tokens[i].isWhitespace() || StringTools.isNonBreakingWhitespace(tokens[i].getToken());
            prevLen = tokens[i].getToken().length();
            prevPos = tokens[i].getStartPos();
            ++i;
        }
        return this.toRuleMatchArray(ruleMatches);
    }
}

