/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_da extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arabisk";
        final String metaValue_bn = "bengali";
        final String metaValue_bo = "tibetansk";
        final String metaValue_el = "gr\u00e6sk";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "hebraisk";
        final String metaValue_hy = "armensk";
        final String metaValue_ja = "japansk";
        final String metaValue_jv = "javanesisk";
        final String metaValue_ka = "georgisk";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "koreansk";
        final String metaValue_lo = "lao";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongolsk";
        final String metaValue_my = "burmesisk";
        final String metaValue_or = "oriya";
        final String metaValue_si = "singalesisk";
        final String metaValue_su = "sundanesisk";
        final String metaValue_ta = "tamilsk";
        final String metaValue_te = "telugu";
        final String metaValue_tl = "tagalog";
        final String metaValue_ban = "balinesisk";
        final String metaValue_bug = "buginesisk";
        final String metaValue_chr = "cherokee";
        final String metaValue_cop = "koptisk";
        final String metaValue_got = "gotisk";
        final String metaValue_kpe = "kpelle";
        final String metaValue_men = "mende";
        final String metaValue_pal = "pahlavi";
        final String metaValue_peo = "oldpersisk";
        final String metaValue_phn = "f\u00f8nikisk";
        final String metaValue_sam = "samaritansk";
        final String metaValue_ssy = "saho";
        final String metaValue_syr = "syrisk";
        final String metaValue_vai = "vai";
        final String metaValue_zbl = "blissymboler";
        final Object[][] data = new Object[][] {
            { "ksh", "k\u00f6lsch" },
            { "Ogam", "ogham" },
            { "mwl", "mirandesisk" },
            { "Zsym", "zsym" },
            { "cch", "atsam" },
            { "mwr", "marwari" },
            { "Tagb", "tagbanwa" },
            { "%%NJIVA", "Gniva-/Nijva-dialekt" },
            { "egy", "oldegyptisk" },
            { "raj", "rajasthani" },
            { "Phag", "phags-pa" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "ter", "tereno" },
            { "AC", "Ascension\u00f8en" },
            { "rar", "rarotongan" },
            { "tet", "tetum" },
            { "AD", "Andorra" },
            { "AE", "De Forenede Arabiske Emirater" },
            { "nl_BE", "flamsk" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua og Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albanien" },
            { "AM", "Armenien" },
            { "Teng", "tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentina" },
            { "Prti", "prti" },
            { "AS", "Amerikansk Samoa" },
            { "AT", "\u00d8strig" },
            { "AU", "Australien" },
            { "AW", "Aruba" },
            { "en_US", "amerikansk engelsk" },
            { "AX", "\u00c5land" },
            { "mye", "myene" },
            { "AZ", "Aserbajdsjan" },
            { "%%AREVELA", "\u00f8starmensk" },
            { "BA", "Bosnien-Hercegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuano" },
            { "BD", "Bangladesh" },
            { "kum", "kymyk" },
            { "BE", "Belgien" },
            { "gmh", "middelh\u00f8jtysk" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarien" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "kut", "kutenaj" },
            { "myv", "erzya" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "De Nederlandske Antiller" },
            { "BR", "Brasilien" },
            { "BS", "Bahamas" },
            { "xog", "soga" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet\u00f8en" },
            { "BW", "Botswana" },
            { "BY", "Hviderusland" },
            { "BZ", "Belize" },
            { "Visp", "synlig tale" },
            { "CA", "Canada" },
            { "CC", "Cocos\u00f8erne" },
            { "mzn", "mazenisk" },
            { "CD", "Congo-Kinshasa" },
            { "CF", "Den Centralafrikanske Republik" },
            { "CG", "Congo-Brazzaville" },
            { "CH", "Schweiz" },
            { "CI", "Elfenbenskysten" },
            { "CK", "Cook\u00f8erne" },
            { "CL", "Chile" },
            { "Kthi", "kthi" },
            { "CM", "Cameroun" },
            { "CN", "Kina" },
            { "CO", "Colombia" },
            { "CP", "Clipperton\u00f8en" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Kap Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Jule\u00f8en" },
            { "CY", "Cypern" },
            { "CZ", "Tjekkiet" },
            { "eka", "ekajuk" },
            { "%%RIGIK", "klassisk volap\u00fck" },
            { "DE", "Tyskland" },
            { "goh", "oldh\u00f8jtysk" },
            { "ace", "achinesisk" },
            { "cgg", "chiga" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Danmark" },
            { "ach", "acoli" },
            { "gon", "gondi" },
            { "Brai", "brailleskrift" },
            { "Brah", "bramisk" },
            { "DM", "Dominica" },
            { "DO", "Den Dominikanske Republik" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "Mtei", "meitei-mayek" },
            { "zun", "zuni" },
            { "tig", "tigre" },
            { "Takr", "takri" },
            { "DZ", "Algeriet" },
            { "pag", "pangasinan" },
            { "pal", metaValue_pal },
            { "EA", "Ceuta og Melilla" },
            { "chb", "chibcha" },
            { "pam", "pampanga" },
            { "EC", "Ecuador" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "Estland" },
            { "tiv", "tivi" },
            { "EG", "Egypten" },
            { "EH", "Vestsahara" },
            { "chg", "chagatai" },
            { "pau", "palauansk" },
            { "chk", "chuukese" },
            { "chn", "chinook" },
            { "chm", "mari" },
            { "chp", "chipewyan" },
            { "cho", "choctaw" },
            { "chr", metaValue_chr },
            { "ER", "Eritrea" },
            { "ES", "Spanien" },
            { "ET", "Etiopien" },
            { "EU", "Den Europ\u00e6iske Union" },
            { "elx", "elamitisk" },
            { "chy", "cheyenne" },
            { "Inds", "indus" },
            { "ady", "adyghe" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falklands\u00f8erne" },
            { "FM", "Mikronesiens Forenede Stater" },
            { "FO", "F\u00e6r\u00f8erne" },
            { "Taml", metaValue_ta },
            { "FR", "Frankrig" },
            { "Kpel", metaValue_kpe },
            { "tkl", "tokelau" },
            { "grb", "grebo" },
            { "root", "rot" },
            { "%%DAJNKO", "Dajnko-alfabet" },
            { "grc", "oldgr\u00e6sk" },
            { "GA", "Gabon" },
            { "vot", "votisk" },
            { "GB", "Storbritannien" },
            { "GD", "Grenada" },
            { "GE", "Georgien" },
            { "GF", "Fransk Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "tai le" },
            { "GI", "Gibraltar" },
            { "afh", "afrihili" },
            { "GL", "Gr\u00f8nland" },
            { "enm", "middelengelsk" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "\u00c6kvatorialguinea" },
            { "GR", "Gr\u00e6kenland" },
            { "GS", "South Georgia og South Sandwich Islands" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "tli", "tlingit" },
            { "tlh", "klingon" },
            { "Talu", "tai lue" },
            { "GY", "Guyana" },
            { "ckb", "sorani" },
            { "zxx", "intet sprogligt indhold" },
            { "Jurc", "jurchen" },
            { "de_AT", "\u00f8strigsk tysk" },
            { "Vaii", metaValue_vai },
            { "HK", "Hongkong SAR" },
            { "HM", "Heard Island og McDonald Islands" },
            { "HN", "Honduras" },
            { "HR", "Kroatien" },
            { "agq", "aghem" },
            { "gsw", "schweizertysk" },
            { "HT", "Haiti" },
            { "HU", "Ungarn" },
            { "tmh", "tamashek" },
            { "IC", "Kanariske \u00f8er" },
            { "peo", metaValue_peo },
            { "ID", "Indonesien" },
            { "IE", "Irland" },
            { "nap", "neapolitansk" },
            { "%%NDYUKA", "Ndyuka-dialekt" },
            { "naq", "nama" },
            { "zza", "zaza" },
            { "Tang", "tangut" },
            { "IL", "Israel" },
            { "Nbat", "nabateisk" },
            { "IM", "Isle of Man" },
            { "IN", "Indien" },
            { "IO", "Det britiske territorium i Det Indiske Ocean" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italien" },
            { "Zmth", "zmth" },
            { "%%POSIX", "computer" },
            { "JE", "Jersey" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaica" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "%%1606NICT", "sen middelfransk frem til 1606" },
            { "ain", "ainu" },
            { "Mend", metaValue_men },
            { "guz", "gusii" },
            { "tog", "nyasa tongansk" },
            { "Kali", "kaya li" },
            { "de_CH", "schweizerh\u00f8jtysk" },
            { "KE", "Kenya" },
            { "419", "Latinamerika" },
            { "KG", "Kirgisistan" },
            { "KH", "Cambodja" },
            { "KI", "Kiribati" },
            { "KM", "Comorerne" },
            { "Knda", metaValue_kn },
            { "KN", "Saint Kitts og Nevis" },
            { "Zinh", "arvet" },
            { "fr_CA", "canadisk fransk" },
            { "KP", "Nordkorea" },
            { "KR", "Sydkorea" },
            { "Plrd", "pollardtegn" },
            { "fr_CH", "schweizisk fransk" },
            { "KW", "Kuwait" },
            { "tpi", "tok pisin" },
            { "KY", "Cayman\u00f8erne" },
            { "KZ", "Kasakhstan" },
            { "Cyrl", "kyrillisk" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "phn", metaValue_phn },
            { "LC", "Saint Lucia" },
            { "Cyrs", "kyrillisk - oldkirkeslavisk variant" },
            { "gwi", "gwichin" },
            { "nds", "nedertysk" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "akkadisk" },
            { "cop", metaValue_cop },
            { "LR", "Liberia" },
            { "Phlv", metaValue_pal },
            { "LS", "Lesotho" },
            { "LT", "Litauen" },
            { "LU", "Luxembourg" },
            { "LV", "Letland" },
            { "Kana", "katakana" },
            { "Sora", "sora" },
            { "LY", "Libyen" },
            { "lad", "ladino" },
            { "vun", "vunjo" },
            { "%%LAUKIKA", "laukika" },
            { "lah", "lahnda" },
            { "lag", "langi" },
            { "Thaa", "thaana" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "Nshu", "n\u00fcshu" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "lam", "lamba" },
            { "MG", "Madagaskar" },
            { "MH", "Marshall\u00f8erne" },
            { "ale", "aleutisk" },
            { "Thai", "thailandsk" },
            { "MK", "Makedonien" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongoliet" },
            { "new", "newari" },
            { "MO", "Macao SAR" },
            { "MP", "Nordmarianerne" },
            { "MQ", "Martinique" },
            { "MR", "Mauretanien" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "alt", "sydaltaisk" },
            { "MV", "Maldiverne" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambique" },
            { "Phli", "phli" },
            { "NA", "Namibia" },
            { "NC", "Ny Kaledonien" },
            { "%%WADEGILE", "Wade-Giles" },
            { "%%UCRCOR", "forenet revideret ortografi" },
            { "NE", "Niger" },
            { "NF", "Norfolk Island" },
            { "NG", "Nigeria" },
            { "trv", "taroko" },
            { "Phlp", "phlp" },
            { "NI", "Nicaragua" },
            { "Hmng", "pahawh hmong" },
            { "NL", "Holland" },
            { "NO", "Norge" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "Phnx", metaValue_phn },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "tsi", "tsimshisk" },
            { "NZ", "New Zealand" },
            { "Merc", "metroitisk sammenh\u00e6ngende" },
            { "rom", "romani" },
            { "Mero", "meroitisk" },
            { "crh", "krim tyrkisk" },
            { "ang", "oldengelsk" },
            { "OM", "Oman" },
            { "anp", "angika" },
            { "Xpeo", metaValue_peo },
            { "PA", "Panama" },
            { "csb", "kasjubisk" },
            { "en_GB", "britisk engelsk" },
            { "PE", "Peru" },
            { "PF", "Fransk Polynesien" },
            { "PG", "Papua Ny Guinea" },
            { "PH", "Filippinerne" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "ewo", "ewondo" },
            { "PM", "Saint Pierre og Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "De pal\u00e6stinensiske omr\u00e5der" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "PY", "Paraguay" },
            { "tum", "tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "skotsk standardengelsk" },
            { "niu", "niuean" },
            { "QO", "Ydre Oceanien" },
            { "lez", "lezghian" },
            { "%%FONUPA", "det uraliske fonetiske alfabet" },
            { "tvl", "tuvalu" },
            { "Tavt", "tavt" },
            { "001", "Verden" },
            { "002", "Afrika" },
            { "003", "Nordamerika" },
            { "RE", "R\u00e9union" },
            { "005", "Sydamerika" },
            { "jbo", "lojban" },
            { "Rjng", "rejang" },
            { "009", "Oceanien" },
            { "%%SURSILV", "sursilv" },
            { "RO", "Rum\u00e6nien" },
            { "RS", "Serbien" },
            { "Mroo", "mroo" },
            { "RU", "Rusland" },
            { "RW", "Rwanda" },
            { "%%METELKO", "Metelko-alfabet" },
            { "Mani", "manik\u00e6isk" },
            { "Ugar", "ugaritisk" },
            { "Khar", "kharoshti" },
            { "SA", "Saudi-Arabien" },
            { "pon", "ponape" },
            { "Mand", "mandaisk" },
            { "SB", "Salomon\u00f8erne" },
            { "twq", "tasawaq" },
            { "011", "Vestafrika" },
            { "SC", "Seychellerne" },
            { "SD", "Sudan" },
            { "013", "Mellemamerika" },
            { "SE", "Sverige" },
            { "014", "\u00d8stafrika" },
            { "arc", "aram\u00e6isk" },
            { "Loma", "loma" },
            { "015", "Nordafrika" },
            { "SG", "Singapore" },
            { "SH", "St. Helena" },
            { "017", "Centralafrika" },
            { "SI", "Slovenien" },
            { "018", "Det sydlige Afrika" },
            { "SJ", "Svalbard og Jan Mayen" },
            { "019", "Amerika" },
            { "SK", "Slovakiet" },
            { "Bamu", "bamum" },
            { "Wole", "woleai" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "mapuche" },
            { "arp", "arapaho" },
            { "SR", "Surinam" },
            { "SS", "Sydsudan" },
            { "ST", "S\u00e3o Tom\u00e9 og Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syrien" },
            { "yao", "yao" },
            { "SZ", "Swaziland" },
            { "arw", "arawak" },
            { "yap", "yapese" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "021", "Det nordlige Amerika" },
            { "TC", "Turks- og Caicos\u00f8erne" },
            { "yav", "yangben" },
            { "TD", "Tchad" },
            { "TF", "De franske besiddelser i Det Sydlige Indiske Ocean" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadsjikistan" },
            { "029", "Caribien" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "ybb", "yemba" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "boontling" },
            { "TN", "Tunesien" },
            { "TO", "Tonga" },
            { "%%NULIK", "moderne volap\u00fck" },
            { "TR", "Tyrkiet" },
            { "TT", "Trinidad og Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "asturisk" },
            { "Orkh", "orkhon" },
            { "TZ", "Tanzania" },
            { "nmg", "kwasio" },
            { "Zzzz", "ukendt skriftsprog" },
            { "Sind", "khudawadi" },
            { "UA", "Ukraine" },
            { "rup", "arum\u00e6nsk" },
            { "030", "\u00d8stasien" },
            { "tyv", "tuvinian" },
            { "sw_CD", "congolesisk swahili" },
            { "034", "Sydasien" },
            { "hai", "haida" },
            { "035", "Syd\u00f8stasien" },
            { "UG", "Uganda" },
            { "039", "Sydeuropa" },
            { "Sinh", metaValue_si },
            { "UM", "Amerikanske overs\u00f8iske \u00f8er" },
            { "US", "USA" },
            { "haw", "hawaiiansk" },
            { "%%1959ACAD", "akademisk" },
            { "UY", "Uruguay" },
            { "UZ", "Usbekistan" },
            { "tzm", "centralmarokkansk tamazight" },
            { "nnh", "ngiemboon" },
            { "VA", "Vatikanstaten" },
            { "pro", "oldprovencalsk" },
            { "VC", "Saint Vincent og Grenadinerne" },
            { "VE", "Venezuela" },
            { "VG", "De Britiske Jomfru\u00f8er" },
            { "VI", "De Amerikanske Jomfru\u00f8er" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "nogai" },
            { "rwk", "rwa" },
            { "non", "oldislandsk" },
            { "053", "Australasien" },
            { "%%AREVMDA", "vestarmensk" },
            { "054", "Melanesien" },
            { "WF", "Wallis og Futuna" },
            { "057", "Mikronesien" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "%%HEPBURN", "Hepburn-romanisering" },
            { "wae", "walsertysk" },
            { "WS", "Samoa" },
            { "Bass", "bassa" },
            { "wal", "walamo" },
            { "was", "washo" },
            { "war", "waray" },
            { "awa", "awadhi" },
            { "061", "Polynesien" },
            { "%%KSCOR", "standardortografi" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "uden skriftsprog" },
            { "Olck", "ol-chiki" },
            { "wbp", "walbiri" },
            { "Batk", "batak" },
            { "Blis", metaValue_zbl },
            { "YE", "Yemen" },
            { "nqo", "n-ko" },
            { "fan", "fang" },
            { "%%ROZAJ", "Resi" },
            { "%%SUTSILV", "sutsilv" },
            { "fat", "fanti" },
            { "Sgnw", "tegnskrift" },
            { "YT", "Mayotte" },
            { "ZA", "Sydafrika" },
            { "Deva", "devanagari" },
            { "Hira", "hiragana" },
            { "ZM", "Zambia" },
            { "%%PINYIN", "pinyin" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Ukendt omr\u00e5de" },
            { "Runr", "runer" },
            { "lol", "mongo" },
            { "nso", "nordsotho" },
            { "loz", "lozi" },
            { "Nkgb", "nakhi geba" },
            { "jmc", "machame" },
            { "hil", "hiligaynon" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "hit", "hittitisk" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "Maya", "mayahieroglyffer" },
            { "lrc", "nordluri" },
            { "Copt", metaValue_cop },
            { "nwc", "klassisk newarisk" },
            { "udm", "udmurt" },
            { "Khmr", metaValue_km },
            { "Limb", "limbu" },
            { "sad", "sandawe" },
            { "sah", "yakut" },
            { "sam", metaValue_sam },
            { "%%SCOUSE", "scouse" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "Tfng", "tifinagh" },
            { "jpr", "j\u00f8disk-persisk" },
            { "sba", "ngambay" },
            { "Guru", "gurmukhi" },
            { "%%ALUKU", "aluku-dialekt" },
            { "lua", "luba-Lulua" },
            { "%%BISCAYAN", "biscayisk" },
            { "sbp", "sangu" },
            { "lui", "luiseno" },
            { "nyn", "nyankole" },
            { "nym", "nyamwezi" },
            { "lun", "lunda" },
            { "nyo", "nyoro sprog" },
            { "luo", "luo" },
            { "fil", "filippinsk" },
            { "hmn", "hmong" },
            { "del", "delaware" },
            { "lus", "lushai" },
            { "bal", "baluchi" },
            { "den", "athapaskisk" },
            { "ban", metaValue_ban },
            { "uga", "ugaristisk" },
            { "luy", "luyana" },
            { "bas", "basa" },
            { "bax", "bamun" },
            { "jrb", "j\u00f8disk-arabisk" },
            { "es_ES", "europ\u00e6isk spansk" },
            { "nzi", "nzima" },
            { "sco", "skotsk" },
            { "scn", "siciliansk" },
            { "aa", "afar" },
            { "ab", "abkhasisk" },
            { "ae", "avestan" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "bbj", "ghomala" },
            { "am", "amharisk" },
            { "Arab", metaValue_ar },
            { "an", "aragonesisk" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "katakana eller hiragana" },
            { "as", "assamesisk" },
            { "Lina", "line\u00e6r A" },
            { "av", "avarisk" },
            { "Linb", "line\u00e6r B" },
            { "sdh", "sydkurdisk" },
            { "ay", "aymara" },
            { "az", "aserbajdsjansk" },
            { "Khoj", "khojki" },
            { "%%OSOJS", "Oseacco-/Osojane-dialekt" },
            { "ba", "bashkir" },
            { "be", "hviderussisk" },
            { "bg", "bulgarsk" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "dogrib" },
            { "br", "bretonsk" },
            { "bs", "bosnisk" },
            { "see", "seneca" },
            { "Mymr", metaValue_my },
            { "seh", "sena" },
            { "Nkoo", "n\u2019ko" },
            { "sel", "selkupisk" },
            { "ca", "catalansk" },
            { "ses", "koyraboro senni" },
            { "ce", "tjetjensk" },
            { "ch", "chamorro" },
            { "%%REVISED", "revideret retskrivning" },
            { "co", "korsikansk" },
            { "Orya", metaValue_or },
            { "cr", "cree" },
            { "cs", "tjekkisk" },
            { "cu", "kirkeslavisk" },
            { "cv", "chuvash" },
            { "cy", "walisisk" },
            { "Yiii", "yi" },
            { "da", "dansk" },
            { "pt_PT", "europ\u00e6isk portugisisk" },
            { "de", "tysk" },
            { "bej", "beja" },
            { "din", "dinka" },
            { "Bugi", metaValue_bug },
            { "bem", "bemba" },
            { "sga", "oldirsk" },
            { "dv", "divehi" },
            { "es_419", "latinamerikansk spansk" },
            { "dz", "dzongkha" },
            { "bez", "bena" },
            { "Lisu", "lisu" },
            { "dje", "zarma" },
            { "ee", "ewe" },
            { "bfd", "bafut" },
            { "ro_MD", "moldovisk" },
            { "el", metaValue_el },
            { "en", "engelsk" },
            { "eo", "esperanto" },
            { "es", "spansk" },
            { "et", "estisk" },
            { "eu", "baskisk" },
            { "Buhd", "buhid" },
            { "Hang", "hangul" },
            { "Samr", metaValue_sam },
            { "shi", "tachelhit" },
            { "hsb", "\u00f8vresorbisk" },
            { "Hani", "han" },
            { "%%ULSTER", "ulster" },
            { "shn", "shan" },
            { "Hano", "hanunoo" },
            { "fa", "persisk" },
            { "Hans", "forenklet" },
            { "Hant", "traditionelt" },
            { "az_Arab", "sydaserbajdsjansk" },
            { "ff", "fulah" },
            { "shu", "tchadisk-arabisk" },
            { "fi", "finsk" },
            { "fj", "fijiansk" },
            { "fon", "fon" },
            { "bgn", "vestbaluchi" },
            { "yue", "kantonesisk" },
            { "fo", "f\u00e6r\u00f8sk" },
            { "umb", "umbundu" },
            { "fr", "fransk" },
            { "sid", "sidamo" },
            { "fy", "frisisk" },
            { "ga", "irsk" },
            { "gd", "skotsk g\u00e6lisk" },
            { "gl", "galicisk" },
            { "gn", "guarani" },
            { "bho", "bhojpuri" },
            { "und", "ukendt sprog" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "ho", "hirimotu" },
            { "hr", "kroatisk" },
            { "ht", "haitisk" },
            { "hu", "ungarsk" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "%%FONIPA", "det internationale fonetiske alfabet" },
            { "ia", "interlingua" },
            { "id", "indonesisk" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "ii", "sichuan yi" },
            { "frm", "middelfransk" },
            { "ik", "inupiaq" },
            { "fro", "oldfransk" },
            { "io", "ido" },
            { "frs", "\u00f8stfrisisk" },
            { "frr", "nordfrisisk" },
            { "is", "islandsk" },
            { "it", "italiensk" },
            { "iu", "inuktitut" },
            { "%%HOGNORSK", "h\u00f8gnorsk" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "olds\u00f8rarabisk" },
            { "Sara", "sarati" },
            { "doi", "dogri" },
            { "bkm", "kom" },
            { "sma", "sydsamisk" },
            { "jv", metaValue_jv },
            { "Shaw", "shavisk" },
            { "%%BAUDDHA", "bauddha" },
            { "mad", "madurese" },
            { "smj", "lulesamisk" },
            { "mag", "magahi" },
            { "maf", "mafa" },
            { "mai", "maithili" },
            { "smn", "enaresamisk" },
            { "ka", metaValue_ka },
            { "bla", "siksika" },
            { "mak", "makasar" },
            { "sms", "skoltesamisk" },
            { "man", "mandingo" },
            { "kg", "kongo" },
            { "Goth", metaValue_got },
            { "ki", "kikuyu" },
            { "mas", "masai" },
            { "kj", "kuanyama" },
            { "kk", "kasakhisk" },
            { "kl", "gr\u00f8nlandsk" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "kashmiri" },
            { "Cirt", "cirt" },
            { "Lepc", "lepcha" },
            { "Avst", "avestansk" },
            { "ku", "kurdisk" },
            { "kv", "komi" },
            { "kw", "cornisk" },
            { "ky", "kirgisisk" },
            { "snk", "soninke" },
            { "la", "latin" },
            { "lb", "luxembourgsk" },
            { "lg", "ganda" },
            { "Roro", "rongo-rongo" },
            { "li", "limburgsk" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "friulian" },
            { "lo", metaValue_lo },
            { "lt", "litauisk" },
            { "lu", "luba-Katanga" },
            { "lv", "lettisk" },
            { "sog", "sogdiansk" },
            { "mg", "malagassisk" },
            { "mh", "marshallese" },
            { "mi", "maori" },
            { "mk", "makedonsk" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathisk" },
            { "ms", "malajisk" },
            { "mt", "maltesisk" },
            { "my", metaValue_my },
            { "Saur", "saurashtra" },
            { "Armn", metaValue_hy },
            { "mdf", "moksha" },
            { "mde", "maba" },
            { "dsb", "nedersorbisk" },
            { "Armi", "armi" },
            { "na", "nauru" },
            { "nb", "norsk bokm\u00e5l" },
            { "nd", "nordndebele" },
            { "ne", "nepalesisk" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "hollandsk" },
            { "nn", "nynorsk" },
            { "no", "norsk" },
            { "nr", "sydndebele" },
            { "nv", "navajo" },
            { "kaa", "karakalpakisk" },
            { "ny", "nyanja" },
            { "kac", "kachin" },
            { "kab", "kabylisk" },
            { "%%POLYTON", "polytonisk" },
            { "oc", "occitansk" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", metaValue_men },
            { "%%EMODENG", "tidlig moderne engelsk" },
            { "oj", "ojibwa" },
            { "mer", "meru" },
            { "om", "oromo" },
            { "kaw", "kawi" },
            { "or", metaValue_or },
            { "os", "ossetisk" },
            { "%%ALALC97", "ALA-LC-romanisering fra 1997" },
            { "kbd", "kabardian" },
            { "mfe", "morisyen" },
            { "srn", "sranan tongo" },
            { "pa", "punjabi" },
            { "dua", "duala" },
            { "srr", "serer" },
            { "%%LIPAW", "lipovaz" },
            { "kbl", "kanembu" },
            { "pi", "pali" },
            { "pl", "polsk" },
            { "dum", "middelhollandsk" },
            { "%%VALLADER", "vallader" },
            { "ps", "pashto" },
            { "pt", "portugisisk" },
            { "mga", "middelirsk" },
            { "pt_BR", "brasiliansk portugisisk" },
            { "%%BOHORIC", "Bohori\u010d-alfabet" },
            { "kcg", "tyap" },
            { "mgh", "makhuwa-meetto" },
            { "bra", "braj" },
            { "%%JAUER", "jauer" },
            { "Laoo", metaValue_lo },
            { "%%SURMIRAN", "surmiran" },
            { "mgo", "meta" },
            { "ssy", metaValue_ssy },
            { "qu", "quechua" },
            { "zap", "zapotec" },
            { "brx", "bodo" },
            { "Lana", "lanna" },
            { "kde", "makonde" },
            { "%%VAIDIKA", "vaidika" },
            { "Ethi", "etiopisk" },
            { "%%JYUTPING", "jyutping" },
            { "rm", "r\u00e6toromansk" },
            { "rn", "rundi" },
            { "ro", "rum\u00e6nsk" },
            { "%%SAAHO", metaValue_ssy },
            { "ru", "russisk" },
            { "bss", "bakossi" },
            { "zbl", metaValue_zbl },
            { "rw", "kinyarwanda" },
            { "kea", "kapverdisk" },
            { "mic", "micmac" },
            { "suk", "sukuma" },
            { "en_AU", "australsk engelsk" },
            { "Dupl", "Duploya-stenografi" },
            { "sa", "sanskrit" },
            { "%%UCCOR", "forenet ortografi" },
            { "sc", "sardinsk" },
            { "sus", "susu" },
            { "sd", "sindhi" },
            { "se", "nordsamisk" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "sh", "serbokroatisk" },
            { "si", metaValue_si },
            { "sux", "sumerisk" },
            { "sk", "slovakisk" },
            { "sl", "slovensk" },
            { "Gran", "grantha" },
            { "sm", "samoansk" },
            { "sn", "shona" },
            { "so", "somalisk" },
            { "sq", "albansk" },
            { "sr", "serbisk" },
            { "ss", "swati" },
            { "Java", metaValue_jv },
            { "st", "sydsotho" },
            { "su", metaValue_su },
            { "%%NEDIS", "Natisone-dialekt" },
            { "sv", "svensk" },
            { "sw", "swahili" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", metaValue_ta },
            { "142", "Asien" },
            { "bua", "buriatisk" },
            { "143", "Centralasien" },
            { "te", metaValue_te },
            { "145", "Vestasien" },
            { "tg", "tajik" },
            { "th", "thai" },
            { "bug", metaValue_bug },
            { "ti", "tigrinya" },
            { "kfo", "koro" },
            { "en_CA", "canadisk engelsk" },
            { "tk", "turkmensk" },
            { "tl", metaValue_tl },
            { "tn", "tswana" },
            { "to", "tongansk" },
            { "bum", "bulu" },
            { "dyo", "jola-fonyi" },
            { "tr", "tyrkisk" },
            { "ts", "tsonga" },
            { "swb", "shimaore" },
            { "Cakm", "cakm" },
            { "tt", "tatarisk" },
            { "dyu", "dyula" },
            { "tw", "twi" },
            { "ty", "tahitiansk" },
            { "%%BISKE", "San Giorgio-/Bila-dialekt" },
            { "150", "Europa" },
            { "151", "\u00d8steuropa" },
            { "154", "Nordeuropa" },
            { "dzg", "dazaga" },
            { "155", "Vesteuropa" },
            { "ug", "uygurisk" },
            { "Kore", metaValue_ko },
            { "Ital", "Olditalisk" },
            { "Zyyy", "f\u00e6lles" },
            { "uk", "ukrainsk" },
            { "ur", "urdu" },
            { "%%1994", "standardiseret Resi-ortografi" },
            { "xal", "kalmyk" },
            { "zen", "zenaga" },
            { "uz", "usbekisk" },
            { "kha", "khasi" },
            { "%%1996", "tysk retskrivning fra 1996" },
            { "Sylo", "syloti nagri" },
            { "ve", "venda" },
            { "Wara", "varang kshiti" },
            { "vi", "vietnamesisk" },
            { "kho", "khotanesisk" },
            { "khq", "koyra-chiini" },
            { "%%TARASK", "Taraskievica-ortografi" },
            { "vo", "volapyk" },
            { "syc", "klassisk syrisk" },
            { "Osma", "osmannisk" },
            { "quc", "quich\u00e9" },
            { "gaa", "ga" },
            { "wa", "vallonsk" },
            { "gag", "gagauzisk" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "Lydi", "lydisk" },
            { "Xsux", "sumero-akkadisk cuneiform" },
            { "wo", "wolof" },
            { "zgh", "tamazight" },
            { "ar_001", "moderne standardarabisk" },
            { "Cans", "oprindelige canadiske symboler" },
            { "%%FONXSAMP", "fonxsamp" },
            { "gay", "gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "manchu" },
            { "Latf", "latinsk - frakturvariant" },
            { "Hluw", "anatolske hieroglyffer" },
            { "gba", "gbaya" },
            { "mni", "manipuri" },
            { "Latn", "latinsk" },
            { "Latg", "latinsk - g\u00e6lisk variant" },
            { "xh", "xhosa" },
            { "byn", "blin" },
            { "%%PAMAKA", "Pamaka-dialekt" },
            { "Lyci", "lykisk" },
            { "osa", "osage" },
            { "byv", "medumba" },
            { "Moon", "moon" },
            { "moh", "mohawk" },
            { "kkj", "kako" },
            { "%%1694ACAD", "tidlig moderne fransk" },
            { "Syrc", metaValue_syr },
            { "yi", "jiddisch" },
            { "mos", "mossi" },
            { "Dsrt", "deseret" },
            { "yo", "yoruba" },
            { "es_MX", "mexicansk spansk" },
            { "Syrj", "vestsyrisk" },
            { "ota", "osmannisk-tyrkisk" },
            { "Syre", "syrisk - estrangelovariant" },
            { "vai", metaValue_vai },
            { "za", "zhuang" },
            { "Cari", "kariansk" },
            { "kln", "kalenjin" },
            { "zh", "kinesisk" },
            { "Afak", "afaka" },
            { "Bopo", "bopomofo" },
            { "Perm", "oldpermisk" },
            { "zu", "zulu" },
            { "%%MONOTON", "monotonisk" },
            { "Geor", metaValue_ka },
            { "Shrd", "sharada" },
            { "kmb", "kimbundu" },
            { "Cham", "cham" },
            { "gez", "geez" },
            { "Syrn", "\u00f8stsyriakisk" },
            { "Narb", "gammelt nordarabisk" },
            { "Tglg", metaValue_tl },
            { "Egyd", "egyptisk demotisk" },
            { "Egyh", "egyptisk hieratisk" },
            { "%%ITIHASA", "itihasa" },
            { "Palm", "palmyrensk" },
            { "ebu", "kiembu" },
            { "Egyp", "egyptiske hieroglyffer" },
            { "Geok", "georgisk kutsuri" },
            { "zh_Hans", "forenklet kinesisk" },
            { "koi", "komi-permjakisk" },
            { "Hung", "oldungarsk" },
            { "kok", "konkani" },
            { "%%1901", "traditionel tysk retskrivning" },
            { "kos", "kosraean" },
            { "zh_Hant", "traditionelt kinesisk" },
            { "Sund", metaValue_su },
            { "kpe", metaValue_kpe },
            { "Tirh", "tirhuta" },
            { "ilo", "iloko" },
            { "%%VALENCIA", "valenciansk" },
            { "Cprt", "cypriotisk" },
            { "%%BAKU1926", "forenet tyrkisk-latinsk alfabet" },
            { "mua", "mundang" },
            { "mul", "flere sprog" },
            { "cad", "caddo" },
            { "mus", "creek" },
            { "Glag", "glagolitisk" },
            { "gil", "gilbertesisk" },
            { "%%KKCOR", "almindelig ortografi" },
            { "Cher", metaValue_chr },
            { "car", "caribisk" },
            { "cay", "cayuga" },
            { "krc", "karatjai-balkar" },
            { "inh", "ingush" },
            { "krl", "karelsk" },
            { "efi", "efik" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
