/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.awt.Color;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import javax.xml.stream.XMLStreamException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.StructUtils;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.data.preferences.PreferencesReader;
import org.openstreetmap.josm.data.preferences.PreferencesWriter;
import org.openstreetmap.josm.data.preferences.sources.ExtendedSourceEntry;
import org.openstreetmap.josm.data.preferences.sources.ValidatorPrefHelper;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.spi.preferences.AbstractPreferences;
import org.openstreetmap.josm.spi.preferences.IBaseDirectories;
import org.openstreetmap.josm.spi.preferences.ListListSetting;
import org.openstreetmap.josm.spi.preferences.ListSetting;
import org.openstreetmap.josm.spi.preferences.MapListSetting;
import org.openstreetmap.josm.spi.preferences.Setting;
import org.openstreetmap.josm.spi.preferences.StringSetting;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class Preferences
extends AbstractPreferences
implements IBaseDirectories {
    private static final String COLOR_PREFIX = "color.";
    private static final String[] OBSOLETE_PREF_KEYS = new String[]{"imagery.layers.addedIds", "projection", "projection.sub"};
    private static final long MAX_AGE_DEFAULT_PREFERENCES = TimeUnit.DAYS.toSeconds(50L);
    private File preferencesDir;
    private File cacheDir;
    private File userdataDir;
    private boolean saveOnPut = true;
    protected final SortedMap<String, Setting<?>> settingsMap = new TreeMap();
    protected final SortedMap<String, Setting<?>> defaultsMap = new TreeMap();
    private final Predicate<Map.Entry<String, Setting<?>>> NO_DEFAULT_SETTINGS_ENTRY = e -> !((Setting)e.getValue()).equals(this.defaultsMap.get(e.getKey()));
    protected final SortedMap<String, String> colornames = new TreeMap<String, String>();
    protected boolean initSuccessful;
    private final ListenerList<org.openstreetmap.josm.spi.preferences.PreferenceChangedListener> listeners = ListenerList.create();
    private final HashMap<String, ListenerList<org.openstreetmap.josm.spi.preferences.PreferenceChangedListener>> keyListeners = new HashMap();
    @Deprecated
    private final ListenerList<PreferenceChangedListener> listenersDeprecated = ListenerList.create();
    @Deprecated
    private final HashMap<String, ListenerList<PreferenceChangedListener>> keyListenersDeprecated = new HashMap();

    public Preferences() {
    }

    public Preferences(Preferences pref2) {
        this.settingsMap.putAll(pref2.settingsMap);
        this.defaultsMap.putAll(pref2.defaultsMap);
        this.colornames.putAll(pref2.colornames);
    }

    @Override
    public void addPreferenceChangeListener(org.openstreetmap.josm.spi.preferences.PreferenceChangedListener listener) {
        if (listener != null) {
            this.listeners.addListener(listener);
        }
    }

    @Deprecated
    public void addPreferenceChangeListener(PreferenceChangedListener listener) {
        if (listener != null) {
            this.listenersDeprecated.addListener(listener);
        }
    }

    @Override
    public void removePreferenceChangeListener(org.openstreetmap.josm.spi.preferences.PreferenceChangedListener listener) {
        this.listeners.removeListener(listener);
    }

    @Deprecated
    public void removePreferenceChangeListener(PreferenceChangedListener listener) {
        this.listenersDeprecated.removeListener(listener);
    }

    @Override
    public void addKeyPreferenceChangeListener(String key, org.openstreetmap.josm.spi.preferences.PreferenceChangedListener listener) {
        this.listenersForKey(key).addListener(listener);
    }

    @Deprecated
    public void addKeyPreferenceChangeListener(String key, PreferenceChangedListener listener) {
        this.listenersForKeyDeprecated(key).addListener(listener);
    }

    public void addWeakKeyPreferenceChangeListener(String key, org.openstreetmap.josm.spi.preferences.PreferenceChangedListener listener) {
        this.listenersForKey(key).addWeakListener(listener);
    }

    private ListenerList<org.openstreetmap.josm.spi.preferences.PreferenceChangedListener> listenersForKey(String key) {
        return this.keyListeners.computeIfAbsent(key, k -> ListenerList.create());
    }

    @Deprecated
    private ListenerList<PreferenceChangedListener> listenersForKeyDeprecated(String key) {
        return this.keyListenersDeprecated.computeIfAbsent(key, k -> ListenerList.create());
    }

    @Override
    public void removeKeyPreferenceChangeListener(String key, org.openstreetmap.josm.spi.preferences.PreferenceChangedListener listener) {
        Optional.ofNullable(this.keyListeners.get(key)).orElseThrow(() -> new IllegalArgumentException("There are no listeners registered for " + key)).removeListener(listener);
    }

    @Deprecated
    public void removeKeyPreferenceChangeListener(String key, PreferenceChangedListener listener) {
        Optional.ofNullable(this.keyListenersDeprecated.get(key)).orElseThrow(() -> new IllegalArgumentException("There are no listeners registered for " + key)).removeListener(listener);
    }

    protected void firePreferenceChanged(String key, Setting<?> oldValue, Setting<?> newValue) {
        org.openstreetmap.josm.spi.preferences.DefaultPreferenceChangeEvent evt = new org.openstreetmap.josm.spi.preferences.DefaultPreferenceChangeEvent(key, oldValue, newValue);
        this.listeners.fireEvent(listener -> listener.preferenceChanged(evt));
        ListenerList<org.openstreetmap.josm.spi.preferences.PreferenceChangedListener> forKey = this.keyListeners.get(key);
        if (forKey != null) {
            forKey.fireEvent(listener -> listener.preferenceChanged(evt));
        }
        this.firePreferenceChangedDeprecated(key, oldValue, newValue);
    }

    @Deprecated
    private void firePreferenceChangedDeprecated(String key, Setting<?> oldValue, Setting<?> newValue) {
        DefaultPreferenceChangeEvent evtDeprecated = new DefaultPreferenceChangeEvent(key, oldValue, newValue);
        this.listenersDeprecated.fireEvent(listener -> listener.preferenceChanged(evtDeprecated));
        ListenerList<PreferenceChangedListener> forKeyDeprecated = this.keyListenersDeprecated.get(key);
        if (forKeyDeprecated != null) {
            forKeyDeprecated.fireEvent(listener -> listener.preferenceChanged(evtDeprecated));
        }
    }

    public String getJOSMDirectoryBaseName() {
        String name = System.getProperty("josm.dir.name");
        if (name != null) {
            return name;
        }
        return "JOSM";
    }

    @Deprecated
    public File getPreferencesDirectory() {
        return this.getPreferencesDirectory(false);
    }

    @Override
    public File getPreferencesDirectory(boolean createIfMissing) {
        if (this.preferencesDir == null) {
            String path = System.getProperty("josm.pref");
            this.preferencesDir = path != null ? new File(path).getAbsoluteFile() : ((path = System.getProperty("josm.home")) != null ? new File(path).getAbsoluteFile() : Main.platform.getDefaultPrefDirectory());
        }
        if (createIfMissing && !this.preferencesDir.exists() && !this.preferencesDir.mkdirs()) {
            Logging.warn(I18n.tr("Failed to create missing preferences directory: {0}", this.preferencesDir.getAbsoluteFile()));
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to create missing preferences directory: {0}</html>", this.preferencesDir.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
        }
        return this.preferencesDir;
    }

    @Deprecated
    public File getUserDataDirectory() {
        return this.getUserDataDirectory(false);
    }

    @Override
    public File getUserDataDirectory(boolean createIfMissing) {
        if (this.userdataDir == null) {
            String path = System.getProperty("josm.userdata");
            this.userdataDir = path != null ? new File(path).getAbsoluteFile() : ((path = System.getProperty("josm.home")) != null ? new File(path).getAbsoluteFile() : Main.platform.getDefaultUserDataDirectory());
        }
        if (createIfMissing && !this.userdataDir.exists() && !this.userdataDir.mkdirs()) {
            Logging.warn(I18n.tr("Failed to create missing user data directory: {0}", this.userdataDir.getAbsoluteFile()));
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to create missing user data directory: {0}</html>", this.userdataDir.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
        }
        return this.userdataDir;
    }

    public File getPreferenceFile() {
        return new File(this.getPreferencesDirectory(false), "preferences.xml");
    }

    public File getDefaultsCacheFile() {
        return new File(this.getCacheDirectory(true), "default_preferences.xml");
    }

    public File getPluginsDirectory() {
        return new File(this.getUserDataDirectory(false), "plugins");
    }

    @Deprecated
    public File getCacheDirectory() {
        return this.getCacheDirectory(true);
    }

    @Override
    public File getCacheDirectory(boolean createIfMissing) {
        if (this.cacheDir == null) {
            String path = System.getProperty("josm.cache");
            this.cacheDir = path != null ? new File(path).getAbsoluteFile() : ((path = System.getProperty("josm.home")) != null ? new File(path, "cache") : ((path = this.get("cache.folder", null)) != null ? new File(path).getAbsoluteFile() : Main.platform.getDefaultCacheDirectory()));
        }
        if (createIfMissing && !this.cacheDir.exists() && !this.cacheDir.mkdirs()) {
            Logging.warn(I18n.tr("Failed to create missing cache directory: {0}", this.cacheDir.getAbsoluteFile()));
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to create missing cache directory: {0}</html>", this.cacheDir.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
        }
        return this.cacheDir;
    }

    private static void addPossibleResourceDir(Set<String> locations, String s) {
        if (s != null) {
            if (!s.endsWith(File.separator)) {
                s = s + File.separator;
            }
            locations.add(s);
        }
    }

    public Collection<String> getAllPossiblePreferenceDirs() {
        HashSet<String> locations = new HashSet<String>();
        Preferences.addPossibleResourceDir(locations, this.getPreferencesDirectory(false).getPath());
        Preferences.addPossibleResourceDir(locations, this.getUserDataDirectory(false).getPath());
        Preferences.addPossibleResourceDir(locations, System.getenv("JOSM_RESOURCES"));
        Preferences.addPossibleResourceDir(locations, System.getProperty("josm.resources"));
        if (Main.isPlatformWindows()) {
            String appdata = System.getenv("APPDATA");
            if (appdata != null && System.getenv("ALLUSERSPROFILE") != null && appdata.lastIndexOf(File.separator) != -1) {
                appdata = appdata.substring(appdata.lastIndexOf(File.separator));
                locations.add(new File(new File(System.getenv("ALLUSERSPROFILE"), appdata), "JOSM").getPath());
            }
        } else {
            locations.add("/usr/local/share/josm/");
            locations.add("/usr/local/lib/josm/");
            locations.add("/usr/share/josm/");
            locations.add("/usr/lib/josm/");
        }
        return locations;
    }

    public synchronized Map<String, String> getAllPrefix(String prefix) {
        TreeMap<String, String> all = new TreeMap<String, String>();
        for (Map.Entry<String, Setting<?>> e : this.settingsMap.entrySet()) {
            if (!e.getKey().startsWith(prefix) || !(e.getValue() instanceof StringSetting)) continue;
            all.put(e.getKey(), (String)((StringSetting)e.getValue()).getValue());
        }
        return all;
    }

    public synchronized List<String> getAllPrefixCollectionKeys(String prefix) {
        LinkedList<String> all = new LinkedList<String>();
        for (Map.Entry<String, Setting<?>> entry : this.settingsMap.entrySet()) {
            if (!entry.getKey().startsWith(prefix) || !(entry.getValue() instanceof ListSetting)) continue;
            all.add(entry.getKey());
        }
        return all;
    }

    public synchronized Map<String, String> getAllColors() {
        TreeMap<String, String> all = new TreeMap<String, String>();
        for (Map.Entry<String, Setting<?>> e : this.defaultsMap.entrySet()) {
            StringSetting d;
            if (!e.getKey().startsWith(COLOR_PREFIX) || !(e.getValue() instanceof StringSetting) || (d = (StringSetting)e.getValue()).getValue() == null) continue;
            all.put(e.getKey().substring(6), (String)d.getValue());
        }
        for (Map.Entry<String, Setting<?>> e : this.settingsMap.entrySet()) {
            if (!e.getKey().startsWith(COLOR_PREFIX) || !(e.getValue() instanceof StringSetting)) continue;
            all.put(e.getKey().substring(6), (String)((StringSetting)e.getValue()).getValue());
        }
        return all;
    }

    @Deprecated
    public synchronized boolean getBoolean(String key, String specName, boolean def) {
        boolean generic = this.getBoolean(key, def);
        String skey = key + '.' + specName;
        Setting prop = (Setting)this.settingsMap.get(skey);
        if (prop instanceof StringSetting) {
            return Boolean.parseBoolean((String)((StringSetting)prop).getValue());
        }
        return generic;
    }

    @Deprecated
    public boolean put(String key, boolean value) {
        return this.put(key, Boolean.toString(value));
    }

    @Deprecated
    public boolean putInteger(String key, Integer value) {
        return this.put(key, Integer.toString(value));
    }

    @Deprecated
    public boolean putDouble(String key, Double value) {
        return this.put(key, Double.toString(value));
    }

    @Deprecated
    public boolean putLong(String key, Long value) {
        return this.put(key, Long.toString(value));
    }

    public synchronized void save() throws IOException {
        this.save(this.getPreferenceFile(), this.settingsMap.entrySet().stream().filter(this.NO_DEFAULT_SETTINGS_ENTRY), false);
    }

    public synchronized void saveDefaults() throws IOException {
        this.save(this.getDefaultsCacheFile(), this.defaultsMap.entrySet().stream(), true);
    }

    protected void save(File prefFile, Stream<Map.Entry<String, Setting<?>>> settings, boolean defaults) throws IOException {
        if (!defaults) {
            this.putInt("josm.version", Version.getInstance().getVersion());
            this.updateSystemProperties();
        }
        File backupFile = new File(prefFile + "_backup");
        if (this.initSuccessful && prefFile.exists() && prefFile.length() > 0L) {
            Utils.copyFile(prefFile, backupFile);
        }
        try (PreferencesWriter writer = new PreferencesWriter(new PrintWriter(new File(prefFile + "_tmp"), StandardCharsets.UTF_8.name()), false, defaults);){
            writer.write(settings);
        }
        File tmpFile = new File(prefFile + "_tmp");
        Utils.copyFile(tmpFile, prefFile);
        Utils.deleteFile(tmpFile, I18n.marktr("Unable to delete temporary file {0}"));
        Preferences.setCorrectPermissions(prefFile);
        Preferences.setCorrectPermissions(backupFile);
    }

    private static void setCorrectPermissions(File file) {
        if (!file.setReadable(false, false) && Logging.isTraceEnabled()) {
            Logging.trace(I18n.tr("Unable to set file non-readable {0}", file.getAbsolutePath()));
        }
        if (!file.setWritable(false, false) && Logging.isTraceEnabled()) {
            Logging.trace(I18n.tr("Unable to set file non-writable {0}", file.getAbsolutePath()));
        }
        if (!file.setExecutable(false, false) && Logging.isTraceEnabled()) {
            Logging.trace(I18n.tr("Unable to set file non-executable {0}", file.getAbsolutePath()));
        }
        if (!file.setReadable(true, true) && Logging.isTraceEnabled()) {
            Logging.trace(I18n.tr("Unable to set file readable {0}", file.getAbsolutePath()));
        }
        if (!file.setWritable(true, true) && Logging.isTraceEnabled()) {
            Logging.trace(I18n.tr("Unable to set file writable {0}", file.getAbsolutePath()));
        }
    }

    protected void load() throws IOException, SAXException, XMLStreamException {
        File pref2 = this.getPreferenceFile();
        PreferencesReader.validateXML(pref2);
        PreferencesReader reader = new PreferencesReader(pref2, false);
        reader.parse();
        this.settingsMap.clear();
        this.settingsMap.putAll(reader.getSettings());
        this.updateSystemProperties();
        this.removeObsolete(reader.getVersion());
    }

    protected void loadDefaults() throws IOException, XMLStreamException, SAXException {
        File def = this.getDefaultsCacheFile();
        PreferencesReader.validateXML(def);
        PreferencesReader reader = new PreferencesReader(def, true);
        reader.parse();
        this.defaultsMap.clear();
        long minTime = System.currentTimeMillis() / 1000L - MAX_AGE_DEFAULT_PREFERENCES;
        for (Map.Entry<String, Setting<?>> e : reader.getSettings().entrySet()) {
            if (e.getValue().getTime() < minTime) continue;
            this.defaultsMap.put(e.getKey(), e.getValue());
        }
    }

    public void fromXML(Reader in) throws XMLStreamException, IOException {
        PreferencesReader reader = new PreferencesReader(in, false);
        reader.parse();
        this.settingsMap.clear();
        this.settingsMap.putAll(reader.getSettings());
    }

    public void init(boolean reset) {
        block16: {
            this.initSuccessful = false;
            File prefDir = this.getPreferencesDirectory(false);
            if (prefDir.exists()) {
                if (!prefDir.isDirectory()) {
                    Logging.warn(I18n.tr("Failed to initialize preferences. Preference directory ''{0}'' is not a directory.", prefDir.getAbsoluteFile()));
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Preference directory ''{0}'' is not a directory.</html>", prefDir.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
                    return;
                }
            } else if (!prefDir.mkdirs()) {
                Logging.warn(I18n.tr("Failed to initialize preferences. Failed to create missing preference directory: {0}", prefDir.getAbsoluteFile()));
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Failed to create missing preference directory: {0}</html>", prefDir.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
                return;
            }
            File preferenceFile = this.getPreferenceFile();
            try {
                if (!preferenceFile.exists()) {
                    Logging.info(I18n.tr("Missing preference file ''{0}''. Creating a default preference file.", preferenceFile.getAbsoluteFile()));
                    this.resetToDefault();
                    this.save();
                } else if (reset) {
                    File backupFile = new File(prefDir, "preferences.xml.bak");
                    Main.platform.rename(preferenceFile, backupFile);
                    Logging.warn(I18n.tr("Replacing existing preference file ''{0}'' with default preference file.", preferenceFile.getAbsoluteFile()));
                    this.resetToDefault();
                    this.save();
                }
            }
            catch (IOException e) {
                Logging.error(e);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Failed to reset preference file to default: {0}</html>", this.getPreferenceFile().getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
                return;
            }
            try {
                this.load();
                this.initSuccessful = true;
            }
            catch (IOException | XMLStreamException | SAXException e) {
                Logging.error(e);
                File backupFile = new File(prefDir, "preferences.xml.bak");
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Preferences file had errors.<br> Making backup of old one to <br>{0}<br> and creating a new default preference file.</html>", backupFile.getAbsoluteFile()), I18n.tr("Error", new Object[0]), 0);
                Main.platform.rename(preferenceFile, backupFile);
                try {
                    this.resetToDefault();
                    this.save();
                }
                catch (IOException e1) {
                    Logging.error(e1);
                    Logging.warn(I18n.tr("Failed to initialize preferences. Failed to reset preference file to default: {0}", this.getPreferenceFile()));
                }
            }
            File def = this.getDefaultsCacheFile();
            if (def.exists()) {
                try {
                    this.loadDefaults();
                }
                catch (IOException | XMLStreamException | SAXException e) {
                    Logging.error(e);
                    Logging.warn(I18n.tr("Failed to load defaults cache file: {0}", def));
                    this.defaultsMap.clear();
                    if (def.delete()) break block16;
                    Logging.warn(I18n.tr("Failed to delete faulty defaults cache file: {0}", def));
                }
            }
        }
    }

    public void resetToInitialState() {
        this.resetToDefault();
        this.preferencesDir = null;
        this.cacheDir = null;
        this.userdataDir = null;
        this.saveOnPut = true;
        this.initSuccessful = false;
    }

    public final void resetToDefault() {
        this.settingsMap.clear();
    }

    @Deprecated
    public synchronized Color getColor(String colName, Color def) {
        return this.getColor(colName, null, def);
    }

    public synchronized String getColorName(String o) {
        Matcher m = Pattern.compile("mappaint\\.(.+?)\\.(.+)").matcher(o);
        if (m.matches()) {
            return I18n.tr("Paint style {0}: {1}", I18n.tr(I18n.escape(m.group(1)), new Object[0]), I18n.tr(I18n.escape(m.group(2)), new Object[0]));
        }
        m = Pattern.compile("layer (.+)").matcher(o);
        if (m.matches()) {
            return I18n.tr("Layer: {0}", I18n.tr(I18n.escape(m.group(1)), new Object[0]));
        }
        return I18n.tr(I18n.escape(this.colornames.containsKey(o) ? (String)this.colornames.get(o) : o), new Object[0]);
    }

    @Deprecated
    public synchronized Color getColor(String colName, String specName, Color def) {
        String colStr;
        String colKey = ColorProperty.getColorKey(colName);
        this.registerColor(colKey, colName);
        String string = colStr = specName != null ? this.get(COLOR_PREFIX + specName) : "";
        if (colStr.isEmpty()) {
            colStr = this.get(colKey, ColorHelper.color2html(def, true));
        }
        if (colStr != null && !colStr.isEmpty()) {
            return ColorHelper.html2color(colStr);
        }
        return def;
    }

    public void registerColor(String colKey, String colName) {
        if (!colKey.equals(colName)) {
            this.colornames.put(colKey, colName);
        }
    }

    public synchronized Color getDefaultColor(String colKey) {
        StringSetting col = Utils.cast(this.defaultsMap.get(COLOR_PREFIX + colKey), StringSetting.class);
        String colStr = col == null ? null : (String)col.getValue();
        return colStr == null || colStr.isEmpty() ? null : ColorHelper.html2color(colStr);
    }

    public synchronized boolean putColor(String colKey, Color val) {
        return this.put(COLOR_PREFIX + colKey, val != null ? ColorHelper.color2html(val, true) : null);
    }

    @Deprecated
    public synchronized int getInteger(String key, int def) {
        String v = this.get(key, Integer.toString(def));
        if (v.isEmpty()) {
            return def;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            Logging.trace(e);
            return def;
        }
    }

    @Deprecated
    public synchronized int getInteger(String key, String specName, int def) {
        String v = this.get(key + '.' + specName);
        if (v.isEmpty()) {
            v = this.get(key, Integer.toString(def));
        }
        if (v.isEmpty()) {
            return def;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            Logging.trace(e);
            return def;
        }
    }

    @Deprecated
    public Collection<String> getCollection(String key, Collection<String> def) {
        return (Collection)this.getSetting(key, ListSetting.create(def), ListSetting.class).getValue();
    }

    @Deprecated
    public Collection<String> getCollection(String key) {
        List<String> val = this.getList(key, null);
        return val == null ? Collections.emptyList() : val;
    }

    @Deprecated
    public synchronized void removeFromCollection(String key, String value) {
        ArrayList<String> a = new ArrayList<String>(this.getList(key, Collections.emptyList()));
        a.remove(value);
        this.putList(key, a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putSetting(String key, Setting<?> setting) {
        Setting settingOld;
        CheckParameterUtil.ensureParameterNotNull(key);
        if (setting != null && setting.getValue() == null) {
            throw new IllegalArgumentException("setting argument must not have null value");
        }
        Setting<?> settingCopy = null;
        Preferences preferences = this;
        synchronized (preferences) {
            if (setting == null) {
                settingOld = (Setting)this.settingsMap.remove(key);
                if (settingOld == null) {
                    return false;
                }
            } else {
                settingOld = (Setting)this.settingsMap.get(key);
                if (setting.equals(settingOld)) {
                    return false;
                }
                if (settingOld == null && setting.equals(this.defaultsMap.get(key))) {
                    return false;
                }
                settingCopy = setting.copy();
                this.settingsMap.put(key, settingCopy);
            }
            if (this.saveOnPut) {
                try {
                    this.save();
                }
                catch (IOException e) {
                    Logging.log(Logging.LEVEL_WARN, I18n.tr("Failed to persist preferences to ''{0}''", this.getPreferenceFile().getAbsoluteFile()), e);
                }
            }
        }
        this.firePreferenceChanged(key, settingOld, settingCopy);
        return true;
    }

    public synchronized Setting<?> getSetting(String key, Setting<?> def) {
        return this.getSetting(key, def, Setting.class);
    }

    @Override
    public synchronized <T extends Setting<?>> T getSetting(String key, T def, Class<T> klass) {
        Setting prop;
        CheckParameterUtil.ensureParameterNotNull(key);
        CheckParameterUtil.ensureParameterNotNull(def);
        Setting oldDef = (Setting)this.defaultsMap.get(key);
        if (oldDef != null && oldDef.isNew() && oldDef.getValue() != null && def.getValue() != null && !def.equals(oldDef)) {
            Logging.info("Defaults for " + key + " differ: " + def + " != " + this.defaultsMap.get(key));
        }
        if (def.getValue() != null || oldDef == null) {
            Setting<?> defCopy = def.copy();
            defCopy.setTime(System.currentTimeMillis() / 1000L);
            defCopy.setNew(true);
            this.defaultsMap.put(key, defCopy);
        }
        if (klass.isInstance(prop = (Setting)this.settingsMap.get(key))) {
            return (T)prop;
        }
        return def;
    }

    @Deprecated
    public boolean putCollection(String key, Collection<String> value) {
        return this.putSetting(key, value == null ? null : ListSetting.create(value));
    }

    @Deprecated
    public boolean putCollectionBounded(String key, int maxsize, Collection<String> val) {
        ArrayList<String> newCollection = new ArrayList<String>(Math.min(maxsize, val.size()));
        for (String i : val) {
            if (newCollection.size() >= maxsize) break;
            newCollection.add(i);
        }
        return this.putList(key, newCollection);
    }

    @Deprecated
    public synchronized Collection<Collection<String>> getArray(String key, Collection<Collection<String>> def) {
        ListListSetting val = this.getSetting(key, ListListSetting.create(def), ListListSetting.class);
        return (Collection)val.getValue();
    }

    @Deprecated
    public Collection<Collection<String>> getArray(String key) {
        Collection<Collection<String>> res = this.getArray(key, null);
        return res == null ? Collections.emptyList() : res;
    }

    @Deprecated
    public boolean putArray(String key, Collection<Collection<String>> value) {
        return this.putSetting(key, value == null ? null : ListListSetting.create(value));
    }

    @Deprecated
    public Collection<Map<String, String>> getListOfStructs(String key, Collection<Map<String, String>> def) {
        return (Collection)this.getSetting(key, new MapListSetting((List<Map<String, String>>)(def == null ? null : new ArrayList<Map<String, String>>(def))), MapListSetting.class).getValue();
    }

    @Deprecated
    public boolean putListOfStructs(String key, Collection<Map<String, String>> value) {
        return this.putSetting(key, value == null ? null : new MapListSetting((List<Map<String, String>>)new ArrayList<Map<String, String>>(value)));
    }

    @Deprecated
    public <T> List<T> getListOfStructs(String key, Class<T> klass) {
        return StructUtils.getListOfStructs(this, key, klass);
    }

    @Deprecated
    public <T> List<T> getListOfStructs(String key, Collection<T> def, Class<T> klass) {
        return StructUtils.getListOfStructs(this, key, def, klass);
    }

    @Deprecated
    public <T> boolean putListOfStructs(String key, Collection<T> val, Class<T> klass) {
        return StructUtils.putListOfStructs(this, key, val, klass);
    }

    @Deprecated
    public static <T> Map<String, String> serializeStruct(T struct, Class<T> klass) {
        return StructUtils.serializeStruct(struct, klass);
    }

    @Deprecated
    public static <T> T deserializeStruct(Map<String, String> hash, Class<T> klass) {
        return StructUtils.deserializeStruct(hash, klass);
    }

    public Map<String, Setting<?>> getAllSettings() {
        return new TreeMap(this.settingsMap);
    }

    public Map<String, Setting<?>> getAllDefaults() {
        return new TreeMap(this.defaultsMap);
    }

    public void updateSystemProperties() {
        if ("true".equals(this.get("prefer.ipv6", "auto")) && !"true".equals(Utils.updateSystemProperty("java.net.preferIPv6Addresses", "true"))) {
            Logging.info(I18n.tr("Try enabling IPv6 network, prefering IPv6 over IPv4 (only works on early startup).", new Object[0]));
        }
        Utils.updateSystemProperty("http.agent", Version.getInstance().getAgentString());
        Utils.updateSystemProperty("user.language", this.get("language"));
        if (Utils.getJavaVersion() < 9 && !GraphicsEnvironment.isHeadless()) {
            try {
                Field field = Toolkit.class.getDeclaredField("resources");
                Utils.setObjectsAccessible(field);
                field.set(null, ResourceBundle.getBundle("sun.awt.resources.awt"));
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                Logging.warn(e);
            }
        }
        if (this.getBoolean("jdk.tls.disableSNIExtension", false)) {
            Utils.updateSystemProperty("jsse.enableSNIExtension", "false");
        }
    }

    public Collection<String> getPluginSites() {
        return this.getList("pluginmanager.sites", Collections.singletonList(Main.getJOSMWebsite() + "/pluginicons%<?plugins=>"));
    }

    public Collection<String> getOnlinePluginSites() {
        ArrayList<String> pluginSites = new ArrayList<String>(this.getPluginSites());
        Iterator it = pluginSites.iterator();
        while (it.hasNext()) {
            try {
                OnlineResource.JOSM_WEBSITE.checkOfflineAccess((String)it.next(), Main.getJOSMWebsite());
            }
            catch (OfflineAccessException ex) {
                Logging.log(Logging.LEVEL_WARN, ex);
                it.remove();
            }
        }
        return pluginSites;
    }

    public void setPluginSites(Collection<String> sites) {
        this.putList("pluginmanager.sites", new ArrayList<String>(sites));
    }

    public String toXML(boolean nopass) {
        return this.toXML(this.settingsMap.entrySet(), nopass, false);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String toXML(Collection<Map.Entry<String, Setting<?>>> settings, boolean nopass, boolean defaults) {
        try {
            Throwable throwable = null;
            try (StringWriter sw = new StringWriter();){
                String string;
                PreferencesWriter prefWriter = new PreferencesWriter(new PrintWriter(sw), nopass, defaults);
                Throwable throwable2 = null;
                try {
                    prefWriter.write(settings);
                    sw.flush();
                    string = sw.toString();
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            Preferences.$closeResource(throwable2, prefWriter);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                Preferences.$closeResource(throwable2, prefWriter);
                return string;
            }
        }
        catch (IOException e) {
            Logging.error(e);
            return null;
        }
    }

    private void removeObsolete(int loadedVersion) {
        this.removeUrlFromEntries(loadedVersion, 10063, "validator.org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker.entries", "resource://data/validator/power.mapcss");
        if (loadedVersion < 11058) {
            this.migrateOldColorKeys();
        }
        if (loadedVersion < 11424) {
            this.addNewerDefaultEntry("validator.org.openstreetmap.josm.data.validation.tests.MapCSSTagChecker.entries", "resource://data/validator/territories.mapcss");
        }
        for (String key : OBSOLETE_PREF_KEYS) {
            if (!this.settingsMap.containsKey(key)) continue;
            this.settingsMap.remove(key);
            Logging.info(I18n.tr("Preference setting {0} has been removed since it is no longer used.", key));
        }
    }

    private void migrateOldColorKeys() {
        this.settingsMap.keySet().stream().filter(key -> key.startsWith(COLOR_PREFIX)).flatMap(this::searchOldColorKey).collect(Collectors.toList()).forEach(entry -> {
            String oldKey = (String)entry.getKey();
            String newKey = (String)entry.getValue();
            Logging.info("Migrating old color key {0} => {1}", oldKey, newKey);
            this.put(newKey, this.get(oldKey));
            this.put(oldKey, null);
        });
    }

    private Stream<AbstractMap.SimpleImmutableEntry<String, String>> searchOldColorKey(String key) {
        String newKey = ColorProperty.getColorKey(key.substring(COLOR_PREFIX.length()));
        return key.equals(newKey) || this.settingsMap.containsKey(newKey) ? Stream.empty() : Stream.of(new AbstractMap.SimpleImmutableEntry<String, String>(key, newKey));
    }

    private void removeUrlFromEntries(int loadedVersion, int versionMax, String key, String urlPart) {
        Setting setting;
        if (loadedVersion < versionMax && (setting = (Setting)this.settingsMap.get(key)) instanceof MapListSetting) {
            LinkedList<Map<String, String>> l = new LinkedList<Map<String, String>>();
            boolean modified = false;
            for (Map map : (List)((MapListSetting)setting).getValue()) {
                String url = (String)map.get("url");
                if (url != null && url.contains(urlPart)) {
                    modified = true;
                    continue;
                }
                l.add(map);
            }
            if (modified) {
                this.putListOfMaps(key, l);
            }
        }
    }

    private void addNewerDefaultEntry(String key, String url) {
        ArrayList<Map<String, String>> l;
        Setting setting = (Setting)this.settingsMap.get(key);
        if (setting instanceof MapListSetting && (l = new ArrayList<Map<String, String>>((Collection)((MapListSetting)setting).getValue())).stream().noneMatch(x -> x.containsValue(url))) {
            ValidatorPrefHelper helper = ValidatorPrefHelper.INSTANCE;
            Optional<ExtendedSourceEntry> val = helper.getDefault().stream().filter(x -> url.equals(x.url)).findFirst();
            if (val.isPresent()) {
                l.add(helper.serialize(val.get()));
            }
            this.putListOfMaps(key, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enableSaveOnPut(boolean enable) {
        Preferences preferences = this;
        synchronized (preferences) {
            this.saveOnPut = enable;
        }
    }

    @Deprecated
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface writeExplicitly {
    }

    @Deprecated
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface pref {
    }

    @Deprecated
    private static class DefaultPreferenceChangeEvent
    implements PreferenceChangeEvent {
        private final String key;
        private final Setting<?> oldValue;
        private final Setting<?> newValue;

        DefaultPreferenceChangeEvent(String key, Setting<?> oldValue, Setting<?> newValue) {
            this.key = key;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Setting<?> getOldValue() {
            return this.oldValue;
        }

        @Override
        public Setting<?> getNewValue() {
            return this.newValue;
        }
    }

    @FunctionalInterface
    @Deprecated
    public static interface PreferenceChangedListener {
        public void preferenceChanged(PreferenceChangeEvent var1);
    }

    @Deprecated
    public static interface PreferenceChangeEvent {
        public String getKey();

        public Setting<?> getOldValue();

        public Setting<?> getNewValue();
    }
}

