/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.event;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.MainLayerManager;

public class SelectionEventManager
implements DataSelectionListener,
MainLayerManager.ActiveLayerChangeListener {
    private static final SelectionEventManager INSTANCE = new SelectionEventManager();
    private final CopyOnWriteArrayList<ListenerInfo> inEDTListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ListenerInfo> immedatelyListeners = new CopyOnWriteArrayList();

    public static SelectionEventManager getInstance() {
        return INSTANCE;
    }

    protected SelectionEventManager() {
        MainLayerManager layerManager = MainApplication.getLayerManager();
        layerManager.addAndFireActiveLayerChangeListener(this);
    }

    public void addSelectionListener(SelectionChangedListener listener, DatasetEventManager.FireMode fireMode) {
        if (fireMode == DatasetEventManager.FireMode.IN_EDT) {
            throw new UnsupportedOperationException("IN_EDT mode not supported, you probably want to use IN_EDT_CONSOLIDATED.");
        }
        if (fireMode == DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED) {
            this.inEDTListeners.addIfAbsent(new OldListenerInfo(listener));
        } else {
            this.immedatelyListeners.addIfAbsent(new OldListenerInfo(listener));
        }
    }

    public void addSelectionListener(DataSelectionListener listener) {
        this.immedatelyListeners.addIfAbsent(new DataListenerInfo(listener));
    }

    public void addSelectionListenerForEdt(DataSelectionListener listener) {
        this.inEDTListeners.addIfAbsent(new DataListenerInfo(listener));
    }

    public void removeSelectionListener(SelectionChangedListener listener) {
        this.remove(new OldListenerInfo(listener));
    }

    public void removeSelectionListener(DataSelectionListener listener) {
        this.remove(new DataListenerInfo(listener));
    }

    private void remove(ListenerInfo searchListener) {
        this.inEDTListeners.remove(searchListener);
        this.immedatelyListeners.remove(searchListener);
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        DataSet newDataSet;
        DataSet oldDataSet = e.getPreviousEditDataSet();
        if (oldDataSet != null) {
            DataSelectionListener.SelectionReplaceEvent event = new DataSelectionListener.SelectionReplaceEvent(oldDataSet, new HashSet<OsmPrimitive>(oldDataSet.getAllSelected()), Stream.empty());
            this.selectionChanged(event);
            oldDataSet.removeSelectionListener(this);
        }
        if ((newDataSet = e.getSource().getEditDataSet()) != null) {
            newDataSet.addSelectionListener(this);
            DataSelectionListener.SelectionReplaceEvent event = new DataSelectionListener.SelectionReplaceEvent(newDataSet, Collections.emptySet(), newDataSet.getAllSelected().stream());
            this.selectionChanged(event);
        }
    }

    @Override
    public void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
        SelectionEventManager.fireEvent(this.immedatelyListeners, event);
        SwingUtilities.invokeLater(() -> SelectionEventManager.fireEvent(this.inEDTListeners, event));
    }

    private static void fireEvent(List<ListenerInfo> listeners, DataSelectionListener.SelectionChangeEvent event) {
        for (ListenerInfo listener : listeners) {
            listener.fire(event);
        }
    }

    public void resetState() {
        this.inEDTListeners.clear();
        this.immedatelyListeners.clear();
        MainApplication.getLayerManager().addAndFireActiveLayerChangeListener(this);
    }

    private static class DataListenerInfo
    implements ListenerInfo {
        private final DataSelectionListener listener;

        DataListenerInfo(DataSelectionListener listener) {
            this.listener = listener;
        }

        @Override
        public void fire(DataSelectionListener.SelectionChangeEvent event) {
            this.listener.selectionChanged(event);
        }

        public int hashCode() {
            return Objects.hash(this.listener);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataListenerInfo that = (DataListenerInfo)o;
            return Objects.equals(this.listener, that.listener);
        }
    }

    private static class OldListenerInfo
    implements ListenerInfo {
        private final SelectionChangedListener listener;

        OldListenerInfo(SelectionChangedListener listener) {
            this.listener = listener;
        }

        @Override
        public void fire(DataSelectionListener.SelectionChangeEvent event) {
            this.listener.selectionChanged(event.getSelection());
        }

        public int hashCode() {
            return Objects.hash(this.listener);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OldListenerInfo that = (OldListenerInfo)o;
            return Objects.equals(this.listener, that.listener);
        }
    }

    private static interface ListenerInfo {
        public void fire(DataSelectionListener.SelectionChangeEvent var1);
    }
}

