/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.actions.AutoScaleAction;
import org.openstreetmap.josm.actions.downloadtasks.ChangesetContentDownloadTask;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetAware;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManager;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManagerModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetContentTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetContentTableModel;
import org.openstreetmap.josm.gui.dialogs.changeset.DownloadChangesetContentAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.io.DownloadPrimitivesWithReferrersTask;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReportExceptionHandler;

public class ChangesetContentPanel
extends JPanel
implements PropertyChangeListener,
ChangesetAware {
    private ChangesetContentTableModel model;
    private transient Changeset currentChangeset;
    private DownloadChangesetContentAction actDownloadContentAction;
    private ShowHistoryAction actShowHistory;
    private SelectInCurrentLayerAction actSelectInCurrentLayerAction;
    private ZoomInCurrentLayerAction actZoomInCurrentLayerAction;
    private final HeaderPanel pnlHeader = new HeaderPanel();
    public DownloadObjectAction actDownloadObjectAction;

    protected void buildModels() {
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        this.model = new ChangesetContentTableModel(selectionModel);
        this.actDownloadContentAction = new DownloadChangesetContentAction(this);
        this.actDownloadContentAction.initProperties();
        this.actDownloadObjectAction = new DownloadObjectAction();
        this.model.getSelectionModel().addListSelectionListener(this.actDownloadObjectAction);
        this.actShowHistory = new ShowHistoryAction();
        this.model.getSelectionModel().addListSelectionListener(this.actShowHistory);
        this.actSelectInCurrentLayerAction = new SelectInCurrentLayerAction();
        this.model.getSelectionModel().addListSelectionListener(this.actSelectInCurrentLayerAction);
        MainApplication.getLayerManager().addActiveLayerChangeListener(this.actSelectInCurrentLayerAction);
        this.actZoomInCurrentLayerAction = new ZoomInCurrentLayerAction();
        this.model.getSelectionModel().addListSelectionListener(this.actZoomInCurrentLayerAction);
        MainApplication.getLayerManager().addActiveLayerChangeListener(this.actZoomInCurrentLayerAction);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                MainApplication.getLayerManager().addAndFireActiveLayerChangeListener(ChangesetContentPanel.this.actSelectInCurrentLayerAction);
                MainApplication.getLayerManager().addAndFireActiveLayerChangeListener(ChangesetContentPanel.this.actZoomInCurrentLayerAction);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                MainApplication.getLayerManager().removeActiveLayerChangeListener(ChangesetContentPanel.this.actSelectInCurrentLayerAction);
                MainApplication.getLayerManager().removeActiveLayerChangeListener(ChangesetContentPanel.this.actZoomInCurrentLayerAction);
            }
        });
    }

    protected JPanel buildContentPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        JTable tblContent = new JTable(this.model, new ChangesetContentTableColumnModel(), this.model.getSelectionModel());
        tblContent.addMouseListener(new PopupMenuLauncher(new ChangesetContentTablePopupMenu()));
        pnl.add((Component)new JScrollPane(tblContent), "Center");
        return pnl;
    }

    protected JPanel buildActionButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout(0));
        JToolBar tb = new JToolBar(1);
        tb.setFloatable(false);
        tb.add(this.actDownloadContentAction);
        tb.addSeparator();
        tb.add(this.actDownloadObjectAction);
        tb.add(this.actShowHistory);
        tb.addSeparator();
        tb.add(this.actSelectInCurrentLayerAction);
        tb.add(this.actZoomInCurrentLayerAction);
        pnl.add(tb);
        return pnl;
    }

    protected final void build() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.buildModels();
        this.add((Component)this.pnlHeader, "North");
        this.add((Component)this.buildActionButtonPanel(), "West");
        this.add((Component)this.buildContentPanel(), "Center");
    }

    public ChangesetContentPanel() {
        this.build();
    }

    public ChangesetContentTableModel getModel() {
        return this.model;
    }

    protected void setCurrentChangeset(Changeset cs) {
        this.currentChangeset = cs;
        if (cs == null) {
            this.model.populate(null);
        } else {
            this.model.populate(cs.getContent());
        }
        this.actDownloadContentAction.initProperties();
        this.pnlHeader.setChangeset(cs);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals(ChangesetCacheManagerModel.CHANGESET_IN_DETAIL_VIEW_PROP)) {
            return;
        }
        Changeset cs = (Changeset)evt.getNewValue();
        this.setCurrentChangeset(cs);
    }

    private void alertNoPrimitivesTo(Collection<HistoryOsmPrimitive> primitives, String title, String helpTopic) {
        HelpAwareOptionPane.showOptionDialog(this, I18n.trn("<html>The selected object is not available in the current<br>edit layer ''{0}''.</html>", "<html>None of the selected objects is available in the current<br>edit layer ''{0}''.</html>", primitives.size(), Utils.escapeReservedCharactersHTML(MainApplication.getLayerManager().getEditLayer().getName())), title, 2, helpTopic);
    }

    @Override
    public Changeset getCurrentChangeset() {
        return this.currentChangeset;
    }

    private static class HeaderPanel
    extends JPanel {
        private transient Changeset current;

        HeaderPanel() {
            this.build();
        }

        protected final void build() {
            this.setLayout(new FlowLayout(0));
            this.add(new JMultilineLabel(I18n.tr("The content of this changeset is not downloaded yet.", new Object[0])));
            this.add(new JButton(new DownloadAction()));
        }

        public void setChangeset(Changeset cs) {
            this.setVisible(cs != null && cs.getContent() == null);
            this.current = cs;
        }

        private class DownloadAction
        extends AbstractAction {
            DownloadAction() {
                this.putValue("Name", I18n.tr("Download now", new Object[0]));
                this.putValue("ShortDescription", I18n.tr("Download the changeset content", new Object[0]));
                new ImageProvider("dialogs/changeset", "downloadchangesetcontent").getResource().attachImageIcon(this);
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (HeaderPanel.this.current == null) {
                    return;
                }
                ChangesetContentDownloadTask task = new ChangesetContentDownloadTask((Component)HeaderPanel.this, HeaderPanel.this.current.getId());
                ChangesetCacheManager.getInstance().runDownloadTask(task);
            }
        }
    }

    class ZoomInCurrentLayerAction
    extends SelectionBasedAction {
        ZoomInCurrentLayerAction() {
            this.putValue("Name", I18n.tr("Zoom to in layer", new Object[0]));
            new ImageProvider("dialogs/autoscale", "selection").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Zoom to the corresponding objects in the current data layer", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Set<OsmPrimitive> target = this.getTarget();
            if (target == null) {
                return;
            }
            if (target.isEmpty()) {
                ChangesetContentPanel.this.alertNoPrimitivesTo(ChangesetContentPanel.this.model.getSelectedPrimitives(), I18n.tr("Nothing to zoom to", new Object[0]), HelpUtil.ht("/Dialog/ChangesetCacheManager#NothingToZoomTo"));
                return;
            }
            MainApplication.getLayerManager().getEditLayer().data.setSelected(target);
            AutoScaleAction.zoomToSelection();
        }
    }

    class SelectInCurrentLayerAction
    extends SelectionBasedAction {
        SelectInCurrentLayerAction() {
            this.putValue("Name", I18n.tr("Select in layer", new Object[0]));
            new ImageProvider("dialogs", "select").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Select the corresponding primitives in the current data layer", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Set<OsmPrimitive> target = this.getTarget();
            if (target == null) {
                return;
            }
            if (target.isEmpty()) {
                ChangesetContentPanel.this.alertNoPrimitivesTo(ChangesetContentPanel.this.model.getSelectedPrimitives(), I18n.tr("Nothing to select", new Object[0]), HelpUtil.ht("/Dialog/ChangesetCacheManager#NothingToSelectInLayer"));
                return;
            }
            MainApplication.getLayerManager().getEditLayer().data.setSelected(target);
        }
    }

    abstract class SelectionBasedAction
    extends AbstractAction
    implements ListSelectionListener,
    MainLayerManager.ActiveLayerChangeListener {
        SelectionBasedAction() {
        }

        protected Set<OsmPrimitive> getTarget() {
            if (!this.isEnabled()) {
                return null;
            }
            OsmDataLayer layer = MainApplication.getLayerManager().getEditLayer();
            if (layer == null) {
                return null;
            }
            HashSet<OsmPrimitive> target = new HashSet<OsmPrimitive>();
            for (HistoryOsmPrimitive p : ChangesetContentPanel.this.model.getSelectedPrimitives()) {
                OsmPrimitive op = layer.data.getPrimitiveById(p.getPrimitiveId());
                if (op == null) continue;
                target.add(op);
            }
            return target;
        }

        public final void updateEnabledState() {
            this.setEnabled(MainApplication.getLayerManager().getEditLayer() != null && ChangesetContentPanel.this.model.hasSelectedPrimitives());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
            this.updateEnabledState();
        }
    }

    class DownloadObjectAction
    extends AbstractAction
    implements ListSelectionListener {
        DownloadObjectAction() {
            this.putValue("Name", I18n.tr("Download objects", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("downloadprimitive"));
            this.putValue("ShortDescription", I18n.tr("Download the current version of the selected objects", new Object[0]));
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            List<PrimitiveId> primitiveIds = ChangesetContentPanel.this.model.getSelectedPrimitives().stream().map(HistoryOsmPrimitive::getPrimitiveId).collect(Collectors.toList());
            MainApplication.worker.submit(new DownloadPrimitivesWithReferrersTask(false, primitiveIds, true, true, null, null));
        }

        protected final void updateEnabledState() {
            this.setEnabled(ChangesetContentPanel.this.model.hasSelectedPrimitives());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }
    }

    class ShowHistoryAction
    extends AbstractAction
    implements ListSelectionListener {
        ShowHistoryAction() {
            this.putValue("Name", I18n.tr("Show history", new Object[0]));
            new ImageProvider("dialogs", "history").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Download and show the history of the selected objects", new Object[0]));
            this.updateEnabledState();
        }

        protected List<HistoryOsmPrimitive> filterPrimitivesWithUnloadedHistory(Collection<HistoryOsmPrimitive> primitives) {
            ArrayList<HistoryOsmPrimitive> ret = new ArrayList<HistoryOsmPrimitive>(primitives.size());
            for (HistoryOsmPrimitive p : primitives) {
                if (HistoryDataSet.getInstance().getHistory(p.getPrimitiveId()) != null) continue;
                ret.add(p);
            }
            return ret;
        }

        public void showHistory(Collection<HistoryOsmPrimitive> primitives) {
            List<HistoryOsmPrimitive> toLoad = this.filterPrimitivesWithUnloadedHistory(primitives);
            if (!toLoad.isEmpty()) {
                HistoryLoadTask task = new HistoryLoadTask(ChangesetContentPanel.this);
                for (HistoryOsmPrimitive p : toLoad) {
                    task.add(p);
                }
                MainApplication.worker.submit(task);
            }
            MainApplication.worker.submit(new ShowHistoryTask(primitives));
        }

        protected final void updateEnabledState() {
            this.setEnabled(ChangesetContentPanel.this.model.hasSelectedPrimitives());
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Set<HistoryOsmPrimitive> selected = ChangesetContentPanel.this.model.getSelectedPrimitives();
            if (selected.isEmpty()) {
                return;
            }
            this.showHistory(selected);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        private final class ShowHistoryTask
        implements Runnable {
            private final Collection<HistoryOsmPrimitive> primitives;

            private ShowHistoryTask(Collection<HistoryOsmPrimitive> primitives) {
                this.primitives = primitives;
            }

            @Override
            public void run() {
                try {
                    for (HistoryOsmPrimitive p : this.primitives) {
                        History h = HistoryDataSet.getInstance().getHistory(p.getPrimitiveId());
                        if (h == null) continue;
                        GuiHelper.runInEDT(() -> HistoryBrowserDialogManager.getInstance().show(h));
                    }
                }
                catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException e) {
                    GuiHelper.runInEDT(() -> BugReportExceptionHandler.handleException(e));
                }
            }
        }
    }

    class ChangesetContentTablePopupMenu
    extends JPopupMenu {
        ChangesetContentTablePopupMenu() {
            this.add(ChangesetContentPanel.this.actDownloadContentAction);
            this.add(new JSeparator());
            this.add(ChangesetContentPanel.this.actDownloadObjectAction);
            this.add(ChangesetContentPanel.this.actShowHistory);
            this.add(new JSeparator());
            this.add(ChangesetContentPanel.this.actSelectInCurrentLayerAction);
            this.add(ChangesetContentPanel.this.actZoomInCurrentLayerAction);
        }
    }
}

