/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.FormatStyle;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class DateValidator
extends AbstractTextComponentValidator {
    public DateValidator(JTextComponent tc) {
        super(tc);
    }

    public static DateValidator decorate(JTextComponent tc) {
        return new DateValidator(tc);
    }

    @Override
    public boolean isValid() {
        return this.getDate() != null;
    }

    public String getStandardTooltipTextAsHtml() {
        return "<html>" + this.getStandardTooltipText() + "</html>";
    }

    public String getStandardTooltipText() {
        ZonedDateTime now = ZonedDateTime.now();
        return I18n.tr("Please enter a date in the usual format for your locale.<br>Example: {0}<br>Example: {1}<br>Example: {2}<br>Example: {3}<br>", DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).format(now), DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).format(now), DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG).format(now), DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL).format(now));
    }

    @Override
    public void validate() {
        if (!this.isValid()) {
            String msg = "<html>The current value isn't a valid date.<br>" + this.getStandardTooltipText() + "</html>";
            this.feedbackInvalid(msg);
            return;
        }
        String msg = "<html>" + this.getStandardTooltipText() + "</html>";
        this.feedbackValid(msg);
    }

    public LocalDate getDate() {
        for (FormatStyle format : FormatStyle.values()) {
            DateTimeFormatter df = DateTimeFormatter.ofLocalizedDate(format);
            try {
                return LocalDate.parse(this.getComponent().getText(), df);
            }
            catch (DateTimeParseException e) {
                Logging.trace(e);
            }
        }
        return null;
    }
}

