/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.layer;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.IEnabledStateUpdating;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.layer.LayerListTransferHandler;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public final class DuplicateAction
extends AbstractAction
implements IEnabledStateUpdating {
    private transient Layer layer;
    private final LayerListDialog.LayerListModel model;

    public DuplicateAction(Layer layer, LayerListDialog.LayerListModel model) {
        this(model);
        CheckParameterUtil.ensureParameterNotNull(layer, "layer");
        this.layer = layer;
        this.updateEnabledState();
    }

    public DuplicateAction(LayerListDialog.LayerListModel model) {
        this.model = model;
        this.putValue("Name", I18n.tr("Duplicate", new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get("dialogs", "duplicatelayer"));
        this.putValue("ShortDescription", I18n.tr("Duplicate this layer", new Object[0]));
        this.putValue("help", HelpUtil.ht("/Dialog/LayerList#DuplicateLayer"));
        this.updateEnabledState();
    }

    private static void duplicate(Layer layer) {
        if (layer instanceof OsmDataLayer) {
            String newName = LayerListTransferHandler.suggestNewLayerName(layer.getName(), MainApplication.getLayerManager().getLayers());
            OsmDataLayer oldLayer = (OsmDataLayer)layer;
            MainApplication.getLayerManager().addLayer(new OsmDataLayer(new DataSet(oldLayer.data), newName, null));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.layer != null) {
            DuplicateAction.duplicate(this.layer);
        } else {
            DuplicateAction.duplicate(this.model.getSelectedLayers().get(0));
        }
    }

    @Override
    public void updateEnabledState() {
        if (this.layer == null) {
            if (this.model != null && this.model.getSelectedLayers().size() == 1) {
                this.setEnabled(this.model.getSelectedLayers().get(0) instanceof OsmDataLayer);
            } else {
                this.setEnabled(false);
            }
        } else {
            this.setEnabled(this.layer instanceof OsmDataLayer);
        }
    }
}

