/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.shortcut;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.openstreetmap.josm.data.preferences.ColorProperty;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public class PrefJPanel
extends JPanel {
    private final AbstractTableModel model;
    private static final String SHIFT = KeyEvent.getModifiersExText(KeyStroke.getKeyStroke(65, 64).getModifiers());
    private static final String CTRL = KeyEvent.getModifiersExText(KeyStroke.getKeyStroke(65, 128).getModifiers());
    private static final String ALT = KeyEvent.getModifiersExText(KeyStroke.getKeyStroke(65, 512).getModifiers());
    private static final String META = KeyEvent.getModifiersExText(KeyStroke.getKeyStroke(65, 256).getModifiers());
    private static Map<Integer, String> keyList = PrefJPanel.setKeyList();
    private final JCheckBox cbAlt = new JCheckBox();
    private final JCheckBox cbCtrl = new JCheckBox();
    private final JCheckBox cbMeta = new JCheckBox();
    private final JCheckBox cbShift = new JCheckBox();
    private final JCheckBox cbDefault = new JCheckBox();
    private final JCheckBox cbDisable = new JCheckBox();
    private final JosmComboBox<String> tfKey = new JosmComboBox();
    private final JTable shortcutTable = new JTable();
    private final JosmTextField filterField = new JosmTextField();

    public PrefJPanel() {
        this.model = new ScListModel();
        this.initComponents();
    }

    private static Map<Integer, String> setKeyList() {
        LinkedHashMap<Integer, String> list = new LinkedHashMap<Integer, String>();
        String unknown = Toolkit.getProperty("AWT.unknown", "Unknown");
        for (Field field : KeyEvent.class.getFields()) {
            if (!field.getName().startsWith("VK_") || field.getName().startsWith("VK_KP_")) continue;
            try {
                int i = field.getInt(null);
                String s = KeyEvent.getKeyText(i);
                if (s == null || s.length() <= 0 || s.contains(unknown)) continue;
                list.put(i, s);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Logging.error(e);
            }
        }
        list.put(-1, "");
        return list;
    }

    public void filter(String substring) {
        this.filterField.setText(substring);
    }

    private void initComponents() {
        CbAction action = new CbAction(this);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.buildFilterPanel());
        this.shortcutTable.setModel(this.model);
        this.shortcutTable.getSelectionModel().addListSelectionListener(action);
        this.shortcutTable.setFillsViewportHeight(true);
        this.shortcutTable.setSelectionMode(0);
        this.shortcutTable.setAutoCreateRowSorter(true);
        TableColumnModel mod = this.shortcutTable.getColumnModel();
        mod.getColumn(0).setCellRenderer(new ShortcutTableCellRenderer(true));
        mod.getColumn(1).setCellRenderer(new ShortcutTableCellRenderer(false));
        JScrollPane listScrollPane = new JScrollPane();
        listScrollPane.setViewportView(this.shortcutTable);
        JPanel listPane = new JPanel(new GridLayout());
        listPane.add(listScrollPane);
        this.add(listPane);
        this.cbDefault.setAction(action);
        this.cbDefault.setText(I18n.tr("Use default", new Object[0]));
        this.cbShift.setAction(action);
        this.cbShift.setText(SHIFT);
        this.cbDisable.setAction(action);
        this.cbDisable.setText(I18n.tr("Disable", new Object[0]));
        this.cbCtrl.setAction(action);
        this.cbCtrl.setText(CTRL);
        this.cbAlt.setAction(action);
        this.cbAlt.setText(ALT);
        this.tfKey.setAction(action);
        this.tfKey.setModel(new DefaultComboBoxModel<String>(keyList.values().toArray(new String[keyList.size()])));
        this.cbMeta.setAction(action);
        this.cbMeta.setText(META);
        JPanel shortcutEditPane = new JPanel(new GridLayout(5, 2));
        shortcutEditPane.add(this.cbDefault);
        shortcutEditPane.add(new JLabel());
        shortcutEditPane.add(this.cbShift);
        shortcutEditPane.add(this.cbDisable);
        shortcutEditPane.add(this.cbCtrl);
        shortcutEditPane.add(new JLabel(I18n.tr("Key:", new Object[0]), 2));
        shortcutEditPane.add(this.cbAlt);
        shortcutEditPane.add(this.tfKey);
        shortcutEditPane.add(this.cbMeta);
        shortcutEditPane.add(new JLabel(I18n.tr("Attention: Use real keyboard keys only!", new Object[0])));
        action.actionPerformed(null);
        this.add(shortcutEditPane);
    }

    private JPanel buildFilterPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 0, 5);
        pnl.add((Component)new JLabel(I18n.tr("Search:", new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        pnl.add((Component)this.filterField, gc);
        this.filterField.setToolTipText(I18n.tr("Enter a search expression", new Object[0]));
        SelectAllOnFocusGainedDecorator.decorate(this.filterField);
        this.filterField.getDocument().addDocumentListener(new FilterFieldAdapter());
        pnl.setMaximumSize(new Dimension(300, 10));
        return pnl;
    }

    class FilterFieldAdapter
    implements DocumentListener {
        FilterFieldAdapter() {
        }

        private void filter() {
            String expr = PrefJPanel.this.filterField.getText().trim();
            if (expr.isEmpty()) {
                expr = null;
            }
            try {
                TableRowSorter sorter = (TableRowSorter)PrefJPanel.this.shortcutTable.getRowSorter();
                if (expr == null) {
                    sorter.setRowFilter(null);
                } else {
                    expr = expr.replace("+", "\\+");
                    ArrayList andFilters = new ArrayList();
                    for (String word : expr.split("\\s+")) {
                        andFilters.add(RowFilter.regexFilter("(?i)" + word, new int[0]));
                    }
                    sorter.setRowFilter(RowFilter.andFilter(andFilters));
                }
                PrefJPanel.this.model.fireTableDataChanged();
            }
            catch (ClassCastException | PatternSyntaxException ex) {
                Logging.warn(ex);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.filter();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.filter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.filter();
        }
    }

    private static class CbAction
    extends AbstractAction
    implements ListSelectionListener {
        private final PrefJPanel panel;

        CbAction(PrefJPanel panel) {
            this.panel = panel;
        }

        private void disableAllModifierCheckboxes() {
            this.panel.cbDefault.setEnabled(false);
            this.panel.cbDisable.setEnabled(false);
            this.panel.cbShift.setEnabled(false);
            this.panel.cbCtrl.setEnabled(false);
            this.panel.cbAlt.setEnabled(false);
            this.panel.cbMeta.setEnabled(false);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel lsm = this.panel.shortcutTable.getSelectionModel();
            if (!lsm.isSelectionEmpty()) {
                int row = this.panel.shortcutTable.convertRowIndexToModel(lsm.getMinSelectionIndex());
                Shortcut sc = (Shortcut)this.panel.model.getValueAt(row, -1);
                this.panel.cbDefault.setSelected(!sc.isAssignedUser());
                this.panel.cbDisable.setSelected(sc.getKeyStroke() == null);
                this.panel.cbShift.setSelected(sc.getAssignedModifier() != -1 && (sc.getAssignedModifier() & 0x40) != 0);
                this.panel.cbCtrl.setSelected(sc.getAssignedModifier() != -1 && (sc.getAssignedModifier() & 0x80) != 0);
                this.panel.cbAlt.setSelected(sc.getAssignedModifier() != -1 && (sc.getAssignedModifier() & 0x200) != 0);
                this.panel.cbMeta.setSelected(sc.getAssignedModifier() != -1 && (sc.getAssignedModifier() & 0x100) != 0);
                if (sc.getKeyStroke() != null) {
                    this.panel.tfKey.setSelectedItem(keyList.get(sc.getKeyStroke().getKeyCode()));
                } else {
                    this.panel.tfKey.setSelectedItem(keyList.get(-1));
                }
                if (!sc.isChangeable()) {
                    this.disableAllModifierCheckboxes();
                    this.panel.tfKey.setEnabled(false);
                } else {
                    this.panel.cbDefault.setEnabled(true);
                    this.actionPerformed(null);
                }
                this.panel.model.fireTableRowsUpdated(row, row);
            } else {
                this.disableAllModifierCheckboxes();
                this.panel.tfKey.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ListSelectionModel lsm = this.panel.shortcutTable.getSelectionModel();
            if (lsm != null && !lsm.isSelectionEmpty()) {
                if (e != null) {
                    int row = this.panel.shortcutTable.convertRowIndexToModel(lsm.getMinSelectionIndex());
                    Shortcut sc = (Shortcut)this.panel.model.getValueAt(row, -1);
                    if (this.panel.cbDisable.isSelected()) {
                        sc.setAssignedModifier(-1);
                    } else if (this.panel.tfKey.getSelectedItem() == null || "".equals(this.panel.tfKey.getSelectedItem())) {
                        sc.setAssignedModifier(3);
                    } else {
                        sc.setAssignedModifier((this.panel.cbShift.isSelected() ? 64 : 0) | (this.panel.cbCtrl.isSelected() ? 128 : 0) | (this.panel.cbAlt.isSelected() ? 512 : 0) | (this.panel.cbMeta.isSelected() ? 256 : 0));
                        for (Map.Entry entry : keyList.entrySet()) {
                            if (!((String)entry.getValue()).equals(this.panel.tfKey.getSelectedItem())) continue;
                            sc.setAssignedKey((Integer)entry.getKey());
                        }
                    }
                    sc.setAssignedUser(!this.panel.cbDefault.isSelected());
                    this.valueChanged(null);
                }
                boolean state = !this.panel.cbDefault.isSelected();
                this.panel.cbDisable.setEnabled(state);
                state = state && !this.panel.cbDisable.isSelected();
                this.panel.cbShift.setEnabled(state);
                this.panel.cbCtrl.setEnabled(state);
                this.panel.cbAlt.setEnabled(state);
                this.panel.cbMeta.setEnabled(state);
                this.panel.tfKey.setEnabled(state);
            } else {
                this.disableAllModifierCheckboxes();
                this.panel.tfKey.setEnabled(false);
            }
        }
    }

    private class ShortcutTableCellRenderer
    extends DefaultTableCellRenderer {
        private final transient ColorProperty SHORTCUT_BACKGROUND_USER_COLOR = new ColorProperty(I18n.marktr("Shortcut Background: User"), new Color(200, 255, 200));
        private final transient ColorProperty SHORTCUT_BACKGROUND_MODIFIED_COLOR = new ColorProperty(I18n.marktr("Shortcut Background: Modified"), new Color(255, 255, 200));
        private final boolean name;

        ShortcutTableCellRenderer(boolean name) {
            this.name = name;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int row1 = PrefJPanel.this.shortcutTable.convertRowIndexToModel(row);
            Shortcut sc = (Shortcut)PrefJPanel.this.model.getValueAt(row1, -1);
            if (sc == null) {
                return null;
            }
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, this.name ? sc.getLongText() : sc.getKeyText(), isSelected, hasFocus, row, column);
            GuiHelper.setBackgroundReadable(label, UIManager.getColor("Table.background"));
            if (sc.isAssignedUser()) {
                GuiHelper.setBackgroundReadable(label, this.SHORTCUT_BACKGROUND_USER_COLOR.get());
            } else if (!sc.isAssignedDefault()) {
                GuiHelper.setBackgroundReadable(label, this.SHORTCUT_BACKGROUND_MODIFIED_COLOR.get());
            }
            return label;
        }
    }

    private static class ScListModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{I18n.tr("Action", new Object[0]), I18n.tr("Shortcut", new Object[0])};
        private final transient List<Shortcut> data = Shortcut.listAll();

        ScListModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return col == 0 ? this.data.get(row).getLongText() : this.data.get(row);
        }
    }
}

