/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.template_engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.template_engine.CompoundTemplateEntry;
import org.openstreetmap.josm.tools.template_engine.Condition;
import org.openstreetmap.josm.tools.template_engine.ContextSwitchTemplate;
import org.openstreetmap.josm.tools.template_engine.ParseError;
import org.openstreetmap.josm.tools.template_engine.SearchExpressionCondition;
import org.openstreetmap.josm.tools.template_engine.StaticText;
import org.openstreetmap.josm.tools.template_engine.TemplateEntry;
import org.openstreetmap.josm.tools.template_engine.Tokenizer;
import org.openstreetmap.josm.tools.template_engine.Variable;

public class TemplateParser {
    private final Tokenizer tokenizer;
    private static final Collection<Tokenizer.TokenType> EXPRESSION_END_TOKENS = Arrays.asList(Tokenizer.TokenType.EOF);
    private static final Collection<Tokenizer.TokenType> CONDITION_WITH_APOSTROPHES_END_TOKENS = Arrays.asList(Tokenizer.TokenType.APOSTROPHE);

    public TemplateParser(String template) {
        this.tokenizer = new Tokenizer(template);
    }

    private Tokenizer.Token check(Tokenizer.TokenType expectedToken) throws ParseError {
        Tokenizer.Token token = this.tokenizer.nextToken();
        if (token.getType() != expectedToken) {
            throw new ParseError(token, expectedToken);
        }
        return token;
    }

    public TemplateEntry parse() throws ParseError {
        return this.parseExpression(EXPRESSION_END_TOKENS);
    }

    private TemplateEntry parseExpression(Collection<Tokenizer.TokenType> endTokens) throws ParseError {
        ArrayList<TemplateEntry> entries = new ArrayList<TemplateEntry>();
        while (true) {
            TemplateEntry templateEntry;
            Tokenizer.Token token;
            if ((token = this.tokenizer.lookAhead()).getType() == Tokenizer.TokenType.CONDITION_START) {
                templateEntry = this.parseCondition();
            } else if (token.getType() == Tokenizer.TokenType.CONTEXT_SWITCH_START) {
                templateEntry = this.parseContextSwitch();
            } else if (token.getType() == Tokenizer.TokenType.VARIABLE_START) {
                templateEntry = this.parseVariable();
            } else {
                if (endTokens.contains((Object)token.getType())) {
                    return CompoundTemplateEntry.fromArray(entries.toArray(new TemplateEntry[entries.size()]));
                }
                if (token.getType() == Tokenizer.TokenType.TEXT) {
                    this.tokenizer.nextToken();
                    templateEntry = new StaticText(token.getText());
                } else {
                    throw new ParseError(token);
                }
            }
            entries.add(templateEntry);
        }
    }

    private TemplateEntry parseVariable() throws ParseError {
        this.check(Tokenizer.TokenType.VARIABLE_START);
        String variableName = this.check(Tokenizer.TokenType.TEXT).getText();
        this.check(Tokenizer.TokenType.END);
        return new Variable(variableName);
    }

    private void skipWhitespace() throws ParseError {
        Tokenizer.Token token = this.tokenizer.lookAhead();
        if (token.getType() == Tokenizer.TokenType.TEXT && token.getText().trim().isEmpty()) {
            this.tokenizer.nextToken();
        }
    }

    private TemplateEntry parseCondition() throws ParseError {
        this.check(Tokenizer.TokenType.CONDITION_START);
        Condition result = new Condition();
        while (true) {
            Tokenizer.Token searchExpression = this.tokenizer.skip('\'');
            this.check(Tokenizer.TokenType.APOSTROPHE);
            TemplateEntry condition = this.parseExpression(CONDITION_WITH_APOSTROPHES_END_TOKENS);
            this.check(Tokenizer.TokenType.APOSTROPHE);
            String searchText = searchExpression.getText().trim();
            if (searchText.isEmpty()) {
                result.getEntries().add(condition);
            } else {
                try {
                    result.getEntries().add(new SearchExpressionCondition(SearchCompiler.compile(searchText), condition));
                }
                catch (SearchParseError e) {
                    throw new ParseError(searchExpression.getPosition(), e);
                }
            }
            this.skipWhitespace();
            Tokenizer.Token token = this.tokenizer.lookAhead();
            if (token.getType() == Tokenizer.TokenType.END) {
                this.tokenizer.nextToken();
                return result;
            }
            this.check(Tokenizer.TokenType.PIPE);
        }
    }

    private TemplateEntry parseContextSwitch() throws ParseError {
        ContextSwitchTemplate result;
        this.check(Tokenizer.TokenType.CONTEXT_SWITCH_START);
        Tokenizer.Token searchExpression = this.tokenizer.skip('\'');
        this.check(Tokenizer.TokenType.APOSTROPHE);
        TemplateEntry template = this.parseExpression(CONDITION_WITH_APOSTROPHES_END_TOKENS);
        this.check(Tokenizer.TokenType.APOSTROPHE);
        String searchText = searchExpression.getText().trim();
        if (searchText.isEmpty()) {
            throw new ParseError(I18n.tr("Expected search expression", new Object[0]));
        }
        try {
            SearchCompiler.Match match = SearchCompiler.compile(searchText);
            result = new ContextSwitchTemplate(match, template, searchExpression.getPosition());
        }
        catch (SearchParseError e) {
            throw new ParseError(searchExpression.getPosition(), e);
        }
        this.skipWhitespace();
        this.check(Tokenizer.TokenType.END);
        return result;
    }
}

