/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.painless.Compiler;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.GenericElasticsearchScript;
import org.elasticsearch.painless.ScriptImpl;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.LeafSearchScript;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.lookup.SearchLookup;

public final class PainlessScriptEngineService
extends AbstractComponent
implements ScriptEngineService {
    public static final String NAME = "painless";
    private static final AccessControlContext COMPILATION_CONTEXT;
    private final CompilerSettings defaultCompilerSettings = new CompilerSettings();
    static final String INLINE_NAME = "<inline>";

    public PainlessScriptEngineService(Settings settings) {
        super(settings);
        this.defaultCompilerSettings.setRegexesEnabled((Boolean)CompilerSettings.REGEX_ENABLED.get(settings));
    }

    public String getType() {
        return NAME;
    }

    public String getExtension() {
        return NAME;
    }

    public Object compile(String scriptName, String scriptSource, Map<String, String> params) {
        return this.compile(GenericElasticsearchScript.class, scriptName, scriptSource, params);
    }

    <T> T compile(final Class<T> iface, final String scriptName, final String scriptSource, Map<String, String> params) {
        CompilerSettings compilerSettings;
        if (params.isEmpty()) {
            compilerSettings = this.defaultCompilerSettings;
        } else {
            compilerSettings = new CompilerSettings();
            compilerSettings.setRegexesEnabled(this.defaultCompilerSettings.areRegexesEnabled());
            HashMap<String, String> copy = new HashMap<String, String>(params);
            String value = (String)copy.remove("max_loop_counter");
            if (value != null) {
                compilerSettings.setMaxLoopCounter(Integer.parseInt(value));
            }
            if ((value = (String)copy.remove("picky")) != null) {
                compilerSettings.setPicky(Boolean.parseBoolean(value));
            }
            if ((value = (String)copy.remove("initialCallSiteDepth")) != null) {
                compilerSettings.setInitialCallSiteDepth(Integer.parseInt(value));
            }
            if ((value = (String)copy.remove(CompilerSettings.REGEX_ENABLED.getKey())) != null) {
                throw new IllegalArgumentException("[painless.regex.enabled] can only be set on node startup.");
            }
            if (!copy.isEmpty()) {
                throw new IllegalArgumentException("Unrecognized compile-time parameter(s): " + copy);
            }
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        final Compiler.Loader loader = AccessController.doPrivileged(new PrivilegedAction<Compiler.Loader>(){

            @Override
            public Compiler.Loader run() {
                return new Compiler.Loader(this.getClass().getClassLoader());
            }
        });
        try {
            return AccessController.doPrivileged(new PrivilegedAction<T>(){

                @Override
                public T run() {
                    String name = scriptName == null ? PainlessScriptEngineService.INLINE_NAME : scriptName;
                    return Compiler.compile(loader, iface, name, scriptSource, compilerSettings);
                }
            }, COMPILATION_CONTEXT);
        }
        catch (Exception | OutOfMemoryError | StackOverflowError | VerifyError e) {
            throw this.convertToScriptException(scriptName == null ? scriptSource : scriptName, scriptSource, e);
        }
    }

    public ExecutableScript executable(CompiledScript compiledScript, Map<String, Object> vars) {
        return new ScriptImpl((GenericElasticsearchScript)compiledScript.compiled(), vars, null);
    }

    public SearchScript search(final CompiledScript compiledScript, final SearchLookup lookup, final Map<String, Object> vars) {
        return new SearchScript(){

            public LeafSearchScript getLeafSearchScript(LeafReaderContext context) throws IOException {
                return new ScriptImpl((GenericElasticsearchScript)compiledScript.compiled(), vars, lookup.getLeafSearchLookup(context));
            }

            public boolean needsScores() {
                return ((GenericElasticsearchScript)compiledScript.compiled()).uses$_score();
            }
        };
    }

    public void close() {
    }

    private ScriptException convertToScriptException(String scriptName, String scriptSource, Throwable t) {
        ArrayList<String> scriptStack = new ArrayList<String>();
        for (StackTraceElement element : t.getStackTrace()) {
            if (!WriterConstants.CLASS_NAME.equals(element.getClassName())) continue;
            int offset = element.getLineNumber();
            if (offset == -1) {
                scriptStack.add("<<< unknown portion of script >>>");
                break;
            }
            int startOffset = this.getPreviousStatement(scriptSource, --offset);
            int endOffset = this.getNextStatement(scriptSource, offset);
            StringBuilder snippet = new StringBuilder();
            if (startOffset > 0) {
                snippet.append("... ");
            }
            snippet.append(scriptSource.substring(startOffset, endOffset));
            if (endOffset < scriptSource.length()) {
                snippet.append(" ...");
            }
            scriptStack.add(snippet.toString());
            StringBuilder pointer = new StringBuilder();
            if (startOffset > 0) {
                pointer.append("    ");
            }
            for (int i = startOffset; i < offset; ++i) {
                pointer.append(' ');
            }
            pointer.append("^---- HERE");
            scriptStack.add(pointer.toString());
            break;
        }
        throw new ScriptException("compile error", t, scriptStack, scriptSource, NAME);
    }

    private int getPreviousStatement(String scriptSource, int offset) {
        return Math.max(0, offset - 25);
    }

    private int getNextStatement(String scriptSource, int offset) {
        return Math.min(scriptSource.length(), offset + 25);
    }

    public boolean isInlineScriptEnabled() {
        return true;
    }

    static {
        Permissions none = new Permissions();
        none.setReadOnly();
        COMPILATION_CONTEXT = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, none)});
    }
}

