/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import com.google.common.base.Objects;
import java.math.BigInteger;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.MissingModuleCacheEntry;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataCacheEntry;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DefaultSerializer;
import org.gradle.internal.serialize.Encoder;

class ModuleMetadataCacheEntrySerializer
extends AbstractSerializer<ModuleMetadataCacheEntry> {
    private final DefaultSerializer<ModuleSource> moduleSourceSerializer = new DefaultSerializer(ModuleSource.class.getClassLoader());

    ModuleMetadataCacheEntrySerializer() {
    }

    public void write(Encoder encoder, ModuleMetadataCacheEntry value) throws Exception {
        encoder.writeByte(value.type);
        switch (value.type) {
            case 0: {
                encoder.writeLong(value.createTimestamp);
                break;
            }
            case 1: {
                encoder.writeBoolean(value.isChanging);
                encoder.writeLong(value.createTimestamp);
                this.moduleSourceSerializer.write(encoder, (Object)value.moduleSource);
                byte[] hash = value.moduleDescriptorHash.toByteArray();
                encoder.writeBinary(hash);
                break;
            }
            default: {
                throw new IllegalArgumentException("Don't know how to serialize meta-data entry: " + value);
            }
        }
    }

    public ModuleMetadataCacheEntry read(Decoder decoder) throws Exception {
        byte type = decoder.readByte();
        switch (type) {
            case 0: {
                long createTimestamp = decoder.readLong();
                return new MissingModuleCacheEntry(createTimestamp);
            }
            case 1: {
                boolean isChanging = decoder.readBoolean();
                long createTimestamp = decoder.readLong();
                ModuleSource moduleSource = (ModuleSource)this.moduleSourceSerializer.read(decoder);
                byte[] encodedHash = decoder.readBinary();
                BigInteger hash = new BigInteger(encodedHash);
                return new ModuleMetadataCacheEntry(1, isChanging, createTimestamp, hash, moduleSource);
            }
        }
        throw new IllegalArgumentException("Don't know how to deserialize meta-data entry of type " + type);
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ModuleMetadataCacheEntrySerializer rhs = (ModuleMetadataCacheEntrySerializer)((Object)obj);
        return Objects.equal(this.moduleSourceSerializer, rhs.moduleSourceSerializer);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.moduleSourceSerializer});
    }
}

