/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.xcode.tasks;

import com.dd.plist.NSDictionary;
import com.google.common.base.Optional;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.Internal;
import org.gradle.ide.xcode.XcodeProject;
import org.gradle.ide.xcode.internal.DefaultXcodeProject;
import org.gradle.ide.xcode.internal.XcodeTarget;
import org.gradle.ide.xcode.internal.XcodeUtils;
import org.gradle.ide.xcode.internal.xcodeproj.GidGenerator;
import org.gradle.ide.xcode.internal.xcodeproj.PBXBuildFile;
import org.gradle.ide.xcode.internal.xcodeproj.PBXFileReference;
import org.gradle.ide.xcode.internal.xcodeproj.PBXLegacyTarget;
import org.gradle.ide.xcode.internal.xcodeproj.PBXNativeTarget;
import org.gradle.ide.xcode.internal.xcodeproj.PBXProject;
import org.gradle.ide.xcode.internal.xcodeproj.PBXReference;
import org.gradle.ide.xcode.internal.xcodeproj.PBXSourcesBuildPhase;
import org.gradle.ide.xcode.internal.xcodeproj.PBXTarget;
import org.gradle.ide.xcode.internal.xcodeproj.XCBuildConfiguration;
import org.gradle.ide.xcode.internal.xcodeproj.XcodeprojSerializer;
import org.gradle.ide.xcode.tasks.internal.XcodeProjectFile;
import org.gradle.plugins.ide.api.PropertyListGeneratorTask;

@Incubating
public class GenerateXcodeProjectFileTask
extends PropertyListGeneratorTask<XcodeProjectFile> {
    private static final String PRODUCTS_GROUP_NAME = "Products";
    private final GidGenerator gidGenerator;
    private DefaultXcodeProject xcodeProject;
    private Map<String, PBXFileReference> pathToFileReference = new HashMap<String, PBXFileReference>();

    @Inject
    public GenerateXcodeProjectFileTask(GidGenerator gidGenerator) {
        this.gidGenerator = gidGenerator;
    }

    @Override
    protected void configure(XcodeProjectFile projectFile) {
        PBXFileReference fileReference;
        PBXProject project = new PBXProject(this.getProject().getPath());
        XCBuildConfiguration buildConfiguration = (XCBuildConfiguration)project.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)"Debug");
        buildConfiguration.setBuildSettings(new NSDictionary());
        for (File source : this.xcodeProject.getSources()) {
            fileReference = this.toFileReference(source);
            this.pathToFileReference.put(source.getAbsolutePath(), fileReference);
            project.getMainGroup().getChildren().add(fileReference);
        }
        XcodeTarget target = this.xcodeProject.getTarget();
        if (target != null) {
            project.getTargets().add(this.toGradlePbxTarget(target));
            project.getTargets().add(this.toIndexPbxTarget(target));
            File outputFile = ((RegularFile)target.getOutputFile().get()).getAsFile();
            fileReference = new PBXFileReference(outputFile.getName(), outputFile.getAbsolutePath(), PBXReference.SourceTree.ABSOLUTE);
            fileReference.setExplicitFileType((Optional<String>)Optional.of((Object)target.getOutputFileType()));
            project.getMainGroup().getOrCreateChildGroupByName(PRODUCTS_GROUP_NAME).getChildren().add(fileReference);
        }
        XcodeprojSerializer serializer = new XcodeprojSerializer(this.gidGenerator, project);
        final NSDictionary rootObject = serializer.toPlist();
        projectFile.transformAction(new Action<NSDictionary>(){

            public void execute(NSDictionary dict) {
                dict.clear();
                dict.putAll((Map)rootObject);
            }
        });
    }

    @Override
    protected XcodeProjectFile create() {
        return new XcodeProjectFile(this.getPropertyListTransformer());
    }

    private PBXFileReference toFileReference(File file) {
        return new PBXFileReference(file.getName(), file.getAbsolutePath(), PBXReference.SourceTree.ABSOLUTE);
    }

    private PBXTarget toGradlePbxTarget(XcodeTarget xcodeTarget) {
        PBXLegacyTarget target = new PBXLegacyTarget(xcodeTarget.getName(), xcodeTarget.getProductType());
        target.setProductName(xcodeTarget.getProductName());
        NSDictionary buildSettings = new NSDictionary();
        ((XCBuildConfiguration)target.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)"Debug")).setBuildSettings(buildSettings);
        target.setBuildToolPath(xcodeTarget.getGradleCommand());
        target.setBuildArgumentsString(xcodeTarget.getTaskName());
        target.setGlobalID(xcodeTarget.getId());
        File outputFile = ((RegularFile)xcodeTarget.getOutputFile().get()).getAsFile();
        target.setProductReference(new PBXFileReference(outputFile.getName(), outputFile.getAbsolutePath(), PBXReference.SourceTree.ABSOLUTE));
        return target;
    }

    private PBXTarget toIndexPbxTarget(XcodeTarget xcodeTarget) {
        PBXSourcesBuildPhase buildPhase = new PBXSourcesBuildPhase();
        for (File file : xcodeTarget.getSources()) {
            PBXFileReference fileReference = this.pathToFileReference.get(file.getAbsolutePath());
            buildPhase.getFiles().add(new PBXBuildFile(fileReference));
        }
        PBXNativeTarget target = new PBXNativeTarget("[INDEXING ONLY] " + xcodeTarget.getName(), xcodeTarget.getProductType());
        target.setProductName(xcodeTarget.getProductName());
        NSDictionary buildSettings = new NSDictionary();
        buildSettings.put("SWIFT_VERSION", (Object)"3.0");
        buildSettings.put("PRODUCT_NAME", (Object)xcodeTarget.getProductName());
        if (!xcodeTarget.getHeaderSearchPaths().isEmpty()) {
            buildSettings.put("HEADER_SEARCH_PATHS", (Object)XcodeUtils.toSpaceSeparatedList((Iterable<File>)xcodeTarget.getHeaderSearchPaths()));
        }
        if (!xcodeTarget.getImportPaths().isEmpty()) {
            buildSettings.put("SWIFT_INCLUDE_PATHS", (Object)XcodeUtils.toSpaceSeparatedList((Iterable<File>)xcodeTarget.getImportPaths()));
        }
        ((XCBuildConfiguration)target.getBuildConfigurationList().getBuildConfigurationsByName().getUnchecked((Object)"Debug")).setBuildSettings(buildSettings);
        target.getBuildPhases().add(buildPhase);
        return target;
    }

    @Internal
    public XcodeProject getXcodeProject() {
        return this.xcodeProject;
    }

    public void setXcodeProject(XcodeProject xcodeProject) {
        this.xcodeProject = (DefaultXcodeProject)xcodeProject;
    }
}

