/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.initialization.IncludedBuild;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencySubstitutions;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionsInternal;
import org.gradle.api.tasks.TaskReference;
import org.gradle.composite.internal.IncludedBuildInternal;
import org.gradle.composite.internal.IncludedBuildTaskReference;
import org.gradle.initialization.GradleLauncher;
import org.gradle.internal.Factory;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;

public class DefaultIncludedBuild
implements IncludedBuildInternal {
    private final File projectDir;
    private final Factory<GradleLauncher> gradleLauncherFactory;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final WorkerLeaseRegistry.WorkerLease parentLease;
    private final List<Action<? super DependencySubstitutions>> dependencySubstitutionActions = Lists.newArrayList();
    private DefaultDependencySubstitutions dependencySubstitutions;
    private GradleLauncher gradleLauncher;
    private String name;

    public DefaultIncludedBuild(File projectDir, Factory<GradleLauncher> launcherFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory, WorkerLeaseRegistry.WorkerLease parentLease) {
        this.projectDir = projectDir;
        this.gradleLauncherFactory = launcherFactory;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.parentLease = parentLease;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public TaskReference task(String path) {
        Preconditions.checkArgument((boolean)path.startsWith(":"), (String)"Task path '%s' is not a qualified task path (e.g. ':task' or ':project:task').", (Object[])new Object[]{path});
        return new IncludedBuildTaskReference(this.getName(), path);
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getLoadedSettings().getRootProject().getName();
        }
        return this.name;
    }

    public void dependencySubstitution(Action<? super DependencySubstitutions> action) {
        if (this.dependencySubstitutions != null) {
            throw new IllegalStateException("Cannot configure included build after dependency substitutions are resolved.");
        }
        this.dependencySubstitutionActions.add(action);
    }

    @Override
    public DependencySubstitutionsInternal resolveDependencySubstitutions() {
        if (this.dependencySubstitutions == null) {
            this.dependencySubstitutions = DefaultDependencySubstitutions.forIncludedBuild((IncludedBuild)this, (ImmutableModuleIdentifierFactory)this.moduleIdentifierFactory);
            for (Action<? super DependencySubstitutions> action : this.dependencySubstitutionActions) {
                action.execute((Object)this.dependencySubstitutions);
            }
        }
        return this.dependencySubstitutions;
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        return this.getGradleLauncher().getLoadedSettings();
    }

    @Override
    public GradleInternal getConfiguredBuild() {
        return this.getGradleLauncher().getConfiguredBuild();
    }

    @Override
    public void finishBuild() {
        this.getGradleLauncher().finishBuild();
    }

    @Override
    public synchronized void addTasks(Iterable<String> taskPaths) {
        this.getGradleLauncher().scheduleTasks(taskPaths);
    }

    private GradleLauncher getGradleLauncher() {
        if (this.gradleLauncher == null) {
            this.gradleLauncher = (GradleLauncher)this.gradleLauncherFactory.create();
        }
        return this.gradleLauncher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void execute(Iterable<String> tasks, Object listener) {
        final GradleLauncher launcher = this.getGradleLauncher();
        launcher.addListener(listener);
        launcher.scheduleTasks(tasks);
        WorkerLeaseService workerLeaseService = (WorkerLeaseService)this.gradleLauncher.getGradle().getServices().get(WorkerLeaseService.class);
        try {
            workerLeaseService.withSharedLease(this.parentLease, new Runnable(){

                @Override
                public void run() {
                    launcher.executeTasks();
                }
            });
        }
        finally {
            this.markAsNotReusable();
        }
    }

    private void markAsNotReusable() {
        this.gradleLauncher = null;
    }

    public String toString() {
        return String.format("includedBuild[%s]", this.projectDir.getName());
    }
}

