/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.changes;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.internal.changedetection.changes.IncrementalTaskInputsInternal;
import org.gradle.api.tasks.incremental.InputFileDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class StatefulIncrementalTaskInputs
implements IncrementalTaskInputsInternal {
    private final Set<File> discoveredInputs = Sets.newHashSet();
    private boolean outOfDateProcessed;
    private boolean removedProcessed;

    protected StatefulIncrementalTaskInputs() {
    }

    public void outOfDate(Action<? super InputFileDetails> outOfDateAction) {
        if (this.outOfDateProcessed) {
            throw new IllegalStateException("Cannot process outOfDate files multiple times");
        }
        this.doOutOfDate(outOfDateAction);
        this.outOfDateProcessed = true;
    }

    protected abstract void doOutOfDate(Action<? super InputFileDetails> var1);

    public void removed(Action<? super InputFileDetails> removedAction) {
        if (!this.outOfDateProcessed) {
            throw new IllegalStateException("Must first process outOfDate files before processing removed files");
        }
        if (this.removedProcessed) {
            throw new IllegalStateException("Cannot process removed files multiple times");
        }
        this.doRemoved(removedAction);
        this.removedProcessed = true;
    }

    protected abstract void doRemoved(Action<? super InputFileDetails> var1);

    @Override
    public void newInput(File discoveredInput) {
        this.discoveredInputs.add(discoveredInput);
    }

    @Override
    public Set<File> getDiscoveredInputs() {
        return this.discoveredInputs;
    }
}

