/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import org.gradle.api.internal.OverlappingOutputs;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.ImplementationSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.internal.id.UniqueId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TaskExecution {
    private final UniqueId buildInvocationId;
    private final ImplementationSnapshot taskImplementation;
    private final ImmutableList<ImplementationSnapshot> taskActionImplementations;
    private final ImmutableSortedMap<String, ValueSnapshot> inputProperties;
    private final ImmutableSortedSet<String> outputPropertyNamesForCacheKey;
    private final ImmutableSet<String> declaredOutputFilePaths;
    private final OverlappingOutputs detectedOverlappingOutputs;
    private Boolean successful;

    public TaskExecution(UniqueId buildInvocationId, ImplementationSnapshot taskImplementation, ImmutableList<ImplementationSnapshot> taskActionImplementations, ImmutableSortedMap<String, ValueSnapshot> inputProperties, ImmutableSortedSet<String> outputPropertyNames, ImmutableSet<String> declaredOutputFilePaths, Boolean successful, OverlappingOutputs detectedOverlappingOutputs) {
        this.buildInvocationId = buildInvocationId;
        this.taskImplementation = taskImplementation;
        this.taskActionImplementations = taskActionImplementations;
        this.inputProperties = inputProperties;
        this.outputPropertyNamesForCacheKey = outputPropertyNames;
        this.declaredOutputFilePaths = declaredOutputFilePaths;
        this.successful = successful;
        this.detectedOverlappingOutputs = detectedOverlappingOutputs;
    }

    public Boolean isSuccessful() {
        return this.successful;
    }

    public void setSuccessful(Boolean successful) {
        this.successful = successful;
    }

    public UniqueId getBuildInvocationId() {
        return this.buildInvocationId;
    }

    public ImmutableSortedSet<String> getOutputPropertyNamesForCacheKey() {
        return ImmutableSortedSet.copyOf(this.outputPropertyNamesForCacheKey);
    }

    public ImmutableSet<String> getDeclaredOutputFilePaths() {
        return this.declaredOutputFilePaths;
    }

    public ImplementationSnapshot getTaskImplementation() {
        return this.taskImplementation;
    }

    public ImmutableList<ImplementationSnapshot> getTaskActionImplementations() {
        return this.taskActionImplementations;
    }

    public ImmutableSortedMap<String, ValueSnapshot> getInputProperties() {
        return this.inputProperties;
    }

    public abstract ImmutableSortedMap<String, FileCollectionSnapshot> getOutputFilesSnapshot();

    public abstract void setOutputFilesSnapshot(ImmutableSortedMap<String, FileCollectionSnapshot> var1);

    public abstract ImmutableSortedMap<String, FileCollectionSnapshot> getInputFilesSnapshot();

    public abstract FileCollectionSnapshot getDiscoveredInputFilesSnapshot();

    public abstract void setDiscoveredInputFilesSnapshot(FileCollectionSnapshot var1);

    public OverlappingOutputs getDetectedOverlappingOutputs() {
        return this.detectedOverlappingOutputs;
    }
}

