/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import java.io.IOException;
import java.util.Map;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.ImplementationSnapshot;
import org.gradle.api.internal.changedetection.state.InputPropertiesSerializer;
import org.gradle.api.internal.changedetection.state.TaskExecutionSnapshot;
import org.gradle.api.internal.changedetection.state.ValueSnapshot;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.id.UniqueId;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskExecutionSnapshotSerializer
extends AbstractSerializer<TaskExecutionSnapshot> {
    private final InputPropertiesSerializer inputPropertiesSerializer = new InputPropertiesSerializer();
    private final StringInterner stringInterner;

    TaskExecutionSnapshotSerializer(StringInterner stringInterner) {
        this.stringInterner = stringInterner;
    }

    public TaskExecutionSnapshot read(Decoder decoder) throws Exception {
        boolean successful = decoder.readBoolean();
        UniqueId buildId = UniqueId.from((String)decoder.readString());
        ImmutableSortedMap<String, Long> inputFilesSnapshotIds = TaskExecutionSnapshotSerializer.readSnapshotIds(decoder);
        ImmutableSortedMap<String, Long> outputFilesSnapshotIds = TaskExecutionSnapshotSerializer.readSnapshotIds(decoder);
        Long discoveredFilesSnapshotId = decoder.readLong();
        ImplementationSnapshot taskImplementation = TaskExecutionSnapshotSerializer.readImplementation(decoder);
        int taskActionsCount = decoder.readSmallInt();
        ImmutableList.Builder taskActionImplementationsBuilder = ImmutableList.builder();
        for (int j = 0; j < taskActionsCount; ++j) {
            ImplementationSnapshot actionImpl = TaskExecutionSnapshotSerializer.readImplementation(decoder);
            taskActionImplementationsBuilder.add((Object)actionImpl);
        }
        ImmutableList taskActionImplementations = taskActionImplementationsBuilder.build();
        int cacheableOutputPropertiesCount = decoder.readSmallInt();
        ImmutableSortedSet.Builder cacheableOutputPropertiesBuilder = ImmutableSortedSet.naturalOrder();
        for (int j = 0; j < cacheableOutputPropertiesCount; ++j) {
            cacheableOutputPropertiesBuilder.add((Object)decoder.readString());
        }
        ImmutableSortedSet cacheableOutputProperties = cacheableOutputPropertiesBuilder.build();
        int outputFilesCount = decoder.readSmallInt();
        ImmutableSet.Builder declaredOutputFilePathsBuilder = ImmutableSet.builder();
        for (int j = 0; j < outputFilesCount; ++j) {
            declaredOutputFilePathsBuilder.add((Object)this.stringInterner.intern(decoder.readString()));
        }
        ImmutableSet declaredOutputFilePaths = declaredOutputFilePathsBuilder.build();
        ImmutableSortedMap<String, ValueSnapshot> inputProperties = this.inputPropertiesSerializer.read(decoder);
        return new TaskExecutionSnapshot(successful, buildId, taskImplementation, (ImmutableList<ImplementationSnapshot>)taskActionImplementations, (ImmutableSortedSet<String>)cacheableOutputProperties, (ImmutableSet<String>)declaredOutputFilePaths, inputProperties, inputFilesSnapshotIds, discoveredFilesSnapshotId, outputFilesSnapshotIds);
    }

    public void write(Encoder encoder, TaskExecutionSnapshot execution) throws Exception {
        encoder.writeBoolean(execution.isSuccessful());
        encoder.writeString((CharSequence)execution.getBuildInvocationId().asString());
        TaskExecutionSnapshotSerializer.writeSnapshotIds(encoder, execution.getInputFilesSnapshotIds());
        TaskExecutionSnapshotSerializer.writeSnapshotIds(encoder, execution.getOutputFilesSnapshotIds());
        encoder.writeLong(execution.getDiscoveredFilesSnapshotId().longValue());
        TaskExecutionSnapshotSerializer.writeImplementation(encoder, execution.getTaskImplementation());
        encoder.writeSmallInt(execution.getTaskActionsImplementations().size());
        for (ImplementationSnapshot actionImpl : execution.getTaskActionsImplementations()) {
            TaskExecutionSnapshotSerializer.writeImplementation(encoder, actionImpl);
        }
        encoder.writeSmallInt(execution.getCacheableOutputProperties().size());
        for (String outputFile : execution.getCacheableOutputProperties()) {
            encoder.writeString((CharSequence)outputFile);
        }
        encoder.writeSmallInt(execution.getDeclaredOutputFilePaths().size());
        for (String outputFile : execution.getDeclaredOutputFilePaths()) {
            encoder.writeString((CharSequence)outputFile);
        }
        this.inputPropertiesSerializer.write(encoder, (ImmutableMap<String, ValueSnapshot>)execution.getInputProperties());
    }

    private static ImplementationSnapshot readImplementation(Decoder decoder) throws IOException {
        String typeName = decoder.readString();
        HashCode classLoaderHash = decoder.readBoolean() ? HashCode.fromBytes((byte[])decoder.readBinary()) : null;
        return new ImplementationSnapshot(typeName, classLoaderHash);
    }

    private static void writeImplementation(Encoder encoder, ImplementationSnapshot implementation) throws IOException {
        encoder.writeString((CharSequence)implementation.getTypeName());
        if (implementation.hasUnknownClassLoader()) {
            encoder.writeBoolean(false);
        } else {
            encoder.writeBoolean(true);
            encoder.writeBinary(implementation.getClassLoaderHash().toByteArray());
        }
    }

    private static ImmutableSortedMap<String, Long> readSnapshotIds(Decoder decoder) throws IOException {
        int count = decoder.readSmallInt();
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.naturalOrder();
        for (int snapshotIdx = 0; snapshotIdx < count; ++snapshotIdx) {
            String property = decoder.readString();
            long id = decoder.readLong();
            builder.put((Object)property, (Object)id);
        }
        return builder.build();
    }

    private static void writeSnapshotIds(Encoder encoder, Map<String, Long> ids) throws IOException {
        encoder.writeSmallInt(ids.size());
        for (Map.Entry<String, Long> entry : ids.entrySet()) {
            encoder.writeString((CharSequence)entry.getKey());
            encoder.writeLong(entry.getValue().longValue());
        }
    }
}

