/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.io.File;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.AbstractOutputPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.TaskPropertyActionContext;
import org.gradle.api.internal.tasks.TaskOutputsUtil;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskOutputFilePropertyBuilder;
import org.gradle.util.DeferredUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputDirectoryPropertyAnnotationHandler
extends AbstractOutputPropertyAnnotationHandler {
    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return OutputDirectory.class;
    }

    @Override
    protected void validate(String propertyName, Object value, Collection<String> messages) {
        if (value != null) {
            TaskOutputsUtil.validateDirectory(propertyName, this.toFile(value), messages);
        }
    }

    @Override
    protected TaskOutputFilePropertyBuilder createPropertyBuilder(TaskPropertyActionContext context, TaskInternal task, Callable<Object> futureValue) {
        return task.getOutputs().dir(futureValue);
    }

    @Override
    protected void beforeTask(Callable<Object> futureValue) {
        File directory = this.toFile(futureValue);
        if (directory != null) {
            TaskOutputsUtil.ensureDirectoryExists(directory);
        }
    }

    private File toFile(Object value) {
        Object unpacked = DeferredUtil.unpack(value);
        if (unpacked instanceof Path) {
            return ((Path)unpacked).toFile();
        }
        if (unpacked instanceof FileSystemLocation) {
            return ((FileSystemLocation)unpacked).getAsFile();
        }
        return (File)unpacked;
    }
}

