/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.taskfactory.TaskClassValidationMessage;
import org.gradle.api.internal.project.taskfactory.TaskPropertyInfo;
import org.gradle.api.internal.project.taskfactory.TaskPropertyValue;
import org.gradle.api.internal.tasks.execution.TaskValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskClassValidator
implements TaskValidator,
Action<Task>,
Describable {
    private final ImmutableSortedSet<TaskPropertyInfo> annotatedProperties;
    private final ImmutableList<TaskClassValidationMessage> validationMessages;
    private final boolean cacheable;

    public TaskClassValidator(Set<TaskPropertyInfo> annotatedProperties, List<TaskClassValidationMessage> validationMessages, boolean cacheable) {
        this.annotatedProperties = ImmutableSortedSet.copyOf(annotatedProperties);
        this.validationMessages = ImmutableList.copyOf(validationMessages);
        this.cacheable = cacheable;
    }

    public void execute(Task task) {
    }

    public void addInputsAndOutputs(TaskInternal task) {
        task.addValidator(this);
        for (TaskPropertyInfo property : this.annotatedProperties) {
            property.getConfigureAction().update(task, new FutureValue(property, task));
        }
    }

    public String getDisplayName() {
        return "Validate task inputs";
    }

    @Override
    public void validate(TaskInternal task, Collection<String> messages) {
        ArrayList<TaskPropertyValue> propertyValues = new ArrayList<TaskPropertyValue>();
        for (TaskPropertyInfo property : this.annotatedProperties) {
            propertyValues.add(property.getValue(task));
        }
        for (TaskPropertyValue propertyValue : propertyValues) {
            propertyValue.checkNotNull(messages);
        }
        for (TaskPropertyValue propertyValue : propertyValues) {
            propertyValue.checkValid(messages);
        }
    }

    public boolean hasAnythingToValidate() {
        return !this.annotatedProperties.isEmpty();
    }

    public ImmutableSortedSet<TaskPropertyInfo> getAnnotatedProperties() {
        return this.annotatedProperties;
    }

    public ImmutableList<TaskClassValidationMessage> getValidationMessages() {
        return this.validationMessages;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FutureValue
    implements Callable<Object> {
        private final TaskPropertyInfo property;
        private final TaskInternal task;

        private FutureValue(TaskPropertyInfo property, TaskInternal task) {
            this.property = property;
            this.task = task;
        }

        @Override
        public Object call() throws Exception {
            return this.property.getValue(this.task).getValue();
        }

        public String toString() {
            return String.format("property (%s) for task '%s'", this.property, this.task.getName());
        }
    }
}

