/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.gradle.authentication.Authentication;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resource.transport.http.HttpProxySettings;
import org.gradle.internal.resource.transport.http.HttpSettings;
import org.gradle.internal.resource.transport.http.JavaSystemPropertiesHttpProxySettings;
import org.gradle.internal.resource.transport.http.JavaSystemPropertiesSecureHttpProxySettings;
import org.gradle.internal.resource.transport.http.SslContextFactory;

public class DefaultHttpSettings
implements HttpSettings {
    private final Collection<Authentication> authenticationSettings;
    private final SslContextFactory sslContextFactory;
    private final HostnameVerifier hostnameVerifier;
    private HttpProxySettings proxySettings;
    private HttpProxySettings secureProxySettings;
    private static final HostnameVerifier ALL_TRUSTING_HOSTNAME_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };
    private static final SslContextFactory ALL_TRUSTING_SSL_CONTEXT_FACTORY = new SslContextFactory(){
        private final Supplier<SSLContext> sslContextSupplier = Suppliers.memoize((Supplier)new Supplier<SSLContext>(){

            public SSLContext get() {
                try {
                    SSLContext sslcontext = SSLContext.getInstance("TLS");
                    sslcontext.init(null, allTrustingTrustManager, null);
                    return sslcontext;
                }
                catch (GeneralSecurityException e) {
                    throw new UncheckedException((Throwable)e);
                }
            }
        });
        private final TrustManager[] allTrustingTrustManager = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};

        @Override
        public SSLContext createSslContext() {
            return (SSLContext)this.sslContextSupplier.get();
        }
    };

    public static DefaultHttpSettings allowUntrustedSslConnections(Collection<Authentication> authenticationSettings) {
        return new DefaultHttpSettings(authenticationSettings, ALL_TRUSTING_SSL_CONTEXT_FACTORY, ALL_TRUSTING_HOSTNAME_VERIFIER);
    }

    public DefaultHttpSettings(Collection<Authentication> authenticationSettings, SslContextFactory sslContextFactory) {
        this(authenticationSettings, sslContextFactory, (HostnameVerifier)new DefaultHostnameVerifier(null));
    }

    private DefaultHttpSettings(Collection<Authentication> authenticationSettings, SslContextFactory sslContextFactory, HostnameVerifier hostnameVerifier) {
        if (authenticationSettings == null) {
            throw new IllegalArgumentException("Authentication settings cannot be null.");
        }
        this.authenticationSettings = authenticationSettings;
        this.sslContextFactory = sslContextFactory;
        this.hostnameVerifier = hostnameVerifier;
    }

    @Override
    public HttpProxySettings getProxySettings() {
        if (this.proxySettings == null) {
            this.proxySettings = new JavaSystemPropertiesHttpProxySettings();
        }
        return this.proxySettings;
    }

    @Override
    public HttpProxySettings getSecureProxySettings() {
        if (this.secureProxySettings == null) {
            this.secureProxySettings = new JavaSystemPropertiesSecureHttpProxySettings();
        }
        return this.secureProxySettings;
    }

    @Override
    public Collection<Authentication> getAuthenticationSettings() {
        return this.authenticationSettings;
    }

    @Override
    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }
}

