/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageUtil;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.editor.ex.DocumentEx;
import org.jetbrains.kotlin.com.intellij.openapi.fileEditor.FileDocumentManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Segment;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiDocumentManagerBase;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.ClsElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SelfElementInfo;
import org.jetbrains.kotlin.com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;

class FileElementInfo
extends SmartPointerElementInfo {
    private final VirtualFile myVirtualFile;
    private final Project myProject;
    private final Language myLanguage;
    private final Class<? extends PsiFile> myFileClass;

    public FileElementInfo(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/FileElementInfo", "<init>"));
        }
        this.myVirtualFile = file.getVirtualFile();
        this.myProject = file.getProject();
        this.myLanguage = LanguageUtil.getRootLanguage(file);
        this.myFileClass = file.getClass();
    }

    @Override
    public PsiElement restoreElement() {
        PsiFile file = SelfElementInfo.restoreFileFromVirtual(this.myVirtualFile, this.myProject, this.myLanguage);
        return this.myFileClass.isInstance(file) ? file : null;
    }

    @Override
    public PsiFile restoreFile() {
        PsiElement element = this.restoreElement();
        return element == null ? null : element.getContainingFile();
    }

    @Override
    public int elementHashCode() {
        return this.myVirtualFile.hashCode();
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/FileElementInfo", "pointsToTheSameElementAs"));
        }
        if (other instanceof FileElementInfo) {
            return Comparing.equal(this.myVirtualFile, ((FileElementInfo)other).myVirtualFile);
        }
        if (other instanceof SelfElementInfo || other instanceof ClsElementInfo) {
            return false;
        }
        return Comparing.equal(this.restoreElement(), other.restoreElement());
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @Override
    public Segment getRange() {
        return new TextRange(0, (int)this.myVirtualFile.getLength());
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/smartPointers/FileElementInfo", "getProject"));
        }
        return project;
    }

    @Override
    @Nullable
    public Segment getPsiRange() {
        Document currentDoc = FileDocumentManager.getInstance().getCachedDocument(this.myVirtualFile);
        DocumentEx committedDoc = currentDoc == null ? null : ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject)).getLastCommittedDocument(currentDoc);
        return committedDoc == null ? this.getRange() : new TextRange(0, committedDoc.getTextLength());
    }

    public String toString() {
        return "file{" + this.myVirtualFile + ", " + this.myLanguage + "}";
    }
}

