/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.load.java.BuiltinMethodsWithSpecialGenericSignature;
import org.jetbrains.kotlin.load.java.SpecialBuiltinMembers;
import org.jetbrains.kotlin.load.kotlin.JvmType;
import org.jetbrains.kotlin.load.kotlin.JvmTypeFactoryImpl;
import org.jetbrains.kotlin.load.kotlin.SignatureBuildingComponents;
import org.jetbrains.kotlin.load.kotlin.TypeMappingConfigurationImpl;
import org.jetbrains.kotlin.load.kotlin.TypeMappingMode;
import org.jetbrains.kotlin.load.kotlin.TypeSignatureMappingKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0018\u0010\u000b\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0014\u0010\u0011\u001a\u00020\u0001*\u00020\n2\b\b\u0002\u0010\u0012\u001a\u00020\b\u001a\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0001*\u00020\u0014H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0010H\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u0017"}, d2={"internalName", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getInternalName", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;)Ljava/lang/String;", "Lorg/jetbrains/kotlin/name/ClassId;", "(Lorg/jetbrains/kotlin/name/ClassId;)Ljava/lang/String;", "forceSingleValueParameterBoxing", "", "f", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "appendErasedType", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "computeJvmDescriptor", "withReturnType", "computeJvmSignature", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "mapToJvmType", "Lorg/jetbrains/kotlin/load/kotlin/JvmType;", "kotlin-compiler"})
public final class MethodSignatureMappingKt {
    @NotNull
    public static final String computeJvmDescriptor(@NotNull FunctionDescriptor $receiver, boolean withReturnType) {
        String string;
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        StringBuilder $receiver2 = stringBuilder = new StringBuilder();
        if ($receiver instanceof ConstructorDescriptor) {
            string = "<init>";
        } else {
            String string2 = $receiver.getName().asString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull(string2, "name.asString()");
        }
        $receiver2.append(string);
        $receiver2.append("(");
        Iterable $receiver$iv = $receiver.getValueParameters();
        for (Object element$iv : $receiver$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            KotlinType kotlinType = it.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "it.type");
            MethodSignatureMappingKt.appendErasedType($receiver2, kotlinType);
        }
        $receiver2.append(")");
        if (withReturnType) {
            if (TypeSignatureMappingKt.hasVoidReturnType($receiver)) {
                $receiver2.append("V");
            } else {
                KotlinType kotlinType = $receiver.getReturnType();
                if (kotlinType == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "returnType!!");
                MethodSignatureMappingKt.appendErasedType($receiver2, kotlinType);
            }
        }
        return stringBuilder.toString();
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String computeJvmDescriptor$default(FunctionDescriptor functionDescriptor, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return MethodSignatureMappingKt.computeJvmDescriptor(functionDescriptor, bl);
    }

    public static final boolean forceSingleValueParameterBoxing(@NotNull FunctionDescriptor f) {
        Intrinsics.checkParameterIsNotNull(f, "f");
        if (f.getValueParameters().size() != 1 || SpecialBuiltinMembers.isFromJavaOrBuiltins(f) || Intrinsics.areEqual(f.getName().asString(), "remove") ^ true) {
            return false;
        }
        JvmType jvmType = MethodSignatureMappingKt.mapToJvmType(CollectionsKt.single(f.getOriginal().getValueParameters()).getType());
        if (!(jvmType instanceof JvmType.Primitive)) {
            jvmType = null;
        }
        JvmType.Primitive primitive = (JvmType.Primitive)jvmType;
        if (Intrinsics.areEqual((Object)(primitive != null ? primitive.getJvmPrimitiveType() : null), (Object)JvmPrimitiveType.INT) ^ true) {
            return false;
        }
        FunctionDescriptor functionDescriptor = BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava(f);
        if (functionDescriptor == null) {
            return false;
        }
        FunctionDescriptor overridden = functionDescriptor;
        JvmType overriddenParameterType = MethodSignatureMappingKt.mapToJvmType(CollectionsKt.single(overridden.getOriginal().getValueParameters()).getType());
        return Intrinsics.areEqual(DescriptorUtilsKt.getFqNameUnsafe(overridden.getContainingDeclaration()), KotlinBuiltIns.FQ_NAMES.mutableCollection.toUnsafe()) && overriddenParameterType instanceof JvmType.Object && Intrinsics.areEqual(((JvmType.Object)overriddenParameterType).getInternalName(), "java/lang/Object");
    }

    @Nullable
    public static final String computeJvmSignature(@NotNull CallableDescriptor $receiver) {
        SignatureBuildingComponents signatureBuildingComponents;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        SignatureBuildingComponents $receiver2 = signatureBuildingComponents = SignatureBuildingComponents.INSTANCE;
        if (DescriptorUtils.isLocal($receiver)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (classDescriptor2.getName().isSpecial()) {
            return null;
        }
        CallableDescriptor callableDescriptor = $receiver.getOriginal();
        if (!(callableDescriptor instanceof SimpleFunctionDescriptor)) {
            callableDescriptor = null;
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)callableDescriptor;
        if (simpleFunctionDescriptor == null) {
            return null;
        }
        String string = MethodSignatureMappingKt.computeJvmDescriptor$default(simpleFunctionDescriptor, false, 1, null);
        Intrinsics.checkExpressionValueIsNotNull(string, "(original as? SimpleFunc\u2026l).computeJvmDescriptor()");
        return $receiver2.signature(classDescriptor2, string);
    }

    @NotNull
    public static final String getInternalName(@NotNull ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        FqNameUnsafe fqNameUnsafe = DescriptorUtilsKt.getFqNameSafe($receiver).toUnsafe();
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "fqNameSafe.toUnsafe()");
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
        if (classId != null) {
            ClassId classId2;
            ClassId it = classId2 = classId;
            String string = JvmClassName.byClassId(it).getInternalName();
            Intrinsics.checkExpressionValueIsNotNull(string, "JvmClassName.byClassId(it).internalName");
            return string;
        }
        return TypeSignatureMappingKt.computeInternalName$default($receiver, null, 2, null);
    }

    @NotNull
    public static final String getInternalName(@NotNull ClassId $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        FqNameUnsafe fqNameUnsafe = $receiver.asSingleFqName().toUnsafe();
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "asSingleFqName().toUnsafe()");
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
        if (classId == null) {
            classId = $receiver;
        }
        String string = JvmClassName.byClassId(classId).getInternalName();
        Intrinsics.checkExpressionValueIsNotNull(string, "JvmClassName.byClassId(J\u2026()) ?: this).internalName");
        return string;
    }

    private static final void appendErasedType(@NotNull StringBuilder $receiver, KotlinType type2) {
        $receiver.append(MethodSignatureMappingKt.mapToJvmType(type2));
    }

    @NotNull
    public static final JvmType mapToJvmType(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return (JvmType)TypeSignatureMappingKt.mapType$default($receiver, JvmTypeFactoryImpl.INSTANCE, TypeMappingMode.DEFAULT, TypeMappingConfigurationImpl.INSTANCE, null, null, 32, null);
    }
}

