/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.config;

import groovy.lang.Closure;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.grails.datastore.mapping.config.Entity;
import org.grails.datastore.mapping.config.MappingDefinition;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.config.groovy.DefaultMappingConfigurationBuilder;
import org.grails.datastore.mapping.config.groovy.MappingConfigurationBuilder;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.IdentityMapping;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.MappingFactory;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.springframework.beans.BeanUtils;

public abstract class AbstractGormMappingFactory<R extends Entity, T extends Property>
extends MappingFactory<R, T> {
    protected Map<PersistentEntity, Map<String, T>> entityToPropertyMap = new HashMap<PersistentEntity, Map<String, T>>();
    protected Map<PersistentEntity, R> entityToMapping = new HashMap<PersistentEntity, R>();
    private Closure defaultMapping;
    private Object contextObject;
    protected Closure defaultConstraints;
    protected boolean versionByDefault = true;

    public void setContextObject(Object contextObject) {
        this.contextObject = contextObject;
    }

    public void setDefaultConstraints(Closure defaultConstraints) {
        this.defaultConstraints = defaultConstraints;
    }

    public void setVersionByDefault(boolean versionByDefault) {
        this.versionByDefault = versionByDefault;
    }

    @Override
    public R createMappedForm(PersistentEntity entity) {
        if (this.entityToMapping.containsKey(entity)) {
            return (R)((Entity)this.entityToMapping.get(entity));
        }
        Entity family = (Entity)BeanUtils.instantiate(this.getEntityMappedFormType());
        this.entityToMapping.put(entity, family);
        MappingConfigurationBuilder builder = this.createConfigurationBuilder(entity, family);
        if (this.defaultMapping != null) {
            this.evaluateWithContext(builder, this.defaultMapping);
        }
        if (this.defaultConstraints != null) {
            this.evaluateWithContext(builder, this.defaultConstraints);
        }
        List<Object> values = ClassPropertyFetcher.getStaticPropertyValuesFromInheritanceHierarchy(entity.getJavaClass(), "mapping", Object.class);
        for (Object value : values) {
            if (value instanceof MappingDefinition) {
                MappingDefinition definition = (MappingDefinition)value;
                definition.configure(family);
                continue;
            }
            if (!(value instanceof Closure)) continue;
            this.evaluateWithContext(builder, (Closure)value);
        }
        List<Closure> constraintValues = ClassPropertyFetcher.getStaticPropertyValuesFromInheritanceHierarchy(entity.getJavaClass(), "constraints", Closure.class);
        for (Closure value : constraintValues) {
            this.evaluateWithContext(builder, value);
        }
        Map properties = builder.getProperties();
        this.entityToPropertyMap.put(entity, properties);
        return (R)family;
    }

    protected void evaluateWithContext(MappingConfigurationBuilder builder, Closure value) {
        if (this.contextObject != null) {
            builder.evaluate(value, this.contextObject);
        } else {
            builder.evaluate(value);
        }
    }

    protected MappingConfigurationBuilder createConfigurationBuilder(PersistentEntity entity, R family) {
        ((Entity)family).setVersion(this.versionByDefault);
        return new DefaultMappingConfigurationBuilder((Entity)family, this.getPropertyMappedFormType());
    }

    public void setDefaultMapping(Closure defaultMapping) {
        this.defaultMapping = defaultMapping;
    }

    protected abstract Class<T> getPropertyMappedFormType();

    protected abstract Class<R> getEntityMappedFormType();

    @Override
    public boolean isTenantId(PersistentEntity entity, MappingContext context, PropertyDescriptor descriptor) {
        if (entity.isMultiTenant()) {
            Map<String, T> props = this.entityToPropertyMap.get(entity);
            if (props != null && props.containsKey("tenantId")) {
                Property tenantIdProp = (Property)props.get("tenantId");
                String propertyName = tenantIdProp.getName();
                if (descriptor.getName().equals(propertyName)) {
                    return true;
                }
            } else {
                return descriptor.getName().equals("tenantId");
            }
        }
        return false;
    }

    @Override
    public IdentityMapping createIdentityMapping(ClassMapping classMapping) {
        Property property;
        IdentityMapping customIdentityMapping;
        Map<String, T> props = this.entityToPropertyMap.get(classMapping.getEntity());
        if (props != null && (customIdentityMapping = this.getIdentityMappedForm(classMapping, property = (Property)props.get("id"))) != null) {
            return customIdentityMapping;
        }
        return super.createIdentityMapping(classMapping);
    }

    protected IdentityMapping getIdentityMappedForm(ClassMapping classMapping, T property) {
        if (property != null) {
            return this.createDefaultIdentityMapping(classMapping, property);
        }
        return this.createDefaultIdentityMapping(classMapping);
    }

    @Override
    public T createMappedForm(PersistentProperty mpp) {
        Property defaultMapping;
        Property property;
        Map<String, T> properties = this.entityToPropertyMap.get(mpp.getOwner());
        if (properties != null && properties.containsKey(mpp.getName())) {
            return (T)((Property)properties.get(mpp.getName()));
        }
        if (properties != null && (property = (Property)properties.get("id")) != null && mpp.getName().equals(property.getName())) {
            return (T)property;
        }
        Property property2 = defaultMapping = properties != null ? (Property)properties.get("*") : null;
        if (defaultMapping != null) {
            try {
                return (T)defaultMapping.clone();
            }
            catch (CloneNotSupportedException e) {
                return (T)((Property)BeanUtils.instantiate(this.getPropertyMappedFormType()));
            }
        }
        return (T)((Property)BeanUtils.instantiate(this.getPropertyMappedFormType()));
    }
}

