/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.upload.ApiPreconditionCheckerHook;
import org.openstreetmap.josm.actions.upload.DiscardTagsHook;
import org.openstreetmap.josm.actions.upload.FixDataHook;
import org.openstreetmap.josm.actions.upload.RelationUploadOrderHook;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.actions.upload.ValidateUploadHook;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.gui.io.UploadPrimitivesTask;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class UploadAction
extends JosmAction {
    private static final List<UploadHook> UPLOAD_HOOKS = new LinkedList<UploadHook>();
    private static final List<UploadHook> LATE_UPLOAD_HOOKS = new LinkedList<UploadHook>();

    public static void registerUploadHook(UploadHook hook) {
        UploadAction.registerUploadHook(hook, false);
    }

    public static void registerUploadHook(UploadHook hook, boolean late) {
        if (hook == null) {
            return;
        }
        if (late) {
            if (!LATE_UPLOAD_HOOKS.contains(hook)) {
                LATE_UPLOAD_HOOKS.add(0, hook);
            }
        } else if (!UPLOAD_HOOKS.contains(hook)) {
            UPLOAD_HOOKS.add(0, hook);
        }
    }

    public static void unregisterUploadHook(UploadHook hook) {
        if (hook == null) {
            return;
        }
        if (UPLOAD_HOOKS.contains(hook)) {
            UPLOAD_HOOKS.remove(hook);
        }
        if (LATE_UPLOAD_HOOKS.contains(hook)) {
            LATE_UPLOAD_HOOKS.remove(hook);
        }
    }

    public UploadAction() {
        super(I18n.tr("Upload data", new Object[0]), "upload", I18n.tr("Upload all changes in the active data layer to the OSM server", new Object[0]), Shortcut.registerShortcut("file:upload", I18n.tr("File: {0}", I18n.tr("Upload data", new Object[0])), 38, 5009), true);
        this.putValue("help", HelpUtil.ht("/Action/Upload"));
    }

    @Override
    protected void updateEnabledState() {
        OsmDataLayer editLayer = this.getLayerManager().getEditLayer();
        this.setEnabled(editLayer != null && editLayer.isUploadable());
    }

    public static boolean checkPreUploadConditions(AbstractModifiableLayer layer) {
        return UploadAction.checkPreUploadConditions(layer, layer instanceof OsmDataLayer ? new APIDataSet(((OsmDataLayer)layer).data) : null);
    }

    protected static void alertUnresolvedConflicts(OsmDataLayer layer) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>The data to be uploaded participates in unresolved conflicts of layer ''{0}''.<br>You have to resolve them first.</html>", Utils.escapeReservedCharactersHTML(layer.getName())), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Action/Upload#PrimitivesParticipateInConflicts"));
    }

    public static boolean warnUploadDiscouraged(AbstractModifiableLayer layer) {
        return GuiHelper.warnUser(I18n.tr("Upload discouraged", new Object[0]), "<html>" + I18n.tr("You are about to upload data from the layer ''{0}''.<br /><br />Sending data from this layer is <b>strongly discouraged</b>. If you continue,<br />it may require you subsequently have to revert your changes, or force other contributors to.<br /><br />Are you sure you want to continue?", Utils.escapeReservedCharactersHTML(layer.getName())) + "</html>", ImageProvider.get("upload"), I18n.tr("Ignore this hint and upload anyway", new Object[0]));
    }

    public static boolean checkPreUploadConditions(AbstractModifiableLayer layer, APIDataSet apiData) {
        OsmDataLayer osmLayer;
        ConflictCollection conflicts;
        if (layer.isUploadDiscouraged() && UploadAction.warnUploadDiscouraged(layer)) {
            return false;
        }
        if (layer instanceof OsmDataLayer && apiData.participatesInConflict(conflicts = (osmLayer = (OsmDataLayer)layer).getConflicts())) {
            UploadAction.alertUnresolvedConflicts(osmLayer);
            return false;
        }
        if (apiData != null) {
            for (UploadHook hook : UPLOAD_HOOKS) {
                if (hook.checkUpload(apiData)) continue;
                return false;
            }
        }
        return true;
    }

    public void uploadData(OsmDataLayer layer, APIDataSet apiData) {
        if (apiData.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No changes to upload.", new Object[0]), I18n.tr("Warning", new Object[0]), 1);
            return;
        }
        if (!UploadAction.checkPreUploadConditions(layer, apiData)) {
            return;
        }
        UploadDialog dialog = UploadDialog.getUploadDialog();
        dialog.setChangesetTags(layer.data);
        dialog.setUploadedPrimitives(apiData);
        dialog.setVisible(true);
        dialog.rememberUserInput();
        if (dialog.isCanceled()) {
            return;
        }
        for (UploadHook hook : LATE_UPLOAD_HOOKS) {
            if (hook.checkUpload(apiData)) continue;
            return;
        }
        MainApplication.worker.execute(new UploadPrimitivesTask(UploadDialog.getUploadDialog().getUploadStrategySpecification(), layer, apiData, UploadDialog.getUploadDialog().getChangeset()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (MainApplication.getMap() == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Nothing to upload. Get some data first.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        APIDataSet apiData = new APIDataSet(this.getLayerManager().getEditDataSet());
        this.uploadData(this.getLayerManager().getEditLayer(), apiData);
    }

    static {
        UPLOAD_HOOKS.add(new ValidateUploadHook());
        UPLOAD_HOOKS.add(new FixDataHook());
        UPLOAD_HOOKS.add(new ApiPreconditionCheckerHook());
        UPLOAD_HOOKS.add(new RelationUploadOrderHook());
        LATE_UPLOAD_HOOKS.add(new DiscardTagsHook());
    }
}

