/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.visitor.paint;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.tools.Utils;

public class OffsetIterator
implements Iterator<MapViewState.MapViewPoint> {
    private final MapViewState mapState;
    private final List<MapViewState.MapViewPoint> nodes;
    private final double offset;
    private int idx;
    private MapViewState.MapViewPoint prev;
    private double xPrev0;
    private double yPrev0;

    public OffsetIterator(List<MapViewState.MapViewPoint> nodes, double offset) {
        if (nodes.size() < 2) {
            throw new IllegalArgumentException("There must be at least 2 nodes.");
        }
        this.mapState = nodes.get(0).getMapViewState();
        this.nodes = nodes;
        this.offset = offset;
    }

    public OffsetIterator(MapViewState mapState, List<Node> nodes, double offset) {
        this.mapState = mapState;
        this.nodes = nodes.stream().filter(Node::isLatLonKnown).map(mapState::getPointFor).collect(Collectors.toList());
        this.offset = offset;
    }

    @Override
    public boolean hasNext() {
        return this.idx < this.nodes.size();
    }

    @Override
    public MapViewState.MapViewPoint next() {
        double dyI;
        double dxI;
        double lenISq;
        double dyNext;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        MapViewState.MapViewPoint current = this.getForIndex(this.idx);
        if (Math.abs(this.offset) < 0.1) {
            ++this.idx;
            return current;
        }
        double xCurrent = current.getInViewX();
        double yCurrent = current.getInViewY();
        if (this.idx == this.nodes.size() - 1) {
            ++this.idx;
            if (this.prev != null) {
                return this.mapState.getForView(this.xPrev0 + xCurrent - this.prev.getInViewX(), this.yPrev0 + yCurrent - this.prev.getInViewY());
            }
            return current;
        }
        MapViewState.MapViewPoint next = this.getForIndex(this.idx + 1);
        double dxNext = next.getInViewX() - xCurrent;
        double lenNext = Math.sqrt(dxNext * dxNext + (dyNext = next.getInViewY() - yCurrent) * dyNext);
        if (lenNext < 1.0E-11) {
            lenNext = 1.0;
        }
        double om = this.offset / lenNext;
        double xCurrent0 = xCurrent + om * dyNext;
        double yCurrent0 = yCurrent - om * dxNext;
        if (this.idx == 0) {
            ++this.idx;
            this.prev = current;
            this.xPrev0 = xCurrent0;
            this.yPrev0 = yCurrent0;
            return this.mapState.getForView(xCurrent0, yCurrent0);
        }
        double dxPrev = xCurrent - this.prev.getInViewX();
        double dyPrev = yCurrent - this.prev.getInViewY();
        double det = dxNext * dyPrev - dxPrev * dyNext;
        double m = dxNext * (yCurrent0 - this.yPrev0) - dyNext * (xCurrent0 - this.xPrev0);
        if (Utils.equalsEpsilon(det, 0.0) || Math.signum(det) != Math.signum(m)) {
            ++this.idx;
            this.prev = current;
            this.xPrev0 = xCurrent0;
            this.yPrev0 = yCurrent0;
            return this.mapState.getForView(xCurrent0, yCurrent0);
        }
        double f = m / det;
        if (f < 0.0) {
            ++this.idx;
            this.prev = current;
            this.xPrev0 = xCurrent0;
            this.yPrev0 = yCurrent0;
            return this.mapState.getForView(xCurrent0, yCurrent0);
        }
        double cx = this.xPrev0 + f * dxPrev;
        double cy = this.yPrev0 + f * dyPrev;
        if (f > 1.0 && (lenISq = (dxI = cx - xCurrent) * dxI + (dyI = cy - yCurrent) * dyI) > Math.abs(2.0 * this.offset * this.offset)) {
            double dxPrev0 = xCurrent0 - this.xPrev0;
            double dyPrev0 = yCurrent0 - this.yPrev0;
            double lenPrev0 = Math.sqrt(dxPrev0 * dxPrev0 + dyPrev0 * dyPrev0);
            f = 1.0 + Math.abs(this.offset / lenPrev0);
            double cxCap = this.xPrev0 + f * dxPrev;
            double cyCap = this.yPrev0 + f * dyPrev;
            this.xPrev0 = cxCap;
            this.yPrev0 = cyCap;
            double lenI = Math.sqrt(lenISq);
            double xv = xCurrent + dyI / lenI;
            double yv = yCurrent - dxI / lenI;
            this.prev = this.mapState.getForView(xv, yv);
            return this.mapState.getForView(cxCap, cyCap);
        }
        ++this.idx;
        this.prev = current;
        this.xPrev0 = xCurrent0;
        this.yPrev0 = yCurrent0;
        return this.mapState.getForView(cx, cy);
    }

    private MapViewState.MapViewPoint getForIndex(int i) {
        return this.nodes.get(i);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

