/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.IExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class ExtendedDialog
extends JDialog
implements IExtendedDialog {
    private final boolean disposeOnClose;
    private volatile int result;
    public static final int DialogClosedOtherwise = 0;
    private boolean toggleable;
    private String rememberSizePref = "";
    private transient WindowGeometry defaultWindowGeometry;
    private String togglePref = "";
    private int toggleValue = -1;
    private ConditionalOptionPaneUtil.MessagePanel togglePanel;
    private Component parent;
    private Component content;
    private final String[] bTexts;
    private String[] bToolTipTexts;
    private transient Icon[] bIcons;
    private Set<Integer> cancelButtonIdx = Collections.emptySet();
    private int defaultButtonIdx = 1;
    protected JButton defaultButton;
    private transient Icon icon;
    private boolean modal;
    private boolean focusOnDefaultButton;
    private boolean showHelpButton;
    private String helpTopic;
    private boolean placeContentInScrollPane;
    protected transient Insets contentInsets = new Insets(10, 5, 0, 5);
    protected transient List<JButton> buttons = new ArrayList<JButton>();
    private boolean setupDone;

    public ExtendedDialog(Component parent, String title, String ... buttonTexts) {
        this(parent, title, buttonTexts, true, true);
    }

    public ExtendedDialog(Component parent, String title, String[] buttonTexts, boolean modal) {
        this(parent, title, buttonTexts, modal, true);
    }

    public ExtendedDialog(Component parent, String title, String[] buttonTexts, boolean modal, boolean disposeOnClose) {
        super((Window)ExtendedDialog.searchRealParent(parent), title, modal ? Dialog.ModalityType.DOCUMENT_MODAL : Dialog.ModalityType.MODELESS);
        this.parent = parent;
        this.modal = modal;
        this.bTexts = Utils.copyArray(buttonTexts);
        if (disposeOnClose) {
            this.setDefaultCloseOperation(2);
        }
        this.disposeOnClose = disposeOnClose;
    }

    private static Frame searchRealParent(Component parent) {
        if (parent == null) {
            return null;
        }
        return GuiHelper.getFrameForComponent(parent);
    }

    @Override
    public ExtendedDialog setButtonIcons(Icon ... buttonIcons) {
        this.bIcons = Utils.copyArray(buttonIcons);
        return this;
    }

    @Override
    public ExtendedDialog setButtonIcons(String ... buttonIcons) {
        this.bIcons = new Icon[buttonIcons.length];
        for (int i = 0; i < buttonIcons.length; ++i) {
            this.bIcons[i] = ImageProvider.get(buttonIcons[i]);
        }
        return this;
    }

    @Override
    public ExtendedDialog setToolTipTexts(String ... toolTipTexts) {
        this.bToolTipTexts = Utils.copyArray(toolTipTexts);
        return this;
    }

    @Override
    public ExtendedDialog setContent(Component content) {
        return this.setContent(content, true);
    }

    @Override
    public ExtendedDialog setContent(Component content, boolean placeContentInScrollPane) {
        this.content = content;
        this.placeContentInScrollPane = placeContentInScrollPane;
        return this;
    }

    @Override
    public ExtendedDialog setContent(String message) {
        return this.setContent(ExtendedDialog.string2label(message), false);
    }

    @Override
    public ExtendedDialog setIcon(Icon icon) {
        this.icon = icon;
        return this;
    }

    @Override
    public ExtendedDialog setIcon(int messageType) {
        switch (messageType) {
            case 0: {
                return this.setIcon(UIManager.getIcon("OptionPane.errorIcon"));
            }
            case 1: {
                return this.setIcon(UIManager.getIcon("OptionPane.informationIcon"));
            }
            case 2: {
                return this.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
            }
            case 3: {
                return this.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
            }
            case -1: {
                return this.setIcon(null);
            }
        }
        throw new IllegalArgumentException("Unknown message type!");
    }

    @Override
    public ExtendedDialog showDialog() {
        if (this.toggleCheckState()) {
            this.result = this.toggleValue;
            return this;
        }
        this.setupDialog();
        if (this.defaultButton != null) {
            this.getRootPane().setDefaultButton(this.defaultButton);
        }
        if (this.toggleable || this.focusOnDefaultButton) {
            this.requestFocusToDefaultButton();
        }
        this.setVisible(true);
        this.toggleSaveState();
        return this;
    }

    @Override
    public int getValue() {
        return this.result;
    }

    @Override
    public void setupDialog() {
        boolean limitedInHeight;
        if (this.setupDone) {
            return;
        }
        this.setupDone = true;
        this.setupEscListener();
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        for (int i = 0; i < this.bTexts.length; ++i) {
            JButton button = new JButton(this.createButtonAction(i));
            if (i == this.defaultButtonIdx - 1) {
                this.defaultButton = button;
            }
            if (this.bIcons != null && this.bIcons[i] != null) {
                button.setIcon(this.bIcons[i]);
            }
            if (this.bToolTipTexts != null && i < this.bToolTipTexts.length && this.bToolTipTexts[i] != null) {
                button.setToolTipText(this.bToolTipTexts[i]);
            }
            buttonsPanel.add((Component)button, GBC.std().insets(2, 2, 2, 2));
            this.buttons.add(button);
        }
        if (this.showHelpButton) {
            buttonsPanel.add((Component)new JButton(new HelpAction()), GBC.std().insets(2, 2, 2, 2));
            HelpUtil.setHelpContext(this.getRootPane(), this.helpTopic);
        }
        JPanel cp = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = 0;
        int y = 0;
        gc.gridy = y++;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        if (this.icon != null) {
            JLabel iconLbl = new JLabel(this.icon);
            gc.insets = new Insets(10, 10, 10, 10);
            gc.anchor = 11;
            gc.weighty = 1.0;
            cp.add((Component)iconLbl, gc);
            gc.anchor = 10;
            gc.gridx = 1;
        }
        gc.fill = 1;
        gc.insets = this.contentInsets;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        cp.add(this.content, gc);
        gc.fill = 0;
        gc.gridwidth = 0;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        if (this.toggleable) {
            this.togglePanel = new ConditionalOptionPaneUtil.MessagePanel((Object)null, ConditionalOptionPaneUtil.isInBulkOperation(this.togglePref));
            gc.gridx = this.icon != null ? 1 : 0;
            gc.gridy = y++;
            gc.anchor = 21;
            gc.insets = new Insets(5, this.contentInsets.left, 5, this.contentInsets.right);
            cp.add((Component)this.togglePanel, gc);
        }
        gc.gridy = y;
        gc.anchor = 10;
        gc.insets = new Insets(5, 5, 5, 5);
        cp.add((Component)buttonsPanel, gc);
        if (this.placeContentInScrollPane) {
            JScrollPane pane = new JScrollPane(cp);
            GuiHelper.setDefaultIncrement(pane);
            pane.setBorder(null);
            this.setContentPane(pane);
        } else {
            this.setContentPane(cp);
        }
        this.pack();
        Dimension d = this.getSize();
        Dimension x = this.findMaxDialogSize();
        boolean limitedInWidth = d.width > x.width;
        boolean bl = limitedInHeight = d.height > x.height;
        if (x.width > 0 && d.width > x.width) {
            d.width = x.width;
        }
        if (x.height > 0 && d.height > x.height) {
            d.height = x.height;
        }
        if (!limitedInWidth && limitedInHeight) {
            d.width += new JScrollBar().getPreferredSize().width;
        }
        this.setSize(d);
        this.setLocationRelativeTo(this.parent);
    }

    protected Action createButtonAction(final int i) {
        return new AbstractAction(this.bTexts[i]){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExtendedDialog.this.buttonAction(i, evt);
            }
        };
    }

    protected void buttonAction(int buttonIndex, ActionEvent evt) {
        this.result = buttonIndex + 1;
        this.setVisible(false);
    }

    protected Dimension findMaxDialogSize() {
        Dimension screenSize = GuiHelper.getScreenSize();
        Dimension x = new Dimension(screenSize.width * 2 / 3, screenSize.height * 2 / 3);
        if (this.parent != null && this.parent.isVisible()) {
            x = GuiHelper.getFrameForComponent(this.parent).getSize();
        }
        return x;
    }

    private void setupEscListener() {
        AbstractAction actionListener = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExtendedDialog.this.result = 0;
                if (Logging.isDebugEnabled()) {
                    Logging.debug("{0} ESC action performed ({1}) from {2}", this.getClass().getName(), actionEvent, new Exception().getStackTrace()[1]);
                }
                ExtendedDialog.this.setVisible(false);
            }
        };
        InputMapUtils.addEscapeAction(this.getRootPane(), actionListener);
    }

    protected final void rememberWindowGeometry(WindowGeometry geometry) {
        if (geometry != null) {
            geometry.remember(this.rememberSizePref);
        }
    }

    protected final WindowGeometry initWindowGeometry() {
        return new WindowGeometry(this.rememberSizePref, this.defaultWindowGeometry);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.repaint();
        }
        if (Logging.isDebugEnabled()) {
            Logging.debug(this.getClass().getName() + ".setVisible(" + visible + ") from " + new Exception().getStackTrace()[1]);
        }
        if (!this.rememberSizePref.isEmpty() && this.defaultWindowGeometry != null) {
            if (visible) {
                this.initWindowGeometry().applySafe(this);
            } else if (this.isShowing()) {
                this.rememberWindowGeometry(new WindowGeometry(this));
            }
        }
        super.setVisible(visible);
        if (!visible && this.disposeOnClose) {
            this.dispose();
        }
    }

    @Override
    public ExtendedDialog setRememberWindowGeometry(String pref2, WindowGeometry wg) {
        this.rememberSizePref = pref2 == null ? "" : pref2;
        this.defaultWindowGeometry = wg;
        return this;
    }

    @Override
    public ExtendedDialog toggleEnable(String togglePref) {
        if (!this.modal) {
            throw new IllegalStateException();
        }
        this.toggleable = true;
        this.togglePref = togglePref;
        return this;
    }

    @Override
    public ExtendedDialog setDefaultButton(int defaultButtonIdx) {
        this.defaultButtonIdx = defaultButtonIdx;
        return this;
    }

    @Override
    public ExtendedDialog setCancelButton(Integer ... cancelButtonIdx) {
        this.cancelButtonIdx = new HashSet<Integer>(Arrays.asList(cancelButtonIdx));
        return this;
    }

    @Override
    public void setFocusOnDefaultButton(boolean focus) {
        this.focusOnDefaultButton = focus;
    }

    private void requestFocusToDefaultButton() {
        if (this.defaultButton != null) {
            GuiHelper.runInEDT(this.defaultButton::requestFocusInWindow);
        }
    }

    @Override
    public final boolean toggleCheckState() {
        this.toggleable = this.togglePref != null && !this.togglePref.isEmpty();
        this.toggleValue = ConditionalOptionPaneUtil.getDialogReturnValue(this.togglePref);
        return this.toggleable && this.toggleValue != -1;
    }

    protected void toggleSaveState() {
        if (!this.toggleable || this.togglePanel == null || this.cancelButtonIdx.contains(this.result) || this.result == 0) {
            return;
        }
        this.togglePanel.getNotShowAgain().store(this.togglePref, this.result);
    }

    private static JMultilineLabel string2label(String msg) {
        JMultilineLabel lbl = new JMultilineLabel(msg);
        Dimension screenSize = GuiHelper.getScreenSize();
        lbl.setMaxWidth(screenSize.width / 2);
        lbl.getInputMap().put(KeyStroke.getKeyStroke(10, 0), new Object());
        return lbl;
    }

    @Override
    public ExtendedDialog configureContextsensitiveHelp(String helpTopic, boolean showHelpButton) {
        this.helpTopic = helpTopic;
        this.showHelpButton = showHelpButton;
        return this;
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("ShortDescription", I18n.tr("Show help information", new Object[0]));
            this.putValue("Name", I18n.tr("Help", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("help"));
            this.setEnabled(!Main.isOffline(OnlineResource.JOSM_WEBSITE));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HelpBrowser.setUrlForHelpTopic(ExtendedDialog.this.helpTopic);
        }
    }
}

