/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.openstreetmap.josm.actions.mapmode.DeleteAction;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.dialogs.relation.GenericRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.IRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.actions.AbstractRelationEditorAction;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class DeleteCurrentRelationAction
extends AbstractRelationEditorAction
implements PropertyChangeListener {
    public DeleteCurrentRelationAction(OsmDataLayer layer, IRelationEditor editor) {
        super(null, null, null, layer, editor);
        this.putValue("ShortDescription", I18n.tr("Delete the currently edited relation", new Object[0]));
        this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
        this.putValue("Name", I18n.tr("Delete", new Object[0]));
        this.updateEnabledState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Relation toDelete = this.editor.getRelation();
        if (toDelete == null) {
            return;
        }
        DeleteAction.deleteRelation(this.layer, toDelete);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.editor.getRelationSnapshot() != null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (GenericRelationEditor.RELATION_SNAPSHOT_PROP.equals(evt.getPropertyName())) {
            this.updateEnabledState();
        }
    }
}

