/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.ConditionalOptionPaneUtil;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.Marker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.UncheckedParseException;
import org.openstreetmap.josm.tools.date.DateUtils;

public abstract class ConvertToDataLayerAction<T extends Layer>
extends AbstractAction {
    protected final transient T layer;

    protected ConvertToDataLayerAction(T layer) {
        super(I18n.tr("Convert to data layer", new Object[0]), ImageProvider.get("converttoosm"));
        this.layer = layer;
        this.putValue("help", HelpUtil.ht("/Action/ConvertToDataLayer"));
    }

    public abstract DataSet convert();

    @Override
    public void actionPerformed(ActionEvent e) {
        JPanel msg = new JPanel(new GridBagLayout());
        msg.add((Component)new JLabel(I18n.tr("<html>Upload of unprocessed GPS data as map data is considered harmful.<br>If you want to upload traces, look here:</html>", new Object[0])), GBC.eol());
        msg.add((Component)new UrlLabel(Main.getOSMWebsite() + "/traces", 2), GBC.eop());
        if (!ConditionalOptionPaneUtil.showConfirmationDialog("convert_to_data", Main.parent, msg, I18n.tr("Warning", new Object[0]), 2, 2, 0)) {
            return;
        }
        DataSet ds = this.convert();
        OsmDataLayer osmLayer = new OsmDataLayer(ds, I18n.tr("Converted from: {0}", ((Layer)this.layer).getName()), null);
        if (((Layer)this.layer).getAssociatedFile() != null) {
            osmLayer.setAssociatedFile(new File(((Layer)this.layer).getAssociatedFile().getParentFile(), ((Layer)this.layer).getAssociatedFile().getName() + ".osm"));
        }
        osmLayer.setUploadDiscouraged(true);
        MainApplication.getLayerManager().addLayer(osmLayer);
        MainApplication.getLayerManager().removeLayer((Layer)this.layer);
    }

    public static class FromMarkerLayer
    extends ConvertToDataLayerAction<MarkerLayer> {
        public FromMarkerLayer(MarkerLayer layer) {
            super(layer);
        }

        @Override
        public DataSet convert() {
            DataSet ds = new DataSet();
            for (Marker marker : ((MarkerLayer)this.layer).data) {
                Node node = new Node(marker.getCoor());
                List<String> mapping = Config.getPref().getList("gpx.to-osm-mapping", Arrays.asList("name", "name", "desc", "description", "cmt", "note", "src", "source", "sym", "gpxicon"));
                if (mapping.size() % 2 == 0) {
                    Iterator it = mapping.iterator();
                    while (it.hasNext()) {
                        String gpxKey = (String)it.next();
                        String osmKey = (String)it.next();
                        Optional.ofNullable(marker.getTemplateValue(gpxKey, false)).map(String::valueOf).ifPresent(s -> node.put(osmKey, (String)s));
                    }
                } else {
                    Logging.warn("Invalid gpx.to-osm-mapping Einstein setting: expecting even number of entries");
                }
                ds.addPrimitive(node);
            }
            return ds;
        }
    }

    public static class FromGpxLayer
    extends ConvertToDataLayerAction<GpxLayer> {
        public FromGpxLayer(GpxLayer layer) {
            super(layer);
        }

        @Override
        public DataSet convert() {
            DataSet ds = new DataSet();
            for (GpxTrack trk : ((GpxLayer)this.layer).data.getTracks()) {
                for (GpxTrackSegment segment : trk.getSegments()) {
                    ArrayList<Node> nodes = new ArrayList<Node>();
                    for (WayPoint p : segment.getWayPoints()) {
                        Node n = new Node(p.getCoor());
                        String timestr = p.getString("time");
                        if (timestr != null) {
                            try {
                                n.setTimestamp(DateUtils.fromString(timestr));
                            }
                            catch (UncheckedParseException e) {
                                Logging.log(Logging.LEVEL_WARN, e);
                            }
                        }
                        ds.addPrimitive(n);
                        nodes.add(n);
                    }
                    Way w = new Way();
                    w.setNodes(nodes);
                    ds.addPrimitive(w);
                }
            }
            return ds;
        }
    }
}

